/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.samples.wildfly.common;

import java.util.Properties;
import javax.batch.runtime.BatchStatus;
import org.jberet.rest.client.BatchClient;
import org.jberet.rest.entity.JobExecutionEntity;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.TestRule;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public abstract class BatchTestBase {
    protected static final String BASE_URL = "http://localhost:8080/";
    @Rule
    public TestRule watcher = new TestWatcher(){

        protected void starting(Description description) {
            System.out.printf("Starting test: %s%n", description.getMethodName());
        }
    };

    protected abstract BatchClient getBatchClient();

    protected JobExecutionEntity startJobCheckStatus(String jobName, Properties queryParams, long waitMillis, BatchStatus expectedBatchStatus) throws Exception {
        JobExecutionEntity jobExecution = this.getBatchClient().startJob(jobName, queryParams);
        return this.getCheckJobExecution(jobExecution.getExecutionId(), waitMillis, expectedBatchStatus);
    }

    protected void restartJobCheckStatus(String jobName, Properties queryParams, long waitMillis, BatchStatus expectedBatchStatus) throws Exception {
        JobExecutionEntity jobExecution = this.getBatchClient().restartJobExecution(jobName, queryParams);
        this.getCheckJobExecution(jobExecution.getExecutionId(), waitMillis, expectedBatchStatus);
    }

    private JobExecutionEntity getCheckJobExecution(long jobExecutionId, long waitMillis, BatchStatus expectedBatchStatus) throws Exception {
        Thread.sleep(waitMillis);
        JobExecutionEntity jobExecution2 = this.getBatchClient().getJobExecution(jobExecutionId);
        Assert.assertEquals((Object)expectedBatchStatus, (Object)jobExecution2.getBatchStatus());
        return jobExecution2;
    }
}

