package org.jboss.activemq.artemis.wildfly.integration.recovery;

import java.util.Locale;
import java.io.Serializable;
import javax.annotation.processing.Generated;
import org.jboss.logging.DelegatingBasicLogger;
import org.w3c.dom.Node;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.jboss.logging.BasicLogger;
import java.lang.Runnable;
import java.lang.Throwable;
import java.lang.Object;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
@Generated(value = "org.jboss.logging.processor.generator.model.MessageLoggerImplementor", date = "2024-10-28T13:31:03+0100")
public class WildFlyActiveMQLogger_$logger extends DelegatingBasicLogger implements WildFlyActiveMQLogger, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = WildFlyActiveMQLogger_$logger.class.getName();
    public WildFlyActiveMQLogger_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void serverRunningCachedCommand(final Runnable run) {
        super.log.logv(FQCN, INFO, null, serverRunningCachedCommand$str(), run);
    }
    protected String serverRunningCachedCommand$str() {
        return "AMQ121003: JMS Server Manager Running cached command for {0}";
    }
    @Override
    public final void serverCachingCommand(final Object runnable) {
        super.log.logv(FQCN, INFO, null, serverCachingCommand$str(), runnable);
    }
    protected String serverCachingCommand$str() {
        return "AMQ121004: JMS Server Manager Caching command for {0} since the JMS Server is not active yet";
    }
    @Override
    public final void invalidHostForConnector(final String name, final String newHost) {
        super.log.logv(FQCN, INFO, null, invalidHostForConnector$str(), name, newHost);
    }
    protected String invalidHostForConnector$str() {
        return "AMQ121005: Invalid \"host\" value \"0.0.0.0\" detected for \"{0}\" connector. Switching to \"{1}\". If this new address is incorrect please manually configure the connector to use the proper one.";
    }
    @Override
    public final void noQueueOnTopic(final String queueName, final String name) {
        super.log.logv(FQCN, WARN, null, noQueueOnTopic$str(), queueName, name);
    }
    protected String noQueueOnTopic$str() {
        return "AMQ122007: Queue {0} does not exist on the topic {1}. It was deleted manually probably.";
    }
    @Override
    public final void recoveryConnectFailed(final String s) {
        super.log.logv(FQCN, WARN, null, recoveryConnectFailed$str(), s);
    }
    protected String recoveryConnectFailed$str() {
        return "AMQ122008: XA Recovery can not connect to any ActiveMQ server on recovery {0}";
    }
    @Override
    public final void jndiUnbindError(final Exception e, final String key) {
        super.log.logv(FQCN, WARN, e, jndiUnbindError$str(), key);
    }
    protected String jndiUnbindError$str() {
        return "AMQ122011: error unbinding {0} from JNDI";
    }
    @Override
    public final void jmsServerError(final Exception e) {
        super.log.logv(FQCN, WARN, e, jmsServerError$str());
    }
    protected String jmsServerError$str() {
        return "AMQ122012: JMS Server Manager error";
    }
    @Override
    public final void xaRecoverError(final Exception e) {
        super.log.logv(FQCN, WARN, e, xaRecoverError$str());
    }
    protected String xaRecoverError$str() {
        return "AMQ122013: Error in XA Recovery recover";
    }
    @Override
    public final void xaRecoverConnectionError(final Exception e, final ClientSessionFactory csf) {
        super.log.logv(FQCN, WARN, e, xaRecoverConnectionError$str(), csf);
    }
    protected String xaRecoverConnectionError$str() {
        return "AMQ122014: Notified of connection failure in xa recovery connectionFactory for provider {0} will attempt reconnect on next pass";
    }
    @Override
    public final void xaRecoverAutoConnectionError(final Throwable e, final XARecoveryConfig csf) {
        super.log.logv(FQCN, WARN, e, xaRecoverAutoConnectionError$str(), csf);
    }
    protected String xaRecoverAutoConnectionError$str() {
        return "AMQ122015: Can not connect to {0} on auto-generated resource recovery";
    }
    @Override
    public final void xaRecoveryError(final Exception e) {
        super.log.logv(FQCN, DEBUG, e, xaRecoveryError$str());
    }
    protected String xaRecoveryError$str() {
        return "AMQ122016: Error in XA Recovery";
    }
    @Override
    public final void failedToCorrectHost(final Exception e, final String name) {
        super.log.logv(FQCN, WARN, e, failedToCorrectHost$str(), name);
    }
    protected String failedToCorrectHost$str() {
        return "AMQ122017: Tried to correct invalid \"host\" value \"0.0.0.0\" for \"{0}\" connector, but received an exception.";
    }
    @Override
    public final void xaRecoveryStartError(final XARecoveryConfig e) {
        super.log.logv(FQCN, WARN, null, xaRecoveryStartError$str(), e);
    }
    protected String xaRecoveryStartError$str() {
        return "AMQ122018: Could not start recovery discovery on {0}, we will retry every recovery scan until the server is available";
    }
    @Override
    public final void jmsConfigMissingKey(final Node e) {
        super.log.logv(FQCN, ERROR, null, jmsConfigMissingKey$str(), e);
    }
    protected String jmsConfigMissingKey$str() {
        return "AMQ124000: key attribute missing for JMS configuration {0}";
    }
    @Override
    public final void jmsDeployerStartError(final Exception e) {
        super.log.logv(FQCN, ERROR, e, jmsDeployerStartError$str());
    }
    protected String jmsDeployerStartError$str() {
        return "AMQ124002: Failed to start JMS deployer";
    }
}
