/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.impl.AddressFullMessagePolicy;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.protocol.amqp.converter.AMQPMessageSupport;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.integration.amqp.AmqpTestSupport;
import org.apache.activemq.transport.amqp.AmqpSupport;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeleteOnClose;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class AmqpClientTestSupport
extends AmqpTestSupport {
    protected static final Symbol SHARED = Symbol.getSymbol((String)"shared");
    protected static final Symbol GLOBAL = Symbol.getSymbol((String)"global");
    protected ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        for (AmqpConnection conn : this.connections) {
            try {
                conn.close();
            }
            catch (Throwable ignored) {
                ignored.printStackTrace();
            }
        }
        this.connections.clear();
        try {
            if (this.server != null) {
                this.server.stop();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected boolean isAutoCreateQueues() {
        return true;
    }

    protected boolean isAutoCreateAddresses() {
        return true;
    }

    protected boolean isSecurityEnabled() {
        return false;
    }

    protected String getDeadLetterAddress() {
        return "ActiveMQ.DLQ";
    }

    protected int getPrecreatedQueueSize() {
        return 10;
    }

    public URI getBrokerOpenWireConnectionURI() {
        try {
            String uri = null;
            uri = this.isUseSSL() ? "ssl://127.0.0.1:5672" : "tcp://127.0.0.1:5672";
            return new URI(uri);
        }
        catch (Exception e) {
            throw new RuntimeException();
        }
    }

    protected ActiveMQServer createServer() throws Exception {
        return this.createServer(5672);
    }

    protected ActiveMQServer createServer(int port) throws Exception {
        return this.createServer(port, true);
    }

    @Override
    protected void configureAddressPolicy(ActiveMQServer server) {
        AddressSettings addressSettings = new AddressSettings();
        addressSettings.setAddressFullMessagePolicy(AddressFullMessagePolicy.PAGE);
        addressSettings.setAutoCreateQueues(Boolean.valueOf(this.isAutoCreateQueues()));
        addressSettings.setAutoCreateAddresses(Boolean.valueOf(this.isAutoCreateAddresses()));
        addressSettings.setDeadLetterAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        addressSettings.setExpiryAddress(SimpleString.of((String)this.getDeadLetterAddress()));
        server.getConfiguration().getAddressSettings().put("#", addressSettings);
        Set acceptors = server.getConfiguration().getAcceptorConfigurations();
        for (TransportConfiguration tc : acceptors) {
            if (!tc.getName().equals("netty-acceptor")) continue;
            tc.getExtraParams().put("anycastPrefix", "anycast://");
            tc.getExtraParams().put("multicastPrefix", "multicast://");
        }
    }

    @Override
    protected void createAddressAndQueues(ActiveMQServer server) throws Exception {
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)this.getQueueName()), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)this.getQueueName()).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)this.getDeadLetterAddress()), RoutingType.ANYCAST));
        server.createQueue(QueueConfiguration.of((String)this.getDeadLetterAddress()).setRoutingType(RoutingType.ANYCAST));
        server.addAddressInfo(new AddressInfo(SimpleString.of((String)this.getTopicName()), RoutingType.MULTICAST));
        server.createQueue(QueueConfiguration.of((String)this.getTopicName()));
        for (int i = 0; i < this.getPrecreatedQueueSize(); ++i) {
            server.addAddressInfo(new AddressInfo(SimpleString.of((String)this.getQueueName(i)), RoutingType.ANYCAST));
            server.createQueue(QueueConfiguration.of((String)this.getQueueName(i)).setRoutingType(RoutingType.ANYCAST));
        }
    }

    @Override
    protected void configureBrokerSecurity(ActiveMQServer server) {
        if (this.isSecurityEnabled()) {
            this.enableSecurity(server, new String[0]);
        } else {
            server.getConfiguration().setSecurityEnabled(false);
        }
    }

    protected void enableSecurity(ActiveMQServer server, String ... securityMatches) {
        ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)server.getSecurityManager();
        securityManager.getConfiguration().addUser(this.noprivUser, this.noprivPass);
        securityManager.getConfiguration().addRole(this.noprivUser, "nothing");
        securityManager.getConfiguration().addUser(this.browseUser, this.browsePass);
        securityManager.getConfiguration().addRole(this.browseUser, "browser");
        securityManager.getConfiguration().addUser(this.guestUser, this.guestPass);
        securityManager.getConfiguration().addRole(this.guestUser, "guest");
        securityManager.getConfiguration().addUser(this.fullUser, this.fullPass);
        securityManager.getConfiguration().addRole(this.fullUser, "full");
        HierarchicalRepository securityRepository = server.getSecurityRepository();
        HashSet<Role> value = new HashSet<Role>();
        value.add(new Role("nothing", false, false, false, false, false, false, false, false, false, false, false, false));
        value.add(new Role("browser", false, false, false, false, false, false, false, true, false, false, false, false));
        value.add(new Role("guest", false, true, false, false, false, false, false, true, false, false, false, false));
        value.add(new Role("full", true, true, true, true, true, true, true, true, true, true, false, false));
        securityRepository.addMatch(this.getQueueName(), value);
        for (String match : securityMatches) {
            securityRepository.addMatch(match, value);
        }
        server.getConfiguration().setSecurityEnabled(true);
    }

    public Queue getProxyToQueue(String queueName) {
        return this.server.locateQueue(SimpleString.of((String)queueName));
    }

    public String getTestName() {
        return this.getName();
    }

    public String getTopicName() {
        return this.getName() + "-Topic";
    }

    public String getQueueName() {
        return this.getName();
    }

    public String getQueueName(int index) {
        return this.getName() + "-" + index;
    }

    protected void sendMessages(String destinationName, int count) throws Exception {
        this.sendMessages(destinationName, count, null);
    }

    protected void sendMessages(String destinationName, int count, RoutingType routingType) throws Exception {
        this.sendMessages(destinationName, count, routingType, false);
    }

    protected void sendMessages(String destinationName, int count, RoutingType routingType, boolean durable) throws Exception {
        this.sendMessages(destinationName, count, routingType, durable, Collections.emptyMap());
    }

    protected void setData(AmqpMessage amqpMessage) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessages(String destinationName, int count, RoutingType routingType, boolean durable, Map<String, Object> applicationProperties) throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(destinationName);
            for (int i = 0; i < count; ++i) {
                AmqpMessage message = new AmqpMessage();
                for (Map.Entry<String, Object> entry : applicationProperties.entrySet()) {
                    message.setApplicationProperty(entry.getKey(), entry.getValue());
                }
                message.setMessageId("MessageID:" + i);
                message.setDurable(durable);
                if (routingType != null) {
                    message.setMessageAnnotation(AMQPMessageSupport.ROUTING_TYPE.toString(), routingType.getType());
                }
                this.setData(message);
                sender.send(message);
            }
        }
    }

    protected void sendMessages(String destinationName, int count, boolean durable) throws Exception {
        this.sendMessages(destinationName, count, durable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessages(String destinationName, int count, boolean durable, byte[] payload) throws Exception {
        AmqpClient client = this.createAmqpClient();
        try (AmqpConnection connection = this.addConnection(client.connect());){
            AmqpSession session = connection.createSession();
            AmqpSender sender = session.createSender(destinationName);
            for (int i = 0; i < count; ++i) {
                AmqpMessage message = new AmqpMessage();
                message.setMessageId("MessageID:" + i);
                message.setDurable(durable);
                if (payload != null) {
                    message.setBytes(payload);
                }
                sender.send(message);
            }
        }
    }

    protected void sendMessagesCore(String destinationName, int count, boolean durable) throws Exception {
        this.sendMessagesCore(destinationName, count, durable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessagesCore(String destinationName, int count, boolean durable, byte[] body) throws Exception {
        ServerLocator serverLocator = ActiveMQClient.createServerLocator((String)"tcp://127.0.0.1:5672");
        ClientSessionFactory clientSessionFactory = serverLocator.createSessionFactory();
        try (ClientSession session = clientSessionFactory.createSession();){
            ClientProducer sender = session.createProducer(destinationName);
            for (int i = 0; i < count; ++i) {
                ClientMessage message = session.createMessage(durable);
                if (body != null) {
                    message.getBodyBuffer().writeBytes(body);
                }
                sender.send((org.apache.activemq.artemis.api.core.Message)message);
            }
        }
    }

    protected void sendMessagesOpenWire(String destinationName, int count, boolean durable) throws Exception {
        this.sendMessagesOpenWire(destinationName, count, durable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMessagesOpenWire(String destinationName, int count, boolean durable, byte[] payload) throws Exception {
        ActiveMQConnectionFactory cf = new ActiveMQConnectionFactory("tcp://127.0.0.1:5672");
        Connection connection = cf.createConnection();
        Session session = connection.createSession(false, 1);
        try {
            MessageProducer producer = session.createProducer((Destination)session.createQueue(destinationName));
            if (durable) {
                producer.setDeliveryMode(2);
            } else {
                producer.setDeliveryMode(1);
            }
            for (int i = 0; i < count; ++i) {
                BytesMessage message = session.createBytesMessage();
                if (payload != null) {
                    message.writeBytes(payload);
                }
                producer.send((Message)message);
            }
        }
        finally {
            connection.close();
        }
    }

    protected Source createDynamicSource(boolean topic) {
        Source source = new Source();
        source.setDynamic(true);
        source.setDurable(TerminusDurability.NONE);
        source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        HashMap<Symbol, DeleteOnClose> dynamicNodeProperties = new HashMap<Symbol, DeleteOnClose>();
        dynamicNodeProperties.put(AmqpSupport.LIFETIME_POLICY, DeleteOnClose.getInstance());
        source.setDynamicNodeProperties(dynamicNodeProperties);
        if (!topic) {
            source.setCapabilities(new Symbol[]{AmqpSupport.TEMP_QUEUE_CAPABILITY});
        } else {
            source.setCapabilities(new Symbol[]{AmqpSupport.TEMP_TOPIC_CAPABILITY});
        }
        return source;
    }

    protected Target createDynamicTarget(boolean topic) {
        Target target = new Target();
        target.setDynamic(true);
        target.setDurable(TerminusDurability.NONE);
        target.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
        HashMap<Symbol, DeleteOnClose> dynamicNodeProperties = new HashMap<Symbol, DeleteOnClose>();
        dynamicNodeProperties.put(AmqpSupport.LIFETIME_POLICY, DeleteOnClose.getInstance());
        target.setDynamicNodeProperties(dynamicNodeProperties);
        if (!topic) {
            target.setCapabilities(new Symbol[]{AmqpSupport.TEMP_QUEUE_CAPABILITY});
        } else {
            target.setCapabilities(new Symbol[]{AmqpSupport.TEMP_TOPIC_CAPABILITY});
        }
        return target;
    }
}

