/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Random;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.tests.integration.amqp.JMSClientTestSupport;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class JMSAcknowledgeTest
extends JMSClientTestSupport {
    private static final String MSG_NUM = "MSG_NUM";
    private static final int INDIVIDUAL_ACK = 101;

    @Test
    @Timeout(value=60L)
    public void testConsumeIndividualMessagesOutOfOrder() throws Throwable {
        int i;
        Connection connection = this.createConnection();
        Session session = connection.createSession(false, 101);
        jakarta.jms.Queue queue = session.createQueue(this.getQueueName());
        int msgCount = 10;
        MessageProducer p = session.createProducer((Destination)queue);
        for (int i2 = 0; i2 < msgCount; ++i2) {
            TextMessage message = session.createTextMessage();
            message.setText("Message:" + i2);
            message.setIntProperty(MSG_NUM, i2);
            p.send((Message)message);
        }
        Queue queueView = this.getProxyToQueue(this.getQueueName());
        Wait.assertEquals((long)10L, () -> ((Queue)queueView).getMessageCount());
        MessageConsumer cons = session.createConsumer((Destination)queue);
        connection.start();
        ArrayList<TextMessage> messages = new ArrayList<TextMessage>();
        for (int i3 = 0; i3 < msgCount; ++i3) {
            TextMessage message = (TextMessage)cons.receive(5000L);
            Assertions.assertNotNull((Object)message, (String)("Message " + i3 + " was not received"));
            Assertions.assertEquals((int)i3, (int)message.getIntProperty(MSG_NUM), (String)"unexpected message number property");
            messages.add(message);
        }
        ArrayList<Integer> acknowledged = new ArrayList<Integer>();
        Random rand = new Random();
        for (i = 0; i < msgCount / 2; ++i) {
            Message msg = (Message)messages.remove(rand.nextInt(msgCount - i));
            int messageNumber = msg.getIntProperty(MSG_NUM);
            acknowledged.add(messageNumber);
            msg.acknowledge();
        }
        session.close();
        Wait.assertEquals((long)(msgCount / 2), () -> ((Queue)queueView).getMessageCount());
        session = connection.createSession(false, 101);
        cons = session.createConsumer((Destination)queue);
        for (i = 0; i < msgCount / 2; ++i) {
            TextMessage message = (TextMessage)cons.receive(5000L);
            Assertions.assertNotNull((Object)message, (String)("Message " + i + " was not received"));
            Message expectedMsg = (Message)messages.remove(0);
            int expectedMsgNum = expectedMsg.getIntProperty(MSG_NUM);
            Assertions.assertEquals((int)expectedMsgNum, (int)message.getIntProperty(MSG_NUM), (String)"unexpected message number property");
        }
    }
}

