/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cli;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.cli.commands.activation.ActivationSequenceList;
import org.apache.activemq.artemis.cli.commands.activation.ActivationSequenceSet;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.JournalType;
import org.apache.activemq.artemis.lockmanager.DistributedLock;
import org.apache.activemq.artemis.lockmanager.DistributedLockManager;
import org.apache.activemq.artemis.lockmanager.MutableLong;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.extensions.TargetTempDirFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.Wait;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ActivationSequenceCommandsTest
extends ActiveMQTestBase {
    @TempDir(factory=TargetTempDirFactory.class)
    public File brokersFolder;
    protected DistributedLockManagerConfiguration managerConfiguration;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", ActivationSequenceCommandsTest.newFolder(this.temporaryFolder, "manager").toString()));
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
    }

    protected Configuration createPrimaryConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::primary");
        File primaryDir = ActivationSequenceCommandsTest.newFolder(this.brokersFolder, "primary");
        conf.setBrokerInstance(primaryDir);
        conf.addAcceptorConfiguration("primary", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("primary", "tcp://localhost:61616");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        conf.setHAPolicyConfiguration(this.createReplicationPrimaryConfiguration());
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("backup");
        ccconf.setName("cluster");
        ccconf.setConnectorName("primary");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected Configuration createBackupConfiguration() throws Exception {
        ConfigurationImpl conf = new ConfigurationImpl();
        conf.setName("localhost::backup");
        File backupDir = ActivationSequenceCommandsTest.newFolder(this.brokersFolder, "backup");
        conf.setBrokerInstance(backupDir);
        conf.setHAPolicyConfiguration(this.createReplicationBackupConfiguration());
        conf.addAcceptorConfiguration("backup", "tcp://localhost:61617");
        conf.addConnectorConfiguration("live", "tcp://localhost:61616");
        conf.addConnectorConfiguration("backup", "tcp://localhost:61617");
        conf.setClusterUser("mycluster");
        conf.setClusterPassword("mypassword");
        ClusterConnectionConfiguration ccconf = new ClusterConnectionConfiguration();
        ccconf.setStaticConnectors(new ArrayList()).getStaticConnectors().add("live");
        ccconf.setName("cluster");
        ccconf.setConnectorName("backup");
        conf.addClusterConfiguration(ccconf);
        conf.setSecurityEnabled(false).setJMXManagementEnabled(false).setJournalType(JournalType.MAPPED).setJournalFileSize(524288).setConnectionTTLOverride(60000L);
        return conf;
    }

    protected HAPolicyConfiguration createReplicationPrimaryConfiguration() {
        ReplicationPrimaryPolicyConfiguration haPolicy = ReplicationPrimaryPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        return haPolicy;
    }

    protected HAPolicyConfiguration createReplicationBackupConfiguration() {
        ReplicationBackupPolicyConfiguration haPolicy = ReplicationBackupPolicyConfiguration.withDefault();
        haPolicy.setDistributedManagerConfiguration(this.managerConfiguration);
        haPolicy.setClusterName("cluster");
        return haPolicy;
    }

    @Test
    public void restorePrimaryCoordinatedSequence() throws Exception {
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        liveServer.setIdentity("PRIMARY");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        String nodeID = liveServer.getNodeID().toString();
        liveServer.stop();
        this.restoreCoordinatedSequence(primaryConfiguration, liveServer, nodeID, 1L);
    }

    @Test
    public void restoreBackupCoordinatedSequence() throws Exception {
        int timeout = (int)TimeUnit.SECONDS.toMillis(30L);
        Configuration liveConfiguration = this.createPrimaryConfiguration();
        ActiveMQServer primaryInstance = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)liveConfiguration));
        primaryInstance.setIdentity("PRIMARY");
        primaryInstance.start();
        Assertions.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Configuration backupConfiguration = this.createBackupConfiguration();
        ((ReplicationBackupPolicyConfiguration)backupConfiguration.getHAPolicyConfiguration()).setAllowFailBack(true);
        ActiveMQServer backupServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)backupConfiguration));
        backupServer.setIdentity("BACKUP");
        backupServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)backupServer).isStarted());
        Wait.assertTrue(() -> backupServer.isReplicaSync(), (long)timeout);
        Assertions.assertEquals((long)1L, (long)primaryInstance.getNodeManager().getNodeActivationSequence());
        Assertions.assertEquals((long)1L, (long)backupServer.getNodeManager().getNodeActivationSequence());
        primaryInstance.stop();
        Wait.assertTrue(() -> 2L == backupServer.getNodeManager().getNodeActivationSequence(), (long)timeout);
        String nodeId = backupServer.getNodeManager().getNodeId().toString();
        backupServer.stop();
        this.restoreCoordinatedSequence(backupConfiguration, backupServer, nodeId, 2L);
    }

    @Test
    public void restorePeerCoordinatedSequence() throws Exception {
        Configuration primaryConfiguration = this.createPrimaryConfiguration();
        ((ReplicationPrimaryPolicyConfiguration)primaryConfiguration.getHAPolicyConfiguration()).setCoordinationId("peer-id");
        ActiveMQServer liveServer = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)primaryConfiguration));
        liveServer.setIdentity("PRIMARY");
        liveServer.start();
        org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
        String nodeID = liveServer.getNodeID().toString();
        liveServer.stop();
        this.restoreCoordinatedSequence(primaryConfiguration, liveServer, nodeID, 1L);
    }

    private void restoreCoordinatedSequence(Configuration primaryConfiguration, ActiveMQServer liveServer, String nodeID, long expectedStartCoordinatedSequence) throws Exception {
        ActivationSequenceList sequenceList = new ActivationSequenceList();
        ActivationSequenceList.ListResult list = ActivationSequenceList.execute((ActivationSequenceList)sequenceList, (Configuration)primaryConfiguration, null);
        Assertions.assertEquals((long)expectedStartCoordinatedSequence, (long)list.coordinatedActivationSequence);
        Assertions.assertEquals((long)expectedStartCoordinatedSequence, (long)list.localActivationSequence);
        try (DistributedLockManager DistributedLockManager2 = DistributedLockManager.newInstanceOf((String)this.managerConfiguration.getClassName(), (Map)this.managerConfiguration.getProperties());){
            DistributedLockManager2.start();
            try (DistributedLock lock = DistributedLockManager2.getDistributedLock(nodeID);
                 MutableLong coordinatedActivationSequence = DistributedLockManager2.getMutableLong(nodeID);){
                Assertions.assertTrue((boolean)lock.tryLock());
                long activationSequence = coordinatedActivationSequence.get();
                Assertions.assertEquals((long)expectedStartCoordinatedSequence, (long)activationSequence);
                coordinatedActivationSequence.set(0L);
            }
            sequenceList.remote = true;
            Assertions.assertEquals((long)0L, (long)ActivationSequenceList.execute((ActivationSequenceList)sequenceList, (Configuration)primaryConfiguration, null).coordinatedActivationSequence);
            ActivationSequenceSet sequenceSet = new ActivationSequenceSet();
            sequenceSet.remote = true;
            sequenceSet.value = expectedStartCoordinatedSequence;
            ActivationSequenceSet.execute((ActivationSequenceSet)sequenceSet, (Configuration)primaryConfiguration, null);
            liveServer.start();
            org.apache.activemq.artemis.tests.util.Wait.waitFor(() -> ((ActiveMQServer)liveServer).isStarted());
            Assertions.assertTrue((boolean)liveServer.isActive());
            Assertions.assertEquals((long)(expectedStartCoordinatedSequence + 1L), (long)liveServer.getNodeManager().getNodeActivationSequence());
            liveServer.stop();
        }
    }

    private static File newFolder(File root, String subFolder) throws IOException {
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }
}

