/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeImpl;
import org.apache.activemq.artemis.core.postoffice.impl.PostOfficeTestAccessor;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AutoDeleteQueueTest
extends ActiveMQTestBase {
    public final SimpleString addressA = SimpleString.of((String)"addressA");
    public final SimpleString queueA = SimpleString.of((String)"queueA");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.getConfiguration().setAddressQueueScanPeriod(500L);
        this.server.getConfiguration().setMessageExpiryScanPeriod(500L);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testAutoDeleteAutoCreatedQueueOnLastConsumerClose() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        this.cf.createSession().createConsumer(this.queueA).close();
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null);
    }

    @Test
    public void testAutoDeleteAutoCreatedQueueOnLastMessageRemovedWithoutConsumer() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        ClientSession session = this.cf.createSession();
        ClientProducer producer = session.createProducer(this.addressA);
        producer.send((Message)session.createMessage(true));
        Wait.assertEquals((long)1L, () -> ((Queue)this.server.locateQueue(this.queueA)).getMessageCount());
        this.server.locateQueue(this.queueA).deleteAllReferences();
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null, (long)2000L, (long)100L);
    }

    @Test
    public void testAutoDeleteAutoCreatedQueueOnLastMessageExpired() throws Exception {
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        ClientSession session = this.cf.createSession();
        ClientProducer producer = session.createProducer(this.addressA);
        producer.send(session.createMessage(true).setExpiration(System.currentTimeMillis()));
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null, (long)2000L, (long)100L);
    }

    @Test
    public void testNegativeAutoDeleteAutoCreatedQueue() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteQueues(Boolean.valueOf(false)));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        this.cf.createSession().createConsumer(this.queueA).close();
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
    }

    @Test
    public void testNegativeAutoDeleteAutoCreatedQueue2() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings());
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        Assertions.assertFalse((boolean)Wait.waitFor(() -> this.server.locateQueue(this.queueA) == null, (long)5000L, (long)100L));
    }

    @Test
    public void testAutoDeleteAutoCreatedQueueWithoutUsage() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteQueuesSkipUsageCheck(true));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
        Wait.assertTrue(() -> this.server.locateQueue(this.queueA) == null, (long)2000L, (long)100L);
    }

    @Test
    public void testAutoDeleteAutoCreatedQueueWithoutUsageWithDelay() throws Exception {
        long DELAY = 1500L;
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteQueuesSkipUsageCheck(true).setAutoDeleteQueuesDelay(1500L));
        this.server.createQueue(QueueConfiguration.of((SimpleString)this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        long start = System.currentTimeMillis();
        Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
        while (System.currentTimeMillis() - start <= 1500L) {
            PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
            Assertions.assertNotNull((Object)this.server.locateQueue(this.queueA));
            Thread.sleep(100L);
        }
        PostOfficeTestAccessor.sweepAndReapAddresses((PostOfficeImpl)this.server.getPostOffice());
        Assertions.assertNull((Object)this.server.locateQueue(this.queueA));
    }
}

