/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQQueueExistsException;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CreateQueueIdempotentTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultInVMConfig(), (boolean)true));
        this.server.start();
    }

    @Test
    public void testSequentialCreateQueueIdempotency() throws Exception {
        SimpleString QUEUE = SimpleString.of((String)"SequentialCreateQueueIdempotency");
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory sf = this.addSessionFactory(this.createSessionFactory(locator));
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)QUEUE));
        try {
            session.createQueue(QueueConfiguration.of((SimpleString)QUEUE));
            Assertions.fail((String)"Expected exception, queue already exists");
        }
        catch (ActiveMQQueueExistsException activeMQQueueExistsException) {
        }
        catch (ActiveMQException e) {
            Assertions.fail((String)("Invalid Exception type:" + e.getType()));
        }
    }

    @Test
    public void testConcurrentCreateQueueIdempotency() throws Exception {
        int i;
        String QUEUE = "ConcurrentCreateQueueIdempotency";
        AtomicInteger queuesCreated = new AtomicInteger(0);
        AtomicInteger failedAttempts = new AtomicInteger(0);
        int NUM_THREADS = 5;
        QueueCreator[] queueCreators = new QueueCreator[5];
        for (i = 0; i < 5; ++i) {
            QueueCreator queueCreator;
            queueCreators[i] = queueCreator = new QueueCreator("ConcurrentCreateQueueIdempotency", queuesCreated, failedAttempts);
        }
        for (i = 0; i < 5; ++i) {
            queueCreators[i].start();
        }
        for (i = 0; i < 5; ++i) {
            queueCreators[i].join();
        }
        this.server.stop();
        this.server.start();
        Assertions.assertEquals((int)1, (int)queuesCreated.intValue());
        Assertions.assertEquals((int)4, (int)failedAttempts.intValue());
    }

    class QueueCreator
    extends Thread {
        private String queueName = null;
        private AtomicInteger queuesCreated = null;
        private AtomicInteger failedAttempts = null;

        QueueCreator(String queueName, AtomicInteger queuesCreated, AtomicInteger failedAttempts) {
            this.queueName = queueName;
            this.queuesCreated = queuesCreated;
            this.failedAttempts = failedAttempts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ServerLocator locator = null;
            ClientSession session = null;
            try {
                locator = CreateQueueIdempotentTest.this.createInVMNonHALocator();
                ClientSessionFactory sf = CreateQueueIdempotentTest.this.createSessionFactory(locator);
                session = sf.createSession(false, true, true);
                SimpleString QUEUE = SimpleString.of((String)this.queueName);
                session.createQueue(QueueConfiguration.of((SimpleString)QUEUE));
                this.queuesCreated.incrementAndGet();
            }
            catch (ActiveMQQueueExistsException qne) {
                this.failedAttempts.incrementAndGet();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (locator != null) {
                    locator.close();
                }
                if (session != null) {
                    try {
                        session.close();
                    }
                    catch (ActiveMQException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }
}

