/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.ha.DistributedLockManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.lockmanager.file.FileBasedLockManager;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.client.InfiniteRedeliveryTest;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class LockManagerInfiniteRedeliveryTest
extends InfiniteRedeliveryTest {
    private DistributedLockManagerConfiguration managerConfiguration;

    public LockManagerInfiniteRedeliveryTest(String protocol, boolean useCLI) {
        super(protocol, useCLI);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.managerConfiguration = new DistributedLockManagerConfiguration(FileBasedLockManager.class.getName(), Collections.singletonMap("locks-folder", LockManagerInfiniteRedeliveryTest.newFolder(this.temporaryFolder, "manager").toString()));
    }

    @Override
    protected void configureReplicationPair(TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, TransportConfiguration primaryConnector) {
        ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(this.backupConfig, backupConnector, backupAcceptor, this.primaryConfig, primaryConnector, null, this.managerConfiguration, this.managerConfiguration);
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(-1).setAllowFailBack(true);
    }

    private static File newFolder(File root, String subFolder) throws IOException {
        File result = new File(root, subFolder);
        if (!result.mkdirs()) {
            throw new IOException("Couldn't create folders " + root);
        }
        return result;
    }
}

