/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.FailoverEventType;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionFactoryCloseTest
extends ActiveMQTestBase {
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false);
        this.server.start();
    }

    @Test
    public void testCloseSessionFactory() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator().setReconnectAttempts(-1).setConnectionTTL(1000L).setClientFailureCheckPeriod(100L).setConsumerWindowSize(0xA00000).setCallTimeout(1000L);
        ClientSessionFactory sf = locator.createSessionFactory();
        CountDownLatch latch = new CountDownLatch(1);
        sf.addFailoverListener(eventType -> {
            if (eventType == FailoverEventType.FAILURE_DETECTED) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            } else if (eventType == FailoverEventType.FAILOVER_FAILED) {
                latch.countDown();
            }
        });
        this.server.stop();
        Thread.sleep(600L);
        sf.close();
        Assertions.assertTrue((boolean)latch.await(1000L, TimeUnit.MILLISECONDS));
    }
}

