/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class WildcardConfigurationTest
extends ActiveMQTestBase {
    private ActiveMQServer server;
    private ServerLocator locator;
    private ClientSession clientSession;
    private ClientSessionFactory sf;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        WildcardConfiguration wildcardConfiguration = new WildcardConfiguration();
        wildcardConfiguration.setDelimiter('/');
        Configuration configuration = this.createDefaultInVMConfig().setWildcardRoutingEnabled(true).setTransactionTimeoutScanPeriod(500L).setWildCardConfiguration(wildcardConfiguration);
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)configuration, (boolean)false));
        this.server.start();
        this.server.getManagementService().enableNotifications(false);
        this.locator = this.createInVMNonHALocator();
        this.sf = this.createSessionFactory(this.locator);
        this.clientSession = this.addClientSession(this.sf.createSession(false, true, true));
    }

    @Test
    public void testBasicWildcardRouting() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a/b");
        SimpleString addressAC = SimpleString.of((String)"a/c");
        SimpleString address = SimpleString.of((String)"a/*");
        SimpleString queueName1 = SimpleString.of((String)"Q1");
        SimpleString queueName2 = SimpleString.of((String)"Q2");
        SimpleString queueName = SimpleString.of((String)"Q");
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName1).setAddress(addressAB).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName2).setAddress(addressAC).setDurable(Boolean.valueOf(false)));
        this.clientSession.createQueue(QueueConfiguration.of((SimpleString)queueName).setAddress(address).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = this.clientSession.createProducer(addressAB);
        ClientProducer producer2 = this.clientSession.createProducer(addressAC);
        ClientConsumer clientConsumer = this.clientSession.createConsumer(queueName);
        this.clientSession.start();
        producer.send((Message)this.createTextMessage(this.clientSession, "m1"));
        producer2.send((Message)this.createTextMessage(this.clientSession, "m2"));
        ClientMessage m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m1", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receive(500L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)"m2", (Object)m.getBodyBuffer().readString());
        m.acknowledge();
        m = clientConsumer.receiveImmediate();
        Assertions.assertNull((Object)m);
    }
}

