/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.clientcrash;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.extensions.SpawnedVMCheckExtension;
import org.apache.activemq.artemis.tests.integration.clientcrash.ClientTestBase;
import org.apache.activemq.artemis.tests.integration.clientcrash.CrashClient;
import org.apache.activemq.artemis.tests.integration.clientcrash.CrashClient2;
import org.apache.activemq.artemis.utils.SpawnedVMSupport;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientCrashTest
extends ClientTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @RegisterExtension
    public SpawnedVMCheckExtension spawnedVMCheck = new SpawnedVMCheckExtension();
    static final int PING_PERIOD = 100;
    static final int CONNECTION_TTL = 1000;
    public static final SimpleString QUEUE = SimpleString.of((String)"ClientCrashTestQueue");
    public static final SimpleString QUEUE2 = SimpleString.of((String)"ClientCrashTestQueue2");
    public static final String MESSAGE_TEXT_FROM_SERVER = "ClientCrashTest from server";
    public static final String MESSAGE_TEXT_FROM_CLIENT = "ClientCrashTest from client";
    private ClientSessionFactory sf;
    private ServerLocator locator;
    Process p;

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.p != null) {
            long timeout = System.currentTimeMillis() + 5000L;
            while (timeout > System.currentTimeMillis() && this.p.isAlive()) {
                this.p.destroy();
            }
        }
    }

    @Test
    public void testCrashClient() throws Exception {
        this.assertActiveConnections(1);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)QUEUE).setDurable(Boolean.valueOf(false)));
        this.p = SpawnedVMSupport.spawnVM((String)CrashClient.class.getName(), (String[])new String[0]);
        Assertions.assertTrue((boolean)this.p.waitFor(1L, TimeUnit.MINUTES));
        Assertions.assertEquals((int)CrashClient.OK, (int)this.p.exitValue());
        ClientConsumer consumer = session.createConsumer(QUEUE);
        ClientProducer producer = session.createProducer(QUEUE);
        session.start();
        ClientMessage messageFromClient = consumer.receive(5000L);
        Assertions.assertNotNull((Object)messageFromClient, (String)"no message received");
        Assertions.assertEquals((Object)MESSAGE_TEXT_FROM_CLIENT, (Object)messageFromClient.getBodyBuffer().readString());
        this.assertActiveConnections(1);
        this.assertActiveSession(1);
        ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
        message.getBodyBuffer().writeString(MESSAGE_TEXT_FROM_SERVER);
        producer.send((Message)message);
        Assertions.assertEquals((int)9, (int)this.p.exitValue());
        long timeout = 11100L;
        this.assertActiveConnections(1, timeout);
        this.assertActiveSession(1, timeout);
        session.close();
        this.assertActiveConnections(1);
        this.assertActiveSession(0);
    }

    @Test
    public void testCrashClient2() throws Exception {
        AddressSettings addressSettings = new AddressSettings().setRedeliveryDelay(1100L);
        this.server.getAddressSettingsRepository().addMatch(QUEUE2.toString(), (Object)addressSettings);
        this.assertActiveConnections(1);
        ClientSession session = this.sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)QUEUE2).setDurable(Boolean.valueOf(false)));
        this.p = SpawnedVMSupport.spawnVM((String)CrashClient2.class.getName(), (String[])new String[0]);
        logger.debug("waiting for the client VM to crash ...");
        Assertions.assertTrue((boolean)this.p.waitFor(1L, TimeUnit.MINUTES));
        Assertions.assertEquals((int)9, (int)this.p.exitValue());
        long timeout = 11100L;
        this.assertActiveConnections(1, timeout);
        this.assertActiveSession(1, timeout);
        ClientConsumer consumer = session.createConsumer(QUEUE2);
        session.start();
        ClientMessage messageFromClient = consumer.receive(timeout);
        Assertions.assertNotNull((Object)messageFromClient, (String)"no message received");
        Assertions.assertEquals((Object)MESSAGE_TEXT_FROM_CLIENT, (Object)messageFromClient.getBodyBuffer().readString());
        Assertions.assertEquals((int)2, (int)messageFromClient.getDeliveryCount(), (String)"delivery count");
        consumer.close();
        session.close();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createNettyNonHALocator();
        this.addServerLocator(this.locator);
        this.locator.setClientFailureCheckPeriod(100L);
        this.locator.setConnectionTTL(1000L);
        this.sf = this.createSessionFactory(this.locator);
    }
}

