/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster;

import java.util.Arrays;
import org.apache.activemq.artemis.core.server.NodeManager;
import org.apache.activemq.artemis.utils.UUID;

public class NodeManagerAction {
    public static final int START_PRIMARY = 0;
    public static final int START_BACKUP = 1;
    public static final int CRASH_PRIMARY = 2;
    public static final int PAUSE_PRIMARY = 3;
    public static final int STOP_BACKUP = 4;
    public static final int AWAIT_PRIMARY = 5;
    public static final int RELEASE_BACKUP = 6;
    public static final int HAS_PRIMARY = 10;
    public static final int HAS_BACKUP = 11;
    public static final int DOESNT_HAVE_PRIMARY = 12;
    public static final int DOESNT_HAVE_BACKUP = 13;
    public static final int CHECK_ID = 14;
    private final int[] work;
    boolean hasPrimaryLock = false;
    boolean hasBackupLock = false;

    public NodeManagerAction(int ... work) {
        this.work = work;
    }

    public void performWork(NodeManager nodeManager) throws Exception {
        block14: for (int action : this.work) {
            switch (action) {
                case 0: {
                    nodeManager.startPrimaryNode().activationComplete();
                    this.hasPrimaryLock = true;
                    this.hasBackupLock = false;
                    continue block14;
                }
                case 1: {
                    nodeManager.startBackup();
                    this.hasBackupLock = true;
                    continue block14;
                }
                case 2: {
                    nodeManager.crashPrimaryServer();
                    this.hasPrimaryLock = false;
                    continue block14;
                }
                case 3: {
                    nodeManager.pausePrimaryServer();
                    this.hasPrimaryLock = false;
                    continue block14;
                }
                case 4: {
                    nodeManager.stopBackup();
                    this.hasBackupLock = false;
                    continue block14;
                }
                case 5: {
                    nodeManager.awaitPrimaryNode();
                    this.hasPrimaryLock = true;
                    continue block14;
                }
                case 6: {
                    nodeManager.releaseBackup();
                    this.hasBackupLock = false;
                }
                case 10: {
                    if (this.hasPrimaryLock) continue block14;
                    throw new IllegalStateException("live lock not held");
                }
                case 11: {
                    if (this.hasBackupLock) continue block14;
                    throw new IllegalStateException("backup lock not held");
                }
                case 12: {
                    if (!this.hasPrimaryLock) continue block14;
                    throw new IllegalStateException("live lock held");
                }
                case 13: {
                    if (!this.hasBackupLock) continue block14;
                    throw new IllegalStateException("backup lock held");
                }
                case 14: {
                    nodeManager.start();
                    UUID id1 = nodeManager.getUUID();
                    nodeManager.stop();
                    nodeManager.start();
                    if (Arrays.equals(id1.asBytes(), nodeManager.getUUID().asBytes())) continue block14;
                    throw new IllegalStateException("getUUID should be the same on restart");
                }
            }
        }
    }

    public int works() {
        return this.work.length;
    }

    public int getWork(String[] works, int start) {
        int workLength = this.work.length;
        for (int i = 0; i < workLength; ++i) {
            works[i + start] = Integer.toString(this.work[i]);
        }
        return workLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(String[] args, NodeManager nodeManager) throws Exception {
        int[] work1 = new int[args.length];
        for (int i = 0; i < args.length; ++i) {
            work1[i] = Integer.parseInt(args[i]);
        }
        NodeManagerAction nodeManagerAction = new NodeManagerAction(work1);
        nodeManager.start();
        try {
            nodeManagerAction.performWork(nodeManager);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(9);
        }
        finally {
            nodeManager.stop();
        }
    }
}

