/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.distribution;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoteBindingWithoutLoadBalancingTest
extends ClusterTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    protected boolean isNetty() {
        return false;
    }

    @Test
    public void testStackOverflow() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", null, false);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        this.send(1, "queues.testaddress", 1, false, null);
    }

    @Test
    public void testStackOverflowWithLocalConsumerAndFilter() throws Exception {
        this.setupCluster();
        this.startServers();
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
        this.createQueue(0, "queues.testaddress", "queue0", "0", true);
        this.createQueue(1, "queues.testaddress", "queue0", "1", true);
        this.waitForBindings(0, "queues.testaddress", 1, 0, true);
        this.waitForBindings(1, "queues.testaddress", 1, 0, false);
        for (int i = 0; i < 10; ++i) {
            this.send(1, "queues.testaddress", 10, false, "" + i % 2);
        }
    }

    @Test
    public void testStackOverflowJMS() throws Exception {
        String QUEUE_NAME = "queues.queue0";
        this.setupCluster();
        this.startServers();
        ActiveMQConnectionFactory cf1 = new ActiveMQConnectionFactory("vm://0");
        Connection c1 = cf1.createConnection();
        c1.start();
        Session s1 = c1.createSession();
        MessageConsumer mc1 = s1.createConsumer((Destination)s1.createQueue("queues.queue0"));
        this.waitForBindings(0, "queues.queue0", 1, 1, true);
        this.waitForBindings(1, "queues.queue0", 1, 1, false);
        ActiveMQConnectionFactory cf2 = new ActiveMQConnectionFactory("vm://1");
        Connection c2 = cf2.createConnection();
        Session s2 = c2.createSession();
        MessageProducer mp2 = s2.createProducer((Destination)s2.createQueue("queues.queue0"));
        mp2.send(s2.createMessage());
        this.waitForBindings(1, "queues.queue0", 1, 0, true);
        Assertions.assertTrue((boolean)Wait.waitFor(() -> this.servers[1].locateQueue(SimpleString.of((String)"queues.queue0")).getMessageCount() == 1L, (long)2000L, (long)100L));
        c1.close();
        c2.close();
    }

    protected void setupCluster() throws Exception {
        this.setupClusterConnection("cluster0", "queues", MessageLoadBalancingType.OFF, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "queues", MessageLoadBalancingType.OFF, 1, this.isNetty(), 1, 0);
    }

    protected void setupServers() throws Exception {
        this.setupServer(0, this.isFileStorage(), this.isNetty());
        this.setupServer(1, this.isFileStorage(), this.isNetty());
    }

    protected void startServers() throws Exception {
        this.startServers(0, 1);
    }

    protected void stopServers() throws Exception {
        this.closeAllConsumers();
        this.closeAllSessionFactories();
        this.closeAllServerLocatorsFactories();
        this.stopServers(0, 1);
    }

    @Override
    protected boolean isFileStorage() {
        return false;
    }
}

