/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import com.sun.net.httpserver.HttpServer;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.component.WebServerComponent;
import org.apache.activemq.artemis.core.config.ha.ReplicaPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicatedPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.cluster.ha.ReplicatedPolicy;
import org.apache.activemq.artemis.dto.AppDTO;
import org.apache.activemq.artemis.dto.BindingDTO;
import org.apache.activemq.artemis.dto.ComponentDTO;
import org.apache.activemq.artemis.dto.WebServerDTO;
import org.apache.activemq.artemis.tests.extensions.TestMethodNameMatchExtension;
import org.apache.activemq.artemis.tests.integration.cluster.failover.FailoverTest;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.extension.RegisterExtension;

public class ReplicatedFailoverTest
extends FailoverTest {
    private static final String TEST_REPLICATED_FAILBACK = "testReplicatedFailback";
    private static final String TEST_LOOP = "testLoop";
    @RegisterExtension
    TestMethodNameMatchExtension isReplicatedFailbackTest = new TestMethodNameMatchExtension(new String[]{"testReplicatedFailback", "testLoop"});

    protected void beforeWaitForRemoteBackupSynchronization() {
    }

    private void waitForSync(ActiveMQServer server) throws Exception {
        Wait.waitFor(() -> ((ActiveMQServer)server).isReplicaSync());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Timeout(value=120L)
    public void testReplicatedFailback() throws Exception {
        try {
            this.beforeWaitForRemoteBackupSynchronization();
            this.waitForSync(this.backupServer.getServer());
            this.createSessionFactory();
            ClientSession session = this.createSession((ClientSessionFactory)this.sf, true, true);
            session.createQueue(QueueConfiguration.of((SimpleString)ADDRESS));
            this.crash(session);
            ReplicatedPolicy haPolicy = (ReplicatedPolicy)this.primaryServer.getServer().getHAPolicy();
            haPolicy.setCheckForPrimaryServer(true);
            this.primaryServer.start();
            this.waitForSync(this.primaryServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.primaryServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            ReplicatedPolicyConfiguration replicatedPolicyConfiguration = (ReplicatedPolicyConfiguration)this.primaryServer.getServer().getConfiguration().getHAPolicyConfiguration();
            replicatedPolicyConfiguration.setCheckForActiveServer(true);
            this.primaryServer.start();
            this.waitForSync(this.primaryServer.getServer());
            this.waitForSync(this.backupServer.getServer());
            this.waitForServerToStart(this.primaryServer.getServer());
            session = this.createSession((ClientSessionFactory)this.sf, true, true);
            this.crash(session);
            replicatedPolicyConfiguration = (ReplicatedPolicyConfiguration)this.primaryServer.getServer().getConfiguration().getHAPolicyConfiguration();
            replicatedPolicyConfiguration.setCheckForActiveServer(true);
            this.primaryServer.start();
            this.waitForSync(this.primaryServer.getServer());
            this.waitForServerToStart(this.backupServer.getServer());
            Assertions.assertTrue((boolean)this.backupServer.getServer().isStarted());
        }
        finally {
            if (this.sf != null) {
                this.sf.close();
            }
            try {
                this.backupServer.getServer().stop();
            }
            catch (Throwable throwable) {}
            try {
                this.primaryServer.getServer().stop();
            }
            catch (Throwable throwable) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReplicatedFailbackBackupFromPrimaryBackToBackup() throws Exception {
        InetSocketAddress address = new InetSocketAddress("127.0.0.1", 8787);
        HttpServer httpServer = HttpServer.create(address, 100);
        httpServer.start();
        try {
            httpServer.createContext("/", t -> {
                String response = "<html><body><b>This is a unit test</b></body></html>";
                t.sendResponseHeaders(200, response.length());
                OutputStream os = t.getResponseBody();
                os.write(response.getBytes());
                os.close();
            });
            AppDTO appDTO = new AppDTO();
            appDTO.war = "console.war";
            appDTO.url = "console";
            BindingDTO bindingDTO = new BindingDTO();
            bindingDTO.uri = "http://localhost:0";
            bindingDTO.apps = new ArrayList();
            bindingDTO.apps.add(appDTO);
            WebServerDTO wdto = new WebServerDTO();
            wdto.setBindings(Collections.singletonList(bindingDTO));
            wdto.path = "console";
            WebServerComponent webServerComponent = new WebServerComponent();
            webServerComponent.configure((ComponentDTO)wdto, ".", ".");
            webServerComponent.start();
            this.backupServer.getServer().getNetworkHealthCheck().parseURIList("http://localhost:8787");
            Assertions.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            this.backupServer.getServer().addExternalComponent((ActiveMQComponent)webServerComponent, false);
            this.backupServer.getServer().fail(true);
            Assertions.assertTrue((boolean)this.backupServer.getServer().getNetworkHealthCheck().isStarted());
            Assertions.assertTrue((boolean)((ActiveMQComponent)this.backupServer.getServer().getExternalComponents().get(0)).isStarted());
            ((ServiceComponent)this.backupServer.getServer().getExternalComponents().get(0)).stop(true);
        }
        finally {
            httpServer.stop(0);
        }
    }

    @Override
    protected void createConfigs() throws Exception {
        this.createReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        if (this.isReplicatedFailbackTest.matches()) {
            ((ReplicatedPolicyConfiguration)this.primaryConfig.getHAPolicyConfiguration()).setCheckForActiveServer(true);
            ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
            ((ReplicaPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setRestartBackup(false);
        } else {
            super.setupHAPolicyConfiguration();
        }
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                ReplicatedFailoverTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            ReplicatedFailoverTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                ReplicatedFailoverTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            ReplicatedFailoverTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(sessions);
    }
}

