/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.core.config.HAPolicyConfiguration;
import org.apache.activemq.artemis.core.config.MetricsConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.metrics.plugins.SimpleMetricsPlugin;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SharedStoreMetricsLeakTest
extends ClusterTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServers();
    }

    private void setupServers() throws Exception {
        this.setupPrimaryServer(0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupBackupServer(1, 0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.getServer(0).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStorePrimaryPolicyConfiguration().setFailoverOnServerShutdown(true));
        this.getServer(0).getConfiguration().setMetricsConfiguration(new MetricsConfiguration().setJvmThread(false).setJvmGc(false).setJvmMemory(false).setPlugin(new SimpleMetricsPlugin().init(null)));
        this.getServer(1).getConfiguration().setHAPolicyConfiguration((HAPolicyConfiguration)new SharedStoreBackupPolicyConfiguration().setFailoverOnServerShutdown(true).setAllowFailBack(true));
        this.getServer(1).getConfiguration().setMetricsConfiguration(new MetricsConfiguration().setJvmThread(false).setJvmGc(false).setJvmMemory(false).setPlugin(new SimpleMetricsPlugin().init(null)));
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster", "queues", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
    }

    private boolean isNetty() {
        return true;
    }

    @Test
    public void testForMeterLeaks() throws Exception {
        ActiveMQServer primary = this.getServer(0);
        ActiveMQServer backup = this.getServer(1);
        primary.start();
        Assertions.assertTrue((boolean)primary.waitForActivation(5L, TimeUnit.SECONDS));
        backup.start();
        Assertions.assertFalse((boolean)backup.waitForActivation(1L, TimeUnit.SECONDS));
        long baseline = backup.getMetricsManager().getMeterRegistry().getMeters().size();
        primary.stop();
        Assertions.assertTrue((boolean)backup.waitForActivation(5L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> (long)backup.getMetricsManager().getMeterRegistry().getMeters().size() > baseline, (long)2000L, (long)100L);
        primary.start();
        Assertions.assertTrue((boolean)primary.waitForActivation(5L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> (long)backup.getMetricsManager().getMeterRegistry().getMeters().size() == baseline, (long)2000L, (long)100L);
        primary.stop();
        backup.stop();
    }
}

