/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover;

import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.core.config.ClusterConnectionConfiguration;
import org.apache.activemq.artemis.core.config.ScaleDownConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStoreBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.SharedStorePrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SharedStoreScaleDownBackupTest
extends ClusterTestBase {
    protected boolean isNetty() {
        return true;
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupPrimaryServer(0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupPrimaryServer(1, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty(), false);
        this.setupBackupServer(2, 0, this.isFileStorage(), ClusterTestBase.HAType.SharedStore, this.isNetty());
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 0, 1);
        this.setupClusterConnection("cluster1", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 1, 0);
        this.setupClusterConnection("cluster0", "testAddress", MessageLoadBalancingType.ON_DEMAND, 1, this.isNetty(), 2, 1);
        ((SharedStorePrimaryPolicyConfiguration)this.getServer(0).getConfiguration().getHAPolicyConfiguration()).setFailoverOnServerShutdown(true);
        ((SharedStoreBackupPolicyConfiguration)this.getServer(2).getConfiguration().getHAPolicyConfiguration()).setFailoverOnServerShutdown(true).setRestartBackup(true).setScaleDownConfiguration(new ScaleDownConfiguration().setEnabled(true).addConnector((String)((ClusterConnectionConfiguration)this.getServer(2).getConfiguration().getClusterConfigurations().get(0)).getStaticConnectors().get(0)));
        this.getServer(0).getConfiguration().getAddressSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.getServer(1).getConfiguration().getAddressSettings().put("#", new AddressSettings().setRedistributionDelay(0L));
        this.startServers(0, 1, 2);
        this.setupSessionFactory(0, this.isNetty());
        this.setupSessionFactory(1, this.isNetty());
    }

    @Test
    public void testBasicScaleDown() throws Exception {
        int TEST_SIZE = 2;
        String addressName = "testAddress";
        String queueName1 = "testQueue1";
        String queueName2 = "testQueue2";
        this.createQueue(0, "testAddress", "testQueue1", null, true);
        this.createQueue(0, "testAddress", "testQueue2", null, true);
        this.createQueue(1, "testAddress", "testQueue1", null, true);
        this.createQueue(1, "testAddress", "testQueue2", null, true);
        this.send(0, "testAddress", 2, true, null);
        this.addConsumer(1, 0, "testQueue2", null, false);
        ClientMessage clientMessage = this.consumers[1].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        this.consumers[1].getSession().commit();
        Assertions.assertEquals((int)2, (int)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue1"))).getQueue()));
        Assertions.assertEquals((int)1, (int)this.getMessageCount(((LocalQueueBinding)this.servers[0].getPostOffice().getBinding(SimpleString.of((String)"testQueue2"))).getQueue()));
        this.servers[0].stop();
        this.addConsumer(0, 1, "testQueue1", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
        this.addConsumer(0, 1, "testQueue2", null);
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNotNull((Object)clientMessage);
        clientMessage.acknowledge();
        clientMessage = this.consumers[0].getConsumer().receive(250L);
        Assertions.assertNull((Object)clientMessage);
        this.removeConsumer(0);
    }
}

