/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.lockmanager;

import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.tests.integration.cluster.failover.LargeMessageFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.failover.lockmanager.LockManagerNettyNoGroupNameReplicatedFailoverTest;
import org.apache.activemq.artemis.tests.integration.cluster.util.TestableServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockManagerReplicatedLargeMessageFailoverTest
extends LargeMessageFailoverTest {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected void createConfigs() throws Exception {
        this.createPluggableReplicatedConfigs();
    }

    @Override
    protected void setupHAPolicyConfiguration() {
        ((ReplicationBackupPolicyConfiguration)this.backupConfig.getHAPolicyConfiguration()).setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected void crash(boolean waitFailure, ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                LockManagerReplicatedLargeMessageFailoverTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            LockManagerReplicatedLargeMessageFailoverTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(waitFailure, sessions);
    }

    @Override
    protected void crash(ClientSession ... sessions) throws Exception {
        if (sessions.length > 0) {
            for (ClientSession session : sessions) {
                LockManagerReplicatedLargeMessageFailoverTest.waitForRemoteBackup(session.getSessionFactory(), 5, true, this.backupServer.getServer());
            }
        } else {
            LockManagerReplicatedLargeMessageFailoverTest.waitForRemoteBackup(null, 5, true, this.backupServer.getServer());
        }
        super.crash(sessions);
    }

    @Override
    protected void decrementActivationSequenceForForceRestartOf(TestableServer primaryServer) throws Exception {
        LockManagerNettyNoGroupNameReplicatedFailoverTest.doDecrementActivationSequenceForForceRestartOf(logger, this.nodeManager, this.managerConfiguration);
    }
}

