/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.reattach;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.client.impl.ClientSessionInternal;
import org.apache.activemq.artemis.core.protocol.core.impl.RemotingConnectionImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnector;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MultiThreadReattachSupportTestBase
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Timer timer;

    protected abstract void start() throws Exception;

    protected abstract void stop() throws Exception;

    protected abstract ServerLocator createLocator() throws Exception;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.timer = new Timer();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.timer.cancel();
        this.timer = null;
        super.tearDown();
    }

    protected boolean shouldFail() {
        return true;
    }

    protected void runMultipleThreadsFailoverTest(RunnableT runnable, int numThreads, int numIts, boolean failOnCreateConnection, long failDelay) throws Exception {
        for (int its = 0; its < numIts; ++its) {
            logger.debug("Beginning iteration {}", (Object)its);
            this.start();
            ServerLocator locator = this.createLocator();
            final ClientSessionFactoryInternal sf = (ClientSessionFactoryInternal)this.createSessionFactory(locator);
            ClientSession session = this.addClientSession(sf.createSession(false, true, true));
            Failer failer = this.startFailer(failDelay, session, failOnCreateConnection);
            do {
                class Runner
                extends Thread {
                    private volatile Throwable throwable;
                    private final RunnableT test;
                    private final int threadNum;

                    Runner(RunnableT test, int threadNum) {
                        this.test = test;
                        this.threadNum = threadNum;
                    }

                    @Override
                    public void run() {
                        try {
                            this.test.run((ClientSessionFactory)sf, this.threadNum);
                        }
                        catch (Throwable t) {
                            this.throwable = t;
                            logger.error("Failed to run test", t);
                            System.out.println(ActiveMQTestBase.threadDump(" - fired by MultiThreadRandomReattachTestBase::runTestMultipleThreads (" + t.getLocalizedMessage() + ")"));
                        }
                    }
                }
                ArrayList<Runner> threads = new ArrayList<Runner>();
                for (int i = 0; i < numThreads; ++i) {
                    Runner runner = new Runner(runnable, i);
                    threads.add(runner);
                    runner.start();
                }
                for (Runner thread : threads) {
                    thread.join();
                    if (thread.throwable == null) continue;
                    throw new Exception("Exception on thread " + thread, thread.throwable);
                }
                runnable.checkFail();
            } while (!failer.isExecuted());
            InVMConnector.resetFailures();
            session.close();
            locator.close();
            Assertions.assertEquals((int)0, (int)sf.numSessions());
            Assertions.assertEquals((int)0, (int)sf.numConnections());
            sf.close();
            this.stop();
        }
    }

    private Failer startFailer(long time, ClientSession session, boolean failOnCreateConnection) {
        Failer failer = new Failer(session, failOnCreateConnection);
        if (this.shouldFail()) {
            this.timer.schedule((TimerTask)failer, (long)((double)time * Math.random()), 100L);
        }
        return failer;
    }

    private class Failer
    extends TimerTask {
        private final ClientSession session;
        private boolean executed;
        private final boolean failOnCreateConnection;

        private Failer(ClientSession session, boolean failOnCreateConnection) {
            this.session = session;
            this.failOnCreateConnection = failOnCreateConnection;
        }

        @Override
        public synchronized void run() {
            logger.debug("** Failing connection");
            RemotingConnectionImpl conn = (RemotingConnectionImpl)((ClientSessionInternal)this.session).getConnection();
            if (this.failOnCreateConnection) {
                InVMConnector.numberOfFailures = 1;
                InVMConnector.failOnCreateConnection = true;
            } else {
                conn.fail((ActiveMQException)((Object)new ActiveMQNotConnectedException("blah")));
            }
            logger.debug("** Fail complete");
            this.cancel();
            this.executed = true;
        }

        public synchronized boolean isExecuted() {
            return this.executed;
        }
    }

    protected abstract class RunnableT
    extends Thread {
        private volatile String failReason;
        private volatile Throwable throwable;

        protected RunnableT() {
        }

        public void setFailed(String reason, Throwable throwable) {
            this.failReason = reason;
            this.throwable = throwable;
        }

        public void checkFail() {
            if (this.throwable != null) {
                logger.error("Test failed: {}", (Object)this.failReason, (Object)this.throwable);
            }
            if (this.failReason != null) {
                Assertions.fail((String)this.failReason);
            }
        }

        public abstract void run(ClientSessionFactory var1, int var2) throws Exception;
    }
}

