/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.crossprotocol;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.Topic;
import java.net.URI;
import java.util.Arrays;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.OpenWireTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.transport.amqp.client.AmqpClient;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpMessage;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpSession;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class RequestReplyNonJMSTest
extends OpenWireTestBase {
    private static final SimpleString queueName = SimpleString.of((String)"RequestReplyQueueTest");
    private static final SimpleString topicName = SimpleString.of((String)"RequestReplyTopicTest");
    private static final SimpleString replyQueue = SimpleString.of((String)"ReplyOnRequestReplyQueueTest");
    private final String protocolConsumer;
    private ConnectionFactory consumerCF;

    public RequestReplyNonJMSTest(String protocolConsumer) {
        this.protocolConsumer = protocolConsumer;
    }

    @Parameters(name="openWireOnSender={0}")
    public static Iterable<Object[]> data() {
        return Arrays.asList({"OPENWIRE"}, {"CORE"}, {"AMQP"});
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.consumerCF = CFUtil.createConnectionFactory(this.protocolConsumer, "tcp://localhost:61616?wireFormat.cacheEnabled=true");
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isStarted());
        Wait.assertTrue(() -> ((ActiveMQServer)this.server).isActive());
        this.server.createQueue(QueueConfiguration.of((SimpleString)queueName).setRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((SimpleString)replyQueue).setRoutingType(RoutingType.ANYCAST));
        AddressInfo info = new AddressInfo(topicName, RoutingType.MULTICAST);
        this.server.addAddressInfo(info);
    }

    @TestTemplate
    public void testReplyToFromAMQPClientWithInvalidTypeAnnotation() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageAnnotation("x-opt-jms-reply-to", (byte)10);
            message.setMessageId("msg-1");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assertions.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @TestTemplate
    public void testReplyToFromAMQPClientWithNoTypeOrOtherAnnotations() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageId("msg-1");
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assertions.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @TestTemplate
    public void testReplyToFromAMQPClientWithNoTypeButWithOtherAnnotations() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-not-jms-reply-to", (byte)1);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assertions.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @TestTemplate
    public void testReplyToFromAMQPClientWithQueueReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyQueue.toString());
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (byte)0);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Queue replyQueue = consumerSess.createQueue(RequestReplyNonJMSTest.replyQueue.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertEquals((Object)replyQueue, (Object)receivedMessage.getJMSReplyTo());
            Assertions.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Queue));
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @TestTemplate
    public void testReplyToFromAMQPClientWithTopicReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(topicName.toString());
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (byte)1);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            Topic replyTopic = consumerSess.createTopic(topicName.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertEquals((Object)replyTopic, (Object)receivedMessage.getJMSReplyTo());
            Assertions.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof Topic));
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @TestTemplate
    public void testReplyToFromAMQPClientWithTempTopicReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            String replyToName = UUID.randomUUID().toString();
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyToName);
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (byte)3);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof TemporaryTopic));
            Assertions.assertEquals((Object)replyToName, (Object)((TemporaryTopic)receivedMessage.getJMSReplyTo()).getTopicName());
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }

    @TestTemplate
    public void testReplyToFromAMQPClientWithTempQueueReplyToAddress() throws Throwable {
        AmqpClient directClient = new AmqpClient(new URI("tcp://localhost:61616"), null, null);
        AmqpConnection connection = null;
        AmqpSession session = null;
        AmqpSender sender = null;
        Connection consumerConn = null;
        try {
            connection = directClient.connect(true);
            session = connection.createSession();
            sender = session.createSender(queueName.toString());
            String replyToName = UUID.randomUUID().toString();
            AmqpMessage message = new AmqpMessage();
            message.setReplyToAddress(replyToName);
            message.setMessageId("msg-1");
            message.setMessageAnnotation("x-opt-jms-reply-to", (byte)2);
            message.setText("Test-Message");
            sender.send(message);
            consumerConn = this.consumerCF.createConnection();
            Session consumerSess = consumerConn.createSession(false, 1);
            Queue queue = consumerSess.createQueue(queueName.toString());
            MessageConsumer consumer = consumerSess.createConsumer((Destination)queue);
            consumerConn.start();
            Message receivedMessage = consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertTrue((boolean)(receivedMessage.getJMSReplyTo() instanceof TemporaryQueue));
            Assertions.assertEquals((Object)replyToName, (Object)((TemporaryQueue)receivedMessage.getJMSReplyTo()).getQueueName());
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            try {
                connection.close();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            try {
                consumerConn.close();
            }
            catch (Throwable dontcare) {
                dontcare.printStackTrace();
            }
        }
    }
}

