/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.http;

import java.util.HashMap;
import java.util.Random;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class CoreClientOverHttpTest
extends ActiveMQTestBase {
    private static final SimpleString QUEUE = SimpleString.of((String)"CoreClientOverHttpTestQueue");
    private Configuration conf;
    private ActiveMQServer server;
    private ServerLocator locator;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Boolean> params = new HashMap<String, Boolean>();
        params.put("httpEnabled", true);
        this.conf = this.createDefaultInVMConfig().clearAcceptorConfigurations().addAcceptorConfiguration(new TransportConfiguration(NETTY_ACCEPTOR_FACTORY, params));
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.conf, (boolean)false));
        this.server.start();
        this.locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{new TransportConfiguration(NETTY_CONNECTOR_FACTORY, params)}));
    }

    @Test
    public void testCoreHttpClient() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        int numMessages = 100;
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            message.getBodyBuffer().writeString("CoreClientOverHttpTest");
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive();
            Assertions.assertEquals((Object)"CoreClientOverHttpTest", (Object)message2.getBodyBuffer().readString());
            message2.acknowledge();
        }
        session.close();
    }

    @Test
    public void testCoreHttpClientIdle() throws Exception {
        this.locator.setConnectionTTL(500L);
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        Thread.sleep(2500L);
        session.close();
    }

    @Test
    public void testCoreHttpClient8kPlus() throws Exception {
        ClientSessionFactory sf = this.createSessionFactory(this.locator);
        ClientSession session = sf.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((SimpleString)QUEUE).setDurable(Boolean.valueOf(false)));
        ClientProducer producer = session.createProducer(QUEUE);
        int numMessages = 100;
        String[] content = new String[100];
        for (int i = 0; i < 100; ++i) {
            ClientMessage message = session.createMessage((byte)3, false, 0L, System.currentTimeMillis(), (byte)1);
            content[i] = this.getFixedSizeString((i % 5 + 1) * 1024 * 8);
            message.getBodyBuffer().writeString(content[i]);
            producer.send((Message)message);
        }
        ClientConsumer consumer = session.createConsumer(QUEUE);
        session.start();
        for (int i = 0; i < 100; ++i) {
            ClientMessage message2 = consumer.receive();
            Assertions.assertEquals((Object)content[i], (Object)message2.getBodyBuffer().readString());
            message2.acknowledge();
        }
        session.close();
    }

    private String getFixedSizeString(int size) {
        StringBuffer sb = new StringBuffer();
        Random r = new Random();
        for (int i = 0; i < size; ++i) {
            char chr = (char)r.nextInt(256);
            sb.append(chr);
        }
        String result = sb.toString();
        return result;
    }
}

