/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageEOFException;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.lang.invoke.MethodHandles;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.tests.util.JMSTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageTest
extends JMSTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final long TIMEOUT = 1000L;
    private static final String propName1 = "myprop1";
    private static final String propName2 = "myprop2";
    private static final String propName3 = "myprop3";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testStreamMessageReadsNull() throws Exception {
        try (Connection conn = this.cf.createConnection();){
            Queue queue = this.createQueue("testQueue");
            Session sess = conn.createSession(false, 1);
            MessageProducer prod = sess.createProducer((Destination)queue);
            MessageConsumer cons = sess.createConsumer((Destination)queue);
            conn.start();
            StreamMessage msg = sess.createStreamMessage();
            msg.writeInt(1);
            msg.writeInt(2);
            msg.writeInt(3);
            StreamMessage received = (StreamMessage)this.sendAndConsumeMessage((Message)msg, prod, cons);
            Assertions.assertNotNull((Object)received);
            Assertions.assertEquals((Object)1, (Object)received.readObject());
            Assertions.assertEquals((Object)2, (Object)received.readObject());
            Assertions.assertEquals((Object)3, (Object)received.readObject());
            try {
                received.readObject();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readBoolean();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readByte();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readChar();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readDouble();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readFloat();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readInt();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readLong();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readShort();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
            try {
                received.readString();
                Assertions.fail((String)"Should throw exception");
            }
            catch (MessageEOFException messageEOFException) {
                // empty catch block
            }
        }
    }

    @Test
    public void testNullProperties() throws Exception {
        this.conn = this.cf.createConnection();
        Queue queue = this.createQueue("testQueue");
        Session sess = this.conn.createSession(false, 1);
        MessageProducer prod = sess.createProducer((Destination)queue);
        MessageConsumer cons = sess.createConsumer((Destination)queue);
        this.conn.start();
        Message msg = sess.createMessage();
        msg.setStringProperty("Test", "SomeValue");
        Assertions.assertEquals((Object)"SomeValue", (Object)msg.getStringProperty("Test"));
        msg.setStringProperty("Test", null);
        Assertions.assertNull((Object)msg.getStringProperty("Test"));
        msg.setObjectProperty(propName1, null);
        msg.setObjectProperty("JMSXGroupID", null);
        msg.setObjectProperty("JMSXUserID", null);
        msg.setStringProperty(propName2, null);
        msg.getStringProperty(propName1);
        msg.setStringProperty("Test", null);
        Message received = this.sendAndConsumeMessage(msg, prod, cons);
        Assertions.assertNotNull((Object)received);
        this.checkProperties(received);
    }

    private void checkProperties(Message message) throws Exception {
        Assertions.assertNull((Object)message.getObjectProperty(propName1));
        Assertions.assertNull((Object)message.getStringProperty(propName1));
        Assertions.assertNull((Object)message.getStringProperty(propName2));
        Assertions.assertNull((Object)message.getObjectProperty(propName2));
        Assertions.assertNull((Object)message.getStringProperty(propName3));
        Assertions.assertNull((Object)message.getObjectProperty(propName3));
        try {
            logger.debug("{}", (Object)message.getIntProperty(propName1));
            Assertions.fail((String)"Should throw exception");
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            logger.debug("{}", (Object)message.getShortProperty(propName1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            logger.debug("{}", (Object)message.getByteProperty(propName1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        Assertions.assertFalse((boolean)message.getBooleanProperty(propName1));
        try {
            logger.debug("{}", (Object)message.getLongProperty(propName1));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            logger.debug("{}", (Object)Float.valueOf(message.getFloatProperty(propName1)));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            logger.debug("{}", (Object)message.getDoubleProperty(propName1));
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Test
    public void testWildcardRoutingHierarchyWithMultipleConsumers() throws Exception {
        Topic parentTopic = this.createTopic(true, "a.#");
        Topic childTopic = this.createTopic(true, "a.b.#");
        try (Connection conn = this.cf.createConnection();){
            conn.start();
            try (Session session = conn.createSession(false, 2);){
                MessageConsumer parentConsumer = session.createConsumer((Destination)parentTopic);
                MessageConsumer childConsumer = session.createConsumer((Destination)childTopic);
                MessageProducer producer = session.createProducer(null);
                producer.send((Destination)session.createTopic("a.b.c"), (Message)session.createTextMessage("m1"));
                producer.send((Destination)session.createTopic("a.b"), (Message)session.createTextMessage("m2"));
                Message m = parentConsumer.receive(5000L);
                Assertions.assertTrue((boolean)(m instanceof TextMessage));
                Assertions.assertEquals((Object)"m1", (Object)((TextMessage)m).getText());
                m = parentConsumer.receive(5000L);
                Assertions.assertTrue((boolean)(m instanceof TextMessage));
                Assertions.assertEquals((Object)"m2", (Object)((TextMessage)m).getText());
                m = childConsumer.receive(5000L);
                Assertions.assertTrue((boolean)(m instanceof TextMessage));
                Assertions.assertEquals((Object)"m1", (Object)((TextMessage)m).getText());
                m = childConsumer.receive(5000L);
                Assertions.assertTrue((boolean)(m instanceof TextMessage));
                Assertions.assertEquals((Object)"m2", (Object)((TextMessage)m).getText());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testShouldNotThrowException() throws Exception {
        Connection conn = null;
        this.createTopic(true, "Topic1");
        try {
            conn = this.cf.createConnection();
            conn.start();
            Session session1 = conn.createSession(false, 2);
            session1.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"Topic1"));
            Session session2 = conn.createSession(false, 2);
            session2.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"*"));
            session1.close();
            session2.close();
            Session session3 = conn.createSession(false, 2);
            MessageConsumer cons = session3.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"Topic1"));
            MessageProducer prod = session3.createProducer((Destination)ActiveMQJMSClient.createTopic((String)"Topic1"));
            MessageConsumer consGeral = session3.createConsumer((Destination)ActiveMQJMSClient.createTopic((String)"*"));
            prod.send((Message)session3.createTextMessage("hello"));
            Assertions.assertNotNull((Object)cons.receive(5000L));
            Assertions.assertNotNull((Object)consGeral.receive(5000L));
            this.createTopic(true, "Topic2");
            MessageProducer prod2 = session3.createProducer((Destination)ActiveMQJMSClient.createTopic((String)"Topic2"));
            prod2.send((Message)session3.createTextMessage("test"));
            Assertions.assertNull((Object)cons.receiveNoWait());
            Assertions.assertNotNull((Object)consGeral.receive(5000L));
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private Message sendAndConsumeMessage(Message msg, MessageProducer prod, MessageConsumer cons) throws Exception {
        prod.send(msg);
        Message received = cons.receive(1000L);
        return received;
    }
}

