/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.jms.client;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.api.jms.JMSFactoryType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class RemoteConnectionStressTest
extends ActiveMQTestBase {
    ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)this.createDefaultNettyConfig(), (boolean)false));
        this.server.start();
    }

    @Test
    public void testSimpleRemoteConnections() throws Exception {
        for (int i = 0; i < 1000; ++i) {
            TransportConfiguration config = new TransportConfiguration(NETTY_CONNECTOR_FACTORY);
            ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactoryWithoutHA((JMSFactoryType)JMSFactoryType.CF, (TransportConfiguration[])new TransportConfiguration[]{config});
            cf.setInitialConnectAttempts(10);
            cf.setRetryInterval(100L);
            Connection conn = cf.createConnection();
            Session session = conn.createSession(false, 1);
            Queue queue = session.createQueue("SomeQueue");
            MessageProducer producer = session.createProducer((Destination)queue);
            TextMessage msg = session.createTextMessage();
            msg.setText("Message " + i);
            producer.send((Message)msg);
            producer.close();
            session.close();
            conn.close();
            cf.close();
        }
    }
}

