/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.management;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.management.BridgeControl;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ObjectNameBuilder;
import org.apache.activemq.artemis.core.config.BridgeConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.impl.ConfigurationImpl;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMAcceptorFactory;
import org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServers;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.tests.integration.SimpleNotificationService;
import org.apache.activemq.artemis.tests.integration.management.ManagementControlHelper;
import org.apache.activemq.artemis.tests.integration.management.ManagementTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BridgeControlTest
extends ManagementTestBase {
    private ActiveMQServer server_0;
    private ActiveMQServer server_1;
    private BridgeConfiguration bridgeConfig;

    @Test
    public void testAttributes() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(this.bridgeConfig.getName()));
        BridgeControl bridgeControl = this.createBridgeControl(this.bridgeConfig.getName(), this.mbeanServer);
        Assertions.assertEquals((Object)this.bridgeConfig.getName(), (Object)bridgeControl.getName());
        Assertions.assertEquals((Object)this.bridgeConfig.getDiscoveryGroupName(), (Object)bridgeControl.getDiscoveryGroupName());
        Assertions.assertEquals((Object)this.bridgeConfig.getQueueName(), (Object)bridgeControl.getQueueName());
        Assertions.assertEquals((Object)this.bridgeConfig.getForwardingAddress(), (Object)bridgeControl.getForwardingAddress());
        Assertions.assertEquals((Object)this.bridgeConfig.getFilterString(), (Object)bridgeControl.getFilterString());
        Assertions.assertEquals((long)this.bridgeConfig.getRetryInterval(), (long)bridgeControl.getRetryInterval());
        Assertions.assertEquals((double)this.bridgeConfig.getRetryIntervalMultiplier(), (double)bridgeControl.getRetryIntervalMultiplier(), (double)1.0E-6);
        Assertions.assertEquals((long)this.bridgeConfig.getMaxRetryInterval(), (long)bridgeControl.getMaxRetryInterval());
        Assertions.assertEquals((int)this.bridgeConfig.getReconnectAttempts(), (int)bridgeControl.getReconnectAttempts());
        Assertions.assertEquals((Object)this.bridgeConfig.isUseDuplicateDetection(), (Object)bridgeControl.isUseDuplicateDetection());
        Map bridgeMetrics = bridgeControl.getMetrics();
        Assertions.assertEquals((long)0L, (long)bridgeControl.getMessagesPendingAcknowledgement());
        Assertions.assertEquals((long)0L, (long)bridgeControl.getMessagesAcknowledged());
        Assertions.assertEquals((Object)0L, bridgeMetrics.get("messagesPendingAcknowledgement"));
        Assertions.assertEquals((Object)0L, bridgeMetrics.get("messagesAcknowledged"));
        String[] connectorPairData = bridgeControl.getStaticConnectors();
        Assertions.assertEquals(this.bridgeConfig.getStaticConnectors().get(0), (Object)connectorPairData[0]);
        Assertions.assertTrue((boolean)bridgeControl.isStarted());
    }

    @Test
    public void testStartStop() throws Exception {
        this.checkResource(ObjectNameBuilder.DEFAULT.getBridgeObjectName(this.bridgeConfig.getName()));
        BridgeControl bridgeControl = this.createBridgeControl(this.bridgeConfig.getName(), this.mbeanServer);
        Assertions.assertTrue((boolean)bridgeControl.isStarted());
        bridgeControl.stop();
        Assertions.assertFalse((boolean)bridgeControl.isStarted());
        bridgeControl.start();
        Assertions.assertTrue((boolean)bridgeControl.isStarted());
    }

    @Test
    public void testNotifications() throws Exception {
        SimpleNotificationService.Listener notifListener = new SimpleNotificationService.Listener();
        BridgeControl bridgeControl = this.createBridgeControl(this.bridgeConfig.getName(), this.mbeanServer);
        this.server_0.getManagementService().addNotificationListener((NotificationListener)notifListener);
        Assertions.assertEquals((int)0, (int)notifListener.getNotifications().size());
        bridgeControl.stop();
        Assertions.assertEquals((int)1, (int)notifListener.getNotifications().size());
        Notification notif = notifListener.getNotifications().get(0);
        Assertions.assertEquals((Object)CoreNotificationType.BRIDGE_STOPPED, (Object)notif.getType());
        Assertions.assertEquals((Object)bridgeControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
        bridgeControl.start();
        Assertions.assertEquals((int)2, (int)notifListener.getNotifications().size());
        notif = notifListener.getNotifications().get(1);
        Assertions.assertEquals((Object)CoreNotificationType.BRIDGE_STARTED, (Object)notif.getType());
        Assertions.assertEquals((Object)bridgeControl.getName(), (Object)notif.getProperties().getSimpleStringProperty(SimpleString.of((String)"name")).toString());
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        HashMap<String, Integer> acceptorParams = new HashMap<String, Integer>();
        acceptorParams.put("serverId", 1);
        TransportConfiguration acceptorConfig = new TransportConfiguration(InVMAcceptorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        TransportConfiguration connectorConfig = new TransportConfiguration(InVMConnectorFactory.class.getName(), acceptorParams, RandomUtil.randomString());
        QueueConfiguration sourceQueueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        QueueConfiguration targetQueueConfig = QueueConfiguration.of((String)RandomUtil.randomString()).setDurable(Boolean.valueOf(false));
        ArrayList<String> connectors = new ArrayList<String>();
        connectors.add(connectorConfig.getName());
        ConfigurationImpl conf_1 = this.createBasicConfig().addAcceptorConfiguration(acceptorConfig).addQueueConfiguration(targetQueueConfig);
        this.bridgeConfig = new BridgeConfiguration().setName(RandomUtil.randomString()).setQueueName(sourceQueueConfig.getName().toString()).setForwardingAddress(targetQueueConfig.getAddress().toString()).setRetryInterval(RandomUtil.randomPositiveLong()).setRetryIntervalMultiplier(RandomUtil.randomDouble()).setInitialConnectAttempts(RandomUtil.randomPositiveInt()).setReconnectAttempts(RandomUtil.randomPositiveInt()).setReconnectAttemptsOnSameNode(RandomUtil.randomPositiveInt()).setUseDuplicateDetection(RandomUtil.randomBoolean()).setConfirmationWindowSize(RandomUtil.randomPositiveInt()).setStaticConnectors(connectors).setPassword("UnitTestsClusterPassword");
        ConfigurationImpl conf_0 = this.createBasicConfig().addAcceptorConfiguration(new TransportConfiguration(InVMAcceptorFactory.class.getName())).addConnectorConfiguration(connectorConfig.getName(), connectorConfig).addQueueConfiguration(sourceQueueConfig).addBridgeConfiguration(this.bridgeConfig);
        this.server_1 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_1, (MBeanServer)this.createMBeanServer(), (boolean)false));
        this.addServer(this.server_1);
        this.server_1.start();
        this.server_0 = this.addServer(ActiveMQServers.newActiveMQServer((Configuration)conf_0, (MBeanServer)this.mbeanServer, (boolean)false));
        this.addServer(this.server_0);
        this.server_0.start();
    }

    protected BridgeControl createBridgeControl(String name, MBeanServer mbeanServer1) throws Exception {
        return ManagementControlHelper.createBridgeControl(name, mbeanServer1);
    }
}

