/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.eclipse.paho.mqttv5.client.MqttCallback;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class MessageDeliveryRetryTests
extends MQTT5TestSupport {
    @Test
    @Timeout(value=60L)
    public void testCleanStartFalseWithReconnect() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient producer = this.createPahoClient(RandomUtil.randomString());
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().cleanStart(false).sessionExpiryInterval(Long.valueOf(300L)).build();
        consumer.connect(options);
        consumer.subscribe(TOPIC, 2);
        consumer.disconnect();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        producer.connect();
        producer.publish(TOPIC, "hello".getBytes(), 2, false);
        producer.disconnect();
        producer.close();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.connect(options);
        MessageDeliveryRetryTests.waitForLatch(latch);
        consumer.disconnect();
        consumer.close();
        Assertions.assertEquals((int)1, (int)this.getSessionStates().size());
        Assertions.assertNotNull((Object)this.getSessionStates().get(CONSUMER_ID));
    }

    @Test
    @Timeout(value=60L)
    public void testTopicFilter() throws Exception {
        String CONSUMER_ID = RandomUtil.randomString();
        String TOPIC = this.getTopicName();
        CountDownLatch latch = new CountDownLatch(1);
        MqttClient consumer = this.createPahoClient(CONSUMER_ID);
        consumer.connect();
        consumer.setCallback((MqttCallback)new MQTT5TestSupport.LatchedMqttCallback(this, latch));
        consumer.subscribe(TOPIC, 1);
        MqttClient producer = this.createPahoClient("producer");
        producer.connect();
        producer.publish(TOPIC, "hello".getBytes(), 1, false);
        producer.disconnect();
        producer.close();
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.SECONDS));
        consumer.disconnect();
        consumer.close();
    }
}

