/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.mqtt5.spec.controlpackets;

import java.nio.charset.StandardCharsets;
import org.apache.activemq.artemis.tests.integration.mqtt5.MQTT5TestSupport;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.eclipse.paho.mqttv5.client.IMqttToken;
import org.eclipse.paho.mqttv5.client.MqttClient;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptions;
import org.eclipse.paho.mqttv5.client.MqttConnectionOptionsBuilder;
import org.eclipse.paho.mqttv5.common.MqttSubscription;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;

public class SubscribeTestsWithSecurity
extends MQTT5TestSupport {
    @Override
    public boolean isSecurityEnabled() {
        return true;
    }

    @Test
    @Timeout(value=60L)
    public void testAuthorizationFailure() throws Exception {
        String CLIENT_ID = "consumer";
        int SUBSCRIPTION_COUNT = 10;
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.noprivUser).password(this.noprivPass.getBytes(StandardCharsets.UTF_8)).build();
        MqttClient client = this.createPahoClient("consumer");
        client.connect(options);
        MqttSubscription[] subscriptions = new MqttSubscription[10];
        for (int i = 0; i < 10; ++i) {
            MqttSubscription subscription;
            subscriptions[i] = subscription = new MqttSubscription(RandomUtil.randomString(), RandomUtil.randomInterval((int)0, (int)3));
        }
        IMqttToken token = client.subscribe(subscriptions);
        int[] reasonCodes = token.getResponse().getReasonCodes();
        Assertions.assertEquals((int)10, (int)reasonCodes.length);
        for (int reasonCode : reasonCodes) {
            Assertions.assertEquals((byte)-121, (byte)((byte)reasonCode));
        }
    }

    @Test
    @Timeout(value=60L)
    public void testAuthorizationSuccess() throws Exception {
        String CLIENT_ID = "consumer";
        int SUBSCRIPTION_COUNT = 10;
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.fullUser).password(this.fullPass.getBytes(StandardCharsets.UTF_8)).build();
        MqttClient client = this.createPahoClient("consumer");
        client.connect(options);
        MqttSubscription[] subscriptions = new MqttSubscription[10];
        int[] requestedQos = new int[10];
        for (int i = 0; i < 10; ++i) {
            MqttSubscription subscription;
            requestedQos[i] = RandomUtil.randomInterval((int)0, (int)3);
            subscriptions[i] = subscription = new MqttSubscription(RandomUtil.randomString(), requestedQos[i]);
        }
        IMqttToken token = client.subscribe(subscriptions);
        int[] reasonCodes = token.getResponse().getReasonCodes();
        Assertions.assertEquals((int)10, (int)reasonCodes.length);
        for (int i = 0; i < reasonCodes.length; ++i) {
            Assertions.assertEquals((int)requestedQos[i], (int)reasonCodes[i]);
        }
        client.disconnect();
    }

    @Test
    @Timeout(value=60L)
    public void testSubscriptionQueueRemoved() throws Exception {
        String CONSUMER_ID = "consumer";
        MqttConnectionOptions options = new MqttConnectionOptionsBuilder().username(this.noDeleteUser).password(this.noDeletePass.getBytes(StandardCharsets.UTF_8)).build();
        MqttClient client = this.createPahoClient("consumer");
        client.connect(options);
        client.subscribe(this.getTopicName(), 0).waitForCompletion();
        client.disconnect();
        Wait.assertTrue(() -> this.getSubscriptionQueue(this.getTopicName(), "consumer") == null, (long)2000L, (long)100L);
    }
}

