/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire;

import jakarta.jms.ConnectionFactory;
import java.util.HashSet;
import java.util.Map;
import javax.management.MBeanServer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.spi.core.security.ActiveMQJAASSecurityManager;
import org.apache.activemq.artemis.tests.unit.util.InVMNamingContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;

public class OpenWireTestBase
extends ActiveMQTestBase {
    public static final String OWHOST = "localhost";
    public static final int OWPORT = 61616;
    protected static final String urlString = "tcp://localhost:61616?wireFormat.cacheEnabled=true";
    protected static final String urlStringLoose = "tcp://localhost:61616?wireFormat.tightEncodingEnabled=false";
    protected ActiveMQServer server;
    protected boolean realStore = false;
    protected boolean enableSecurity = false;
    protected ConnectionFactory coreCf;
    protected InVMNamingContext namingContext;
    protected MBeanServer mbeanServer;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(this.realStore, true);
        Configuration serverConfig = this.server.getConfiguration();
        Map addressSettingsMap = serverConfig.getAddressSettings();
        this.configureAddressSettings(addressSettingsMap);
        serverConfig.setSecurityEnabled(this.enableSecurity);
        this.extraServerConfig(serverConfig);
        if (this.enableSecurity) {
            ActiveMQJAASSecurityManager securityManager = (ActiveMQJAASSecurityManager)this.server.getSecurityManager();
            securityManager.getConfiguration().addRole("openwireSender", "sender");
            securityManager.getConfiguration().addUser("openwireSender", "SeNdEr");
            Role senderRole = new Role("sender", true, false, false, false, true, true, false, false, true, true, false, false);
            securityManager.getConfiguration().addRole("openwireReceiver", "receiver");
            securityManager.getConfiguration().addUser("openwireReceiver", "ReCeIvEr");
            Role receiverRole = new Role("receiver", false, true, false, false, true, true, false, true, false, false, false, false);
            securityManager.getConfiguration().addRole("openwireGuest", "guest");
            securityManager.getConfiguration().addUser("openwireGuest", "GuEsT");
            Role guestRole = new Role("guest", false, false, false, false, false, false, false, false, false, false, false, false);
            securityManager.getConfiguration().addRole("openwireDestinationManager", "manager");
            securityManager.getConfiguration().addUser("openwireDestinationManager", "DeStInAtIoN");
            Role destRole = new Role("manager", false, false, false, false, true, true, false, false, true, false, false, false);
            HashSet<Role> roles = new HashSet<Role>();
            roles.add(senderRole);
            roles.add(receiverRole);
            roles.add(guestRole);
            roles.add(destRole);
            this.server.getConfiguration().putSecurityRoles("#", roles);
            Role advisoryReceiverRole = new Role("advisoryReceiver", false, true, false, false, true, true, false, true, true, false, false, false);
            roles = new HashSet();
            roles.add(advisoryReceiverRole);
            this.server.getConfiguration().putSecurityRoles("ActiveMQ.Advisory.#", roles);
            securityManager.getConfiguration().addRole("openwireReceiver", "advisoryReceiver");
            securityManager.getConfiguration().addRole("openwireSender", "advisoryReceiver");
            securityManager.getConfiguration().addRole("openwireGuest", "advisoryReceiver");
            securityManager.getConfiguration().addRole("openwireDestinationManager", "advisoryReceiver");
        }
        this.mbeanServer = this.createMBeanServer();
        this.server.setMBeanServer(this.mbeanServer);
        this.addServer(this.server);
        this.server.start();
        this.coreCf = ActiveMQJMSClient.createConnectionFactory((String)"vm://0?reconnectAttempts=-1", (String)"cf");
    }

    protected void configureAddressSettings(Map<String, AddressSettings> addressSettingsMap) {
        addressSettingsMap.put("#", new AddressSettings().setAutoCreateQueues(Boolean.valueOf(false)).setAutoCreateAddresses(Boolean.valueOf(false)).setDeadLetterAddress(SimpleString.of((String)"ActiveMQ.DLQ")).setAutoCreateAddresses(Boolean.valueOf(true)));
    }

    protected void extraServerConfig(Configuration serverConfig) {
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.mbeanServer = null;
        this.server.stop();
        super.tearDown();
    }
}

