/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import java.util.Arrays;
import java.util.Collection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSConsumer12Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public byte destinationType;

    @Parameters(name="deliveryMode={0} destinationType={1}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, (byte)1}, {1, (byte)2});
    }

    public JMSConsumer12Test(int deliveryMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.destinationType = destinationType;
    }

    @TestTemplate
    public void testDontStart() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 1);
        Assertions.assertNull((Object)consumer.receive(1000L));
    }

    @TestTemplate
    public void testStartAfterSend() throws Exception {
        Session session = this.connection.createSession(false, 1);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        this.sendMessages(session, (Destination)destination, 1);
        this.connection.start();
        Assertions.assertNotNull((Object)consumer.receive(1000L));
        Assertions.assertNull((Object)consumer.receiveNoWait());
    }
}

