/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.amq;

import jakarta.jms.Destination;
import jakarta.jms.MessageConsumer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.ActiveMQConnection;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.integration.openwire.BasicOpenWireTest;
import org.apache.activemq.command.ActiveMQDestination;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class JMSConsumer7Test
extends BasicOpenWireTest {
    public int deliveryMode;
    public int ackMode;
    public byte destinationType;

    @Parameters(name="deliveryMode={0} ackMode={1} destinationType={2}")
    public static Collection<Object[]> getParams() {
        return Arrays.asList({1, 2, (byte)1}, {2, 2, (byte)1});
    }

    public JMSConsumer7Test(int deliveryMode, int ackMode, byte destinationType) {
        this.deliveryMode = deliveryMode;
        this.ackMode = ackMode;
        this.destinationType = destinationType;
    }

    @TestTemplate
    public void testMessageListenerOnMessageCloseUnackedWithPrefetch1StayInQueue() throws Exception {
        AtomicInteger counter = new AtomicInteger(0);
        CountDownLatch sendDone = new CountDownLatch(1);
        CountDownLatch got2Done = new CountDownLatch(1);
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.setOptimizedMessageDispatch(false);
        this.connection.start();
        Session session = this.connection.createSession(false, this.ackMode);
        ActiveMQDestination destination = this.createDestination(session, this.destinationType);
        MessageConsumer consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(m -> {
            try {
                TextMessage tm = (TextMessage)m;
                Assertions.assertEquals((Object)("" + counter.get()), (Object)tm.getText());
                counter.incrementAndGet();
                if (counter.get() == 2) {
                    sendDone.await();
                    this.connection.close();
                    got2Done.countDown();
                }
                tm.acknowledge();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        this.sendMessages(session, (Destination)destination, 4);
        sendDone.countDown();
        Assertions.assertTrue((boolean)got2Done.await(100000L, TimeUnit.MILLISECONDS));
        this.connection = (ActiveMQConnection)this.factory.createConnection();
        this.connection.getPrefetchPolicy().setAll(1);
        this.connection.start();
        CountDownLatch done2 = new CountDownLatch(1);
        session = this.connection.createSession(false, this.ackMode);
        consumer = session.createConsumer((Destination)destination);
        consumer.setMessageListener(m -> {
            try {
                TextMessage tm = (TextMessage)m;
                counter.incrementAndGet();
                if (counter.get() == 4) {
                    done2.countDown();
                }
            }
            catch (Throwable e) {
                System.err.println("Unexpected exception: " + e);
            }
        });
        Assertions.assertTrue((boolean)done2.await(1000L, TimeUnit.MILLISECONDS));
        Thread.sleep(200L);
        Assertions.assertEquals((int)5, (int)counter.get());
    }
}

