/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.openwire.cluster;

import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.tests.integration.cluster.distribution.ClusterTestBase;
import org.junit.jupiter.api.BeforeEach;

public class OpenWireJMSClusteredTestBase
extends ClusterTestBase {
    protected ActiveMQConnectionFactory openWireCf1;
    protected ActiveMQConnectionFactory openWireCf2;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.setupServer(0, this.isFileStorage(), true);
        this.setupServer(1, this.isFileStorage(), true);
        this.setupClusterConnection("cluster0", "", MessageLoadBalancingType.ON_DEMAND, 1, true, 0, 1);
        this.setupClusterConnection("cluster1", "", MessageLoadBalancingType.ON_DEMAND, 1, true, 1, 0);
        this.startServers(0, 1);
        OpenWireJMSClusteredTestBase.waitForTopology(this.servers[0], 2);
        OpenWireJMSClusteredTestBase.waitForTopology(this.servers[1], 2);
        this.setupSessionFactory(0, true);
        this.setupSessionFactory(1, true);
        String uri1 = this.getServerUri(0);
        String uri2 = this.getServerUri(1);
        this.openWireCf1 = new ActiveMQConnectionFactory(uri1);
        this.openWireCf2 = new ActiveMQConnectionFactory(uri2);
    }

    @Override
    protected boolean isResolveProtocols() {
        return true;
    }
}

