/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.paging;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PagingMaxReadLimitTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ActiveMQServer server;

    @Test
    public void testMaxReadPageMessages() throws Exception {
        ExecutorService service = Executors.newSingleThreadExecutor();
        this.runAfter(service::shutdownNow);
        Configuration config = this.createDefaultConfig(true);
        config.setJournalSyncTransactional(false).setJournalSyncTransactional(false);
        int PAGE_MAX = 20480;
        int PAGE_SIZE = 10240;
        this.server = this.createServer(true, config, 10240, 20480L, 100, -1, 204800L, null, null, null);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo(this.getName()).addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)this.getName()).setRoutingType(RoutingType.ANYCAST));
        Wait.assertTrue(() -> this.server.locateQueue(this.getName()) != null);
        Queue serverQueue = this.server.locateQueue(this.getName());
        ConnectionFactory connectionFactory = CFUtil.createConnectionFactory("CORE", "tcp://localhost:61616");
        try (Connection connection = connectionFactory.createConnection();){
            Session session = connection.createSession(true, 0);
            jakarta.jms.Queue queue = session.createQueue(this.getName());
            MessageProducer producer = session.createProducer((Destination)queue);
            producer.setDeliveryMode(1);
            for (int i = 0; i < 500; ++i) {
                producer.send((Message)session.createTextMessage("Hello " + i));
            }
            session.commit();
            Assertions.assertTrue((boolean)serverQueue.getPagingStore().isPaging());
        }
        AssertionLoggerHandler loggerHandler = new AssertionLoggerHandler();
        this.runAfter(() -> loggerHandler.close());
        AtomicInteger errorCounter = new AtomicInteger(0);
        CountDownLatch done = new CountDownLatch(1);
        service.execute(() -> {
            try (Connection connection = connectionFactory.createConnection();){
                connection.start();
                Session session = connection.createSession(true, 0);
                jakarta.jms.Queue queue = session.createQueue(this.getName());
                MessageConsumer consumer = session.createConsumer((Destination)queue);
                int i = 0;
                while (i < 500) {
                    Message message = consumer.receive(10L);
                    if (message == null) {
                        session.commit();
                        continue;
                    }
                    ++i;
                }
                session.commit();
            }
            catch (Throwable e) {
                logger.debug(e.getMessage(), e);
                errorCounter.incrementAndGet();
            }
            finally {
                done.countDown();
            }
        });
        Assertions.assertTrue((boolean)done.await(5L, TimeUnit.SECONDS));
        Wait.assertTrue(() -> loggerHandler.findText(new String[]{"AMQ224127"}), (long)2000L, (long)10L);
        Assertions.assertEquals((int)0, (int)errorCounter.get());
    }
}

