/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.List;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.persistence.config.PersistedConnector;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class ConnectorStorageTest
extends StorageManagerTestBase {
    public ConnectorStorageTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @TestTemplate
    public void testStoreConnector() throws Exception {
        String NAME = RandomUtil.randomString();
        String URL2 = RandomUtil.randomString();
        PersistedConnector connector = new PersistedConnector(NAME, URL2);
        this.journal.storeConnector(connector);
        this.rebootStorage();
        List connectors = this.journal.recoverConnectors();
        Assertions.assertEquals((int)1, (int)connectors.size());
        PersistedConnector persistedConnector = (PersistedConnector)connectors.get(0);
        Assertions.assertEquals((Object)NAME, (Object)persistedConnector.getName());
        Assertions.assertEquals((Object)URL2, (Object)persistedConnector.getUrl());
    }
}

