/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.config.StoreConfiguration;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.OperationContextImpl;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.impl.DuplicateIDCaches;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.persistence.StorageManagerTestBase;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class DuplicateCacheTest
extends StorageManagerTestBase {
    public DuplicateCacheTest(StoreConfiguration.StoreType storeType) {
        super(storeType);
    }

    @TestTemplate
    public void testDuplicate() throws Exception {
        byte[] bytes;
        int i;
        DuplicateIDCache cache = DuplicateIDCaches.persistent((SimpleString)SimpleString.of((String)"test"), (int)2000, (StorageManager)this.journal);
        TransactionImpl tx = new TransactionImpl(this.journal);
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, (Transaction)tx);
        }
        tx.commit();
        tx = new TransactionImpl(this.journal);
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, (Transaction)tx);
        }
        tx.commit();
        byte[] id = RandomUtil.randomBytes();
        Assertions.assertFalse((boolean)cache.contains(id));
        cache.addToCache(id, null);
        Assertions.assertTrue((boolean)cache.contains(id));
        cache.deleteFromCache(id);
        final CountDownLatch latch = new CountDownLatch(1);
        OperationContextImpl.getContext().executeOnCompletion(new IOCallback(){

            public void done() {
                latch.countDown();
            }

            public void onError(int errorCode, String errorMessage) {
            }
        }, true);
        Assertions.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
        Assertions.assertFalse((boolean)cache.contains(id));
        cache.clear();
    }

    @TestTemplate
    public void testDuplicateNonPersistent() throws Exception {
        byte[] bytes;
        int i;
        DuplicateIDCache cache = DuplicateIDCaches.inMemory((SimpleString)SimpleString.of((String)"test"), (int)2000);
        TransactionImpl tx = new TransactionImpl(this.journal);
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, (Transaction)tx);
        }
        tx.commit();
        for (i = 0; i < 5000; ++i) {
            bytes = RandomUtil.randomBytes();
            cache.addToCache(bytes, null);
        }
        cache.clear();
    }

    @TestTemplate
    public void testDisabledPersistentCache() throws Exception {
        this.createStorage();
        DuplicateIDCache cache = DuplicateIDCaches.persistent((SimpleString)SimpleString.of((String)"test"), (int)0, (StorageManager)this.journal);
        byte[] bytes = RandomUtil.randomBytes();
        cache.addToCache(bytes);
    }

    @TestTemplate
    public void testDisabledInMemoryCache() throws Exception {
        this.createStorage();
        DuplicateIDCache cache = DuplicateIDCaches.inMemory((SimpleString)SimpleString.of((String)"test"), (int)0);
        byte[] bytes = RandomUtil.randomBytes();
        cache.addToCache(bytes);
    }
}

