/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class QueueConfigRestartTest
extends ActiveMQTestBase {
    private static final String ADDRESS = "ADDRESS";

    @Test
    public void testQueueConfigPurgeOnNoConsumerAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(true)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding1.getQueue().isPurgeOnNoConsumers());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding2.getQueue().isPurgeOnNoConsumers());
    }

    @Test
    public void testQueueConfigLastValueAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding1.getQueue().isLastValue());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding2.getQueue().isLastValue());
    }

    @Test
    public void testQueueConfigExclusiveAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setLastValue(Boolean.valueOf(true)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding1.getQueue().isExclusive());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding2.getQueue().isExclusive());
    }

    @Test
    public void testQueueConfigConsumersBeforeDispatchAndRestart() throws Exception {
        int consumersBeforeDispatch = 5;
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setConsumersBeforeDispatch(Integer.valueOf(consumersBeforeDispatch)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertEquals((int)consumersBeforeDispatch, (int)queueBinding1.getQueue().getConsumersBeforeDispatch());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertEquals((int)consumersBeforeDispatch, (int)queueBinding1.getQueue().getConsumersBeforeDispatch());
    }

    @Test
    public void testQueueConfigDelayBeforeDispatchAndRestart() throws Exception {
        long delayBeforeDispatch = 5000L;
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)).setDelayBeforeDispatch(Long.valueOf(delayBeforeDispatch)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertEquals((long)delayBeforeDispatch, (long)queueBinding1.getQueue().getDelayBeforeDispatch());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertEquals((long)delayBeforeDispatch, (long)queueBinding1.getQueue().getDelayBeforeDispatch());
    }

    @Test
    public void testQueueConfigUserAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setUser("bob").setMaxConsumers(Integer.valueOf(10)).setPurgeOnNoConsumers(Boolean.valueOf(true)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertEquals((Object)SimpleString.of((String)"bob"), (Object)queueBinding1.getQueue().getUser());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding2.getQueue().isPurgeOnNoConsumers());
    }

    @Test
    public void testQueueConfigEnabledAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setEnabled(Boolean.valueOf(true)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding1.getQueue().isEnabled());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertTrue((boolean)queueBinding2.getQueue().isEnabled());
    }

    @Test
    public void testQueueConfigDisabledAndRestart() throws Exception {
        ActiveMQServer server = this.createServer(true);
        server.start();
        SimpleString address = SimpleString.of((String)"test.address");
        SimpleString queue = SimpleString.of((String)"test.queue");
        server.createQueue(QueueConfiguration.of((SimpleString)queue).setAddress(address).setEnabled(Boolean.valueOf(false)));
        QueueBinding queueBinding1 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertFalse((boolean)queueBinding1.getQueue().isEnabled());
        server.stop();
        server.start();
        QueueBinding queueBinding2 = (QueueBinding)server.getPostOffice().getBinding(queue);
        Assertions.assertFalse((boolean)queueBinding2.getQueue().isEnabled());
    }
}

