/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.persistence;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.UUID;
import javax.naming.Context;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ClientConsumer;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataExporter;
import org.apache.activemq.artemis.cli.commands.tools.xml.XmlDataImporter;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.BatchingIDGenerator;
import org.apache.activemq.artemis.core.persistence.impl.journal.JournalStorageManager;
import org.apache.activemq.artemis.core.persistence.impl.journal.LargeServerMessageImpl;
import org.apache.activemq.artemis.core.registry.JndiBindingRegistry;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.server.JMSServerManager;
import org.apache.activemq.artemis.jms.server.impl.JMSServerManagerImpl;
import org.apache.activemq.artemis.spi.core.naming.BindingRegistry;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.extensions.parameterized.Parameters;
import org.apache.activemq.artemis.tests.unit.util.InVMContext;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.apache.activemq.artemis.tests.util.Wait;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class XmlImportExportTest
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean forceLongs;
    public static final int CONSUMER_TIMEOUT = 5000;
    private static final String QUEUE_NAME = "A1";
    private ServerLocator locator;
    private ActiveMQServer server;
    private JMSServerManager jmsServer;
    private ClientSessionFactory factory;
    private InVMContext namingContext;

    @Parameters(name="forceLongs={0}")
    public static Collection getParameters() {
        return Arrays.asList({true}, {false});
    }

    public XmlImportExportTest(boolean forceLongs) {
        this.forceLongs = forceLongs;
    }

    protected void checkForLongs() {
        if (this.forceLongs) {
            JournalStorageManager manager = (JournalStorageManager)this.server.getStorageManager();
            BatchingIDGenerator idGenerator = (BatchingIDGenerator)manager.getIDGenerator();
            idGenerator.forceNextID(0x80000000L);
        }
    }

    @TestTemplate
    public void testMessageProperties() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        StringBuilder international = new StringBuilder();
        for (char x = '\u0320'; x < '\u04b0'; x = (char)(x + '\u0001')) {
            international.append(x);
        }
        String special = "\"<>'&";
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = session.createMessage(true);
            msg.getBodyBuffer().writeString("Bob the giant pig " + i);
            msg.putBooleanProperty("myBooleanProperty", Boolean.TRUE.booleanValue());
            msg.putByteProperty("myByteProperty", Byte.parseByte("0"));
            msg.putBytesProperty("myBytesProperty", new byte[]{0, 1, 2, 3, 4});
            msg.putDoubleProperty("myDoubleProperty", (double)i * 1.6);
            msg.putFloatProperty("myFloatProperty", (float)i * 2.5f);
            msg.putIntProperty("myIntProperty", i);
            msg.putLongProperty("myLongProperty", Long.MAX_VALUE - (long)i);
            msg.putObjectProperty("myObjectProperty", (Object)i);
            msg.putObjectProperty("myNullObjectProperty", null);
            msg.putShortProperty("myShortProperty", Integer.valueOf(i).shortValue());
            msg.putStringProperty("myStringProperty", "myStringPropertyValue_" + i);
            msg.putStringProperty("myNullStringProperty", null);
            msg.putStringProperty("myNonAsciiStringProperty", international.toString());
            msg.putStringProperty("mySpecialCharacters", special);
            msg.putStringProperty(SimpleString.of((String)"mySimpleStringProperty"), SimpleString.of((String)("mySimpleStringPropertyValue_" + i)));
            msg.putStringProperty(SimpleString.of((String)"myNullSimpleStringProperty"), (SimpleString)null);
            producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        }
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        for (int i = 0; i < 5; ++i) {
            ClientMessage msg = consumer.receive(5000L);
            byte[] body = new byte[msg.getBodySize()];
            msg.getBodyBuffer().readBytes(body);
            Assertions.assertTrue((boolean)new String(body).contains("Bob the giant pig " + i));
            Assertions.assertEquals((Object)msg.getBooleanProperty("myBooleanProperty"), (Object)Boolean.TRUE);
            Assertions.assertEquals((Byte)msg.getByteProperty("myByteProperty"), (Byte)Byte.valueOf("0"));
            byte[] bytes = msg.getBytesProperty("myBytesProperty");
            for (int j = 0; j < 5; ++j) {
                Assertions.assertEquals((int)j, (int)bytes[j]);
            }
            Assertions.assertEquals((double)((double)i * 1.6), (double)msg.getDoubleProperty("myDoubleProperty"), (double)1.0E-6);
            Assertions.assertEquals((double)((float)i * 2.5f), (double)msg.getFloatProperty("myFloatProperty").floatValue(), (double)1.0E-6);
            Assertions.assertEquals((int)i, (int)msg.getIntProperty("myIntProperty"));
            Assertions.assertEquals((long)(Long.MAX_VALUE - (long)i), (long)msg.getLongProperty("myLongProperty"));
            Assertions.assertEquals((Object)i, (Object)msg.getObjectProperty("myObjectProperty"));
            Assertions.assertTrue((boolean)msg.getPropertyNames().contains(SimpleString.of((String)"myNullObjectProperty")));
            Assertions.assertNull((Object)msg.getObjectProperty("myNullObjectProperty"));
            Assertions.assertEquals((short)Integer.valueOf(i).shortValue(), (short)msg.getShortProperty("myShortProperty"));
            Assertions.assertEquals((Object)("myStringPropertyValue_" + i), (Object)msg.getStringProperty("myStringProperty"));
            Assertions.assertTrue((boolean)msg.getPropertyNames().contains(SimpleString.of((String)"myNullStringProperty")));
            Assertions.assertNull((Object)msg.getStringProperty("myNullStringProperty"));
            Assertions.assertEquals((Object)international.toString(), (Object)msg.getStringProperty("myNonAsciiStringProperty"));
            Assertions.assertEquals((Object)special, (Object)msg.getStringProperty("mySpecialCharacters"));
            Assertions.assertEquals((Object)SimpleString.of((String)("mySimpleStringPropertyValue_" + i)), (Object)msg.getSimpleStringProperty(SimpleString.of((String)"mySimpleStringProperty")));
            Assertions.assertTrue((boolean)msg.getPropertyNames().contains(SimpleString.of((String)"myNullSimpleStringProperty")));
            Assertions.assertNull((Object)msg.getSimpleStringProperty("myNullSimpleStringProperty"));
        }
    }

    private ClientSession basicSetUp() throws Exception {
        this.server = this.createServer(true);
        this.server.getConfiguration().getConnectorConfigurations().put("in-vm1", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        this.server.getConfiguration().getConnectorConfigurations().put("in-vm2", new TransportConfiguration(INVM_CONNECTOR_FACTORY));
        this.jmsServer = new JMSServerManagerImpl(this.server);
        this.addActiveMQComponent((ActiveMQComponent)this.jmsServer);
        this.namingContext = new InVMContext();
        this.jmsServer.setRegistry((BindingRegistry)new JndiBindingRegistry((Context)this.namingContext));
        this.jmsServer.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        this.checkForLongs();
        return this.addClientSession(this.factory.createSession(false, true, true));
    }

    @TestTemplate
    public void testMessageTypes() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)4, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)0, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)5, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)2, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)6, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage((byte)3, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        msg = session.createMessage(true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)4, (byte)msg.getType());
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)0, (byte)msg.getType());
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)5, (byte)msg.getType());
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)2, (byte)msg.getType());
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)6, (byte)msg.getType());
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)3, (byte)msg.getType());
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)0, (byte)msg.getType());
    }

    @TestTemplate
    public void testTextMessage() throws Exception {
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < 2608; ++i) {
            data.append("X");
        }
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)3, true);
        msg.getBodyBuffer().writeString(data.toString());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)3, (byte)msg.getType());
        Assertions.assertEquals((Object)data.toString(), (Object)msg.getBodyBuffer().readString());
    }

    @TestTemplate
    public void testBytesMessage() throws Exception {
        StringBuilder data = new StringBuilder();
        for (int i = 0; i < 2610; ++i) {
            data.append("X");
        }
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)4, true);
        msg.getBodyBuffer().writeBytes(data.toString().getBytes());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertEquals((byte)4, (byte)msg.getType());
        byte[] result = new byte[msg.getBodySize()];
        msg.getBodyBuffer().readBytes(result);
        Assertions.assertEquals((int)data.toString().getBytes().length, (int)result.length);
    }

    @TestTemplate
    public void testMessageAttributes() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)4, true);
        msg.setExpiration(Long.MAX_VALUE);
        msg.setPriority((byte)0);
        msg.setTimestamp(0x7FFFFFFFFFFFFFFEL);
        msg.setUserID((Object)UUIDGenerator.getInstance().generateUUID());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertEquals((long)Long.MAX_VALUE, (long)msg.getExpiration());
        Assertions.assertEquals((byte)0, (byte)msg.getPriority());
        Assertions.assertEquals((long)0x7FFFFFFFFFFFFFFEL, (long)msg.getTimestamp());
        Assertions.assertNotNull((Object)msg.getUserID());
    }

    @TestTemplate
    public void testBindingAttributes() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)"queueName1").setAddress("addressName1"));
        session.createQueue(QueueConfiguration.of((String)"queueName2").setAddress("addressName1").setFilterString("bob"));
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientSession.QueueQuery queueQuery = session.queueQuery(SimpleString.of((String)"queueName1"));
        Assertions.assertEquals((Object)"addressName1", (Object)queueQuery.getAddress().toString());
        Assertions.assertNull((Object)queueQuery.getFilterString());
        queueQuery = session.queueQuery(SimpleString.of((String)"queueName2"));
        Assertions.assertEquals((Object)"addressName1", (Object)queueQuery.getAddress().toString());
        Assertions.assertEquals((Object)"bob", (Object)queueQuery.getFilterString().toString());
        Assertions.assertTrue((boolean)queueQuery.isDurable());
    }

    @TestTemplate
    public void testLargeMessage() throws Exception {
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, false);
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)this.server.getStorageManager()));
        fileMessage.setMessageID(1005L);
        fileMessage.setDurable(true);
        for (int i = 0; i < 204800; ++i) {
            fileMessage.addBytes(new byte[]{XmlImportExportTest.getSamplebyte(i)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, 204800L);
        fileMessage.releaseResources(false, true);
        session.createQueue(QueueConfiguration.of((String)"A"));
        ClientProducer prod = session.createProducer("A");
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        session.close();
        session = this.factory.createSession(false, false);
        session.start();
        ClientConsumer cons = session.createConsumer("A");
        ClientMessage msg = cons.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((int)204800, (int)msg.getBodySize());
        for (int i = 0; i < 204800; ++i) {
            Assertions.assertEquals((byte)XmlImportExportTest.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
        }
        msg.acknowledge();
        session.commit();
    }

    @TestTemplate
    public void testLargeMessagesNoTmpFiles() throws Exception {
        String[] flist;
        int i;
        this.server = this.createServer(true);
        this.server.start();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, false);
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)this.server.getStorageManager()));
        fileMessage.setMessageID(1005L);
        fileMessage.setDurable(true);
        for (int i2 = 0; i2 < 204800; ++i2) {
            fileMessage.addBytes(new byte[]{XmlImportExportTest.getSamplebyte(i2)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, 204800L);
        fileMessage.releaseResources(false, true);
        session.createQueue(QueueConfiguration.of((String)"A"));
        ClientProducer prod = session.createProducer("A");
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        prod.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.commit();
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.sort = true;
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        session.close();
        session = this.factory.createSession(false, false);
        session.start();
        ClientConsumer cons = session.createConsumer("A");
        ClientMessage msg = cons.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((int)204800, (int)msg.getBodySize());
        for (i = 0; i < 204800; ++i) {
            Assertions.assertEquals((byte)XmlImportExportTest.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
        }
        msg = cons.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((int)204800, (int)msg.getBodySize());
        for (i = 0; i < 204800; ++i) {
            Assertions.assertEquals((byte)XmlImportExportTest.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
        }
        msg.acknowledge();
        session.commit();
        File workingDir = new File(System.getProperty("user.dir"));
        for (String fn : flist = workingDir.list()) {
            Assertions.assertFalse((boolean)fn.endsWith(".tmp"), (String)("leftover: " + fn));
        }
    }

    @TestTemplate
    public void testLargeJmsTextMessage() throws Exception {
        this.basicSetUp();
        ActiveMQConnectionFactory cf = ActiveMQJMSClient.createConnectionFactory((String)"vm://0", (String)"test");
        Connection c = cf.createConnection();
        Session s = c.createSession(false, 1);
        this.server.createQueue(QueueConfiguration.of((String)"A").setRoutingType(RoutingType.ANYCAST));
        MessageProducer p = s.createProducer((Destination)ActiveMQJMSClient.createQueue((String)"A"));
        p.setDeliveryMode(2);
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < 204800; ++i) {
            stringBuilder.append(RandomUtil.randomChar());
        }
        TextMessage textMessage = s.createTextMessage(stringBuilder.toString());
        textMessage.setStringProperty("_AMQ_DUPL_ID", String.valueOf(UUID.randomUUID()));
        p.send((Message)textMessage);
        c.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        session.close();
        c = cf.createConnection();
        s = c.createSession();
        MessageConsumer mc = s.createConsumer((Destination)ActiveMQJMSClient.createQueue((String)"A"));
        c.start();
        Message msg = mc.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        c.close();
    }

    @TestTemplate
    public void testPartialQueue() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)"myQueue1").setAddress("myAddress"));
        session.createQueue(QueueConfiguration.of((String)"myQueue2").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage msg = session.createMessage(true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        ClientConsumer consumer = session.createConsumer("myQueue1");
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        msg.acknowledge();
        consumer.close();
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        consumer = session.createConsumer("myQueue1");
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertNull((Object)msg);
        consumer.close();
        consumer = session.createConsumer("myQueue2");
        msg = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg);
    }

    @TestTemplate
    public void testPagedMessageWithMissingBinding() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        String MY_QUEUE2 = "myQueue2";
        this.server = this.createServer(true);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((String)"myQueue").setAddress("myAddress"));
        session.createQueue(QueueConfiguration.of((String)"myQueue2").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.deleteQueue("myQueue2");
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer("myQueue");
        session.start();
        for (int i = 0; i < 200; ++i) {
            message = consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
        }
        session.close();
        locator.close();
        this.server.stop();
    }

    @TestTemplate
    public void testPaging() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        this.server = this.createServer(true);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        this.locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        this.factory = this.createSessionFactory(this.locator);
        ClientSession session = this.factory.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((String)"myQueue").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer("myQueue");
        session.start();
        for (int i = 0; i < 200; ++i) {
            message = consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
        }
    }

    @TestTemplate
    public void testPagedLargeMessage() throws Exception {
        String MY_ADDRESS = "myAddress";
        String MY_QUEUE = "myQueue";
        this.server = this.createServer(true);
        AddressSettings defaultSetting = new AddressSettings().setPageSizeBytes(10240).setMaxSizeBytes(20480L).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1);
        this.server.getAddressSettingsRepository().addMatch("#", (Object)defaultSetting);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator().setBlockOnNonDurableSend(true).setBlockOnDurableSend(true).setBlockOnAcknowledge(true);
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((String)"myQueue").setAddress("myAddress"));
        ClientProducer producer = session.createProducer("myAddress");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeBytes(new byte[1024]);
        for (int i = 0; i < 200; ++i) {
            producer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        LargeServerMessageImpl fileMessage = new LargeServerMessageImpl((StorageManager)((JournalStorageManager)this.server.getStorageManager()));
        fileMessage.setMessageID(1005L);
        fileMessage.setDurable(true);
        for (int i = 0; i < 204800; ++i) {
            fileMessage.addBytes(new byte[]{XmlImportExportTest.getSamplebyte(i)});
        }
        fileMessage.putLongProperty(org.apache.activemq.artemis.api.core.Message.HDR_LARGE_BODY_SIZE, 204800L);
        fileMessage.releaseResources(false, true);
        producer.send((org.apache.activemq.artemis.api.core.Message)fileMessage);
        fileMessage.deleteFile();
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session);
        ClientConsumer consumer = session.createConsumer("myQueue");
        session.start();
        for (int i = 0; i < 200; ++i) {
            message = consumer.receive(5000L);
            Assertions.assertNotNull((Object)message);
        }
        ClientMessage msg = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((int)204800, (int)msg.getBodySize());
        for (int i = 0; i < 204800; ++i) {
            Assertions.assertEquals((byte)XmlImportExportTest.getSamplebyte(i), (byte)msg.getBodyBuffer().readByte());
        }
        session.close();
        locator.close();
        this.server.stop();
    }

    @TestTemplate
    public void testTransactional() throws Exception {
        ClientSession session = this.basicSetUp();
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage(true);
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.createSessionFactory(this.locator);
        session = this.factory.createSession(false, false, true);
        ClientSession managementSession = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg);
    }

    @TestTemplate
    public void testBody() throws Exception {
        String QUEUE_NAME = QUEUE_NAME;
        this.server = this.createServer(true);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage((byte)3, true);
        msg.getBodyBuffer().writeString("bob123");
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, false, true);
        ClientSession managementSession = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((Object)"bob123", (Object)msg.getBodyBuffer().readString());
        session.close();
        locator.close();
        this.server.stop();
    }

    @TestTemplate
    public void testBody2() throws Exception {
        String QUEUE_NAME = QUEUE_NAME;
        this.server = this.createServer(true);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, true);
        session.createQueue(QueueConfiguration.of((String)QUEUE_NAME));
        ClientProducer producer = session.createProducer(QUEUE_NAME);
        ClientMessage msg = session.createMessage(true);
        byte[] bodyTst = new byte[10];
        for (int i = 0; i < 10; ++i) {
            bodyTst[i] = (byte)(i + 1);
        }
        msg.getBodyBuffer().writeBytes(bodyTst);
        Assertions.assertEquals((int)bodyTst.length, (int)msg.getBodySize());
        producer.send((org.apache.activemq.artemis.api.core.Message)msg);
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, false, true);
        ClientSession managementSession = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        ClientConsumer consumer = session.createConsumer(QUEUE_NAME);
        session.start();
        msg = consumer.receive(5000L);
        Assertions.assertNotNull((Object)msg);
        Assertions.assertEquals((int)msg.getBodySize(), (int)bodyTst.length);
        byte[] bodyRead = new byte[bodyTst.length];
        msg.getBodyBuffer().readBytes(bodyRead);
        XmlImportExportTest.assertEqualsByteArrays(bodyTst, bodyRead);
        session.close();
        locator.close();
        this.server.stop();
    }

    @TestTemplate
    public void testRoutingTypes() throws Exception {
        SimpleString myAddress = SimpleString.of((String)"myAddress");
        ClientSession session = this.basicSetUp();
        EnumSet<RoutingType> routingTypes = EnumSet.of(RoutingType.ANYCAST, RoutingType.MULTICAST);
        session.createAddress(myAddress, routingTypes, false);
        session.createQueue(QueueConfiguration.of((String)"myQueue1").setAddress(myAddress));
        session.createQueue(QueueConfiguration.of((String)"myQueue2").setAddress(myAddress));
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.locator.createSessionFactory();
        session = this.factory.createSession(false, false, true);
        ClientSession managementSession = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        Assertions.assertTrue((boolean)this.server.getAddressInfo(myAddress).getRoutingTypes().contains(RoutingType.ANYCAST));
        Assertions.assertTrue((boolean)this.server.getAddressInfo(myAddress).getRoutingTypes().contains(RoutingType.MULTICAST));
    }

    @TestTemplate
    public void testEmptyRoutingTypes() throws Exception {
        SimpleString myAddress = SimpleString.of((String)"myAddress");
        ClientSession session = this.basicSetUp();
        EnumSet<RoutingType> routingTypes = EnumSet.noneOf(RoutingType.class);
        session.createAddress(myAddress, routingTypes, false);
        this.locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        this.locator = this.createInVMNonHALocator();
        this.factory = this.locator.createSessionFactory();
        session = this.factory.createSession(false, false, true);
        ClientSession managementSession = this.factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        Assertions.assertEquals((int)0, (int)this.server.getAddressInfo(myAddress).getRoutingTypes().size());
    }

    @TestTemplate
    public void testImportWrongRoutingType() throws Exception {
        SimpleString myAddress = SimpleString.of((String)"myAddress");
        SimpleString myQueue = SimpleString.of((String)"myQueue");
        SimpleString dla = SimpleString.of((String)"DLA");
        SimpleString dlaPrefix = SimpleString.of((String)"DLA.");
        String payload = "myMessagePayload";
        this.server = this.createServer(true);
        this.server.start();
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, true, false);
        this.server.getAddressSettingsRepository().addMatch(myAddress.toString(), (Object)new AddressSettings().setMaxDeliveryAttempts(1).setDeadLetterAddress(dla).setAutoCreateDeadLetterResources(true).setDeadLetterQueuePrefix(dlaPrefix).setMaxReadPageBytes(-1).setMaxReadPageMessages(-1));
        session.createQueue(QueueConfiguration.of((SimpleString)myQueue).setAddress(myAddress).setDurable(Boolean.valueOf(true)).setRoutingType(RoutingType.ANYCAST));
        ClientProducer producer = session.createProducer(myAddress);
        producer.send((org.apache.activemq.artemis.api.core.Message)this.createTextMessage(session, payload).putByteProperty(org.apache.activemq.artemis.api.core.Message.HDR_ROUTING_TYPE, (byte)1));
        session.start();
        ClientConsumer consumer = session.createConsumer(myQueue);
        ClientMessage m = consumer.receive(5000L);
        m.acknowledge();
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)payload);
        Assertions.assertEquals((Object)m.getRoutingType(), (Object)RoutingType.ANYCAST);
        session.rollback();
        m = consumer.receiveImmediate();
        Assertions.assertNull((Object)m);
        consumer.close();
        session.close();
        locator.close();
        this.server.stop();
        ByteArrayOutputStream xmlOutputStream = new ByteArrayOutputStream();
        XmlDataExporter xmlDataExporter = new XmlDataExporter();
        xmlDataExporter.process((OutputStream)xmlOutputStream, this.server.getConfiguration().getBindingsDirectory(), this.server.getConfiguration().getJournalDirectory(), this.server.getConfiguration().getPagingDirectory(), this.server.getConfiguration().getLargeMessagesDirectory());
        if (logger.isDebugEnabled()) {
            logger.debug(new String(xmlOutputStream.toByteArray()));
        }
        this.clearDataRecreateServerDirs();
        this.server.start();
        this.checkForLongs();
        locator = this.createInVMNonHALocator();
        factory = locator.createSessionFactory();
        session = factory.createSession(false, false, true);
        ClientSession managementSession = factory.createSession(false, true, true);
        ByteArrayInputStream xmlInputStream = new ByteArrayInputStream(xmlOutputStream.toByteArray());
        XmlDataImporter xmlDataImporter = new XmlDataImporter();
        xmlDataImporter.validate((InputStream)xmlInputStream);
        xmlInputStream.reset();
        xmlDataImporter.process((InputStream)xmlInputStream, session, managementSession);
        Wait.assertTrue(() -> this.server.getTotalMessageCount() == 1L);
        session.start();
        consumer = session.createConsumer(dlaPrefix.concat(myAddress));
        m = consumer.receive(5000L);
        Assertions.assertNotNull((Object)m);
        Assertions.assertEquals((Object)m.getBodyBuffer().readString(), (Object)payload);
        Assertions.assertEquals((Object)m.getRoutingType(), null);
        consumer.close();
        session.close();
        locator.close();
        this.server.stop();
    }
}

