/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.InvalidPropertyException;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientMessage;
import org.apache.activemq.artemis.api.core.client.ClientProducer;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.impl.LocalQueueBinding;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQMessageHandlerTest
extends ActiveMQRATestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public boolean useSecurity() {
        return false;
    }

    @Test
    public void testSimpleMessageReceivedOnQueue() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testDurableTopicSubscriptionWith1xPrefixesOnSpec() throws Exception {
        this.internalTestDurableTopicSubscriptionWith1xPrefixes(false, true);
    }

    @Test
    public void testDurableTopicSubscriptionWith1xPrefixesOnRA() throws Exception {
        this.internalTestDurableTopicSubscriptionWith1xPrefixes(true, true);
    }

    @Test
    public void testDurableTopicSubscriptionWith1xPrefixesOnSpecWithoutBrokerPrefixes() throws Exception {
        this.internalTestDurableTopicSubscriptionWith1xPrefixes(false, false);
    }

    @Test
    public void testDurableTopicSubscriptionWith1xPrefixesOnRAWithoutBrokerPrefixes() throws Exception {
        this.internalTestDurableTopicSubscriptionWith1xPrefixes(true, false);
    }

    public void internalTestDurableTopicSubscriptionWith1xPrefixes(boolean ra, boolean definePrefixesOnBroker) throws Exception {
        if (definePrefixesOnBroker) {
            this.server.getRemotingService().createAcceptor("test", "tcp://localhost:61617?anycastPrefix=jms.queue.;multicastPrefix=jms.topic.").start();
        }
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        if (ra) {
            qResourceAdapter.setEnable1xPrefixes(Boolean.valueOf(true));
        }
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setSetupAttempts(Integer.valueOf(1));
        spec.setSetupInterval(Long.valueOf(500L));
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("jms.topic.MyTopic");
        if (!ra) {
            spec.setEnable1xPrefixes(Boolean.valueOf(true));
        }
        spec.setSubscriptionDurability("Durable");
        spec.setClientId("myClientId");
        spec.setSubscriptionName("mySubscriptionName");
        qResourceAdapter.setConnectorClassName(NETTY_CONNECTOR_FACTORY);
        String port = "61616";
        if (definePrefixesOnBroker) {
            port = "61617";
        }
        qResourceAdapter.setConnectionParameters("host=localhost;port=" + port);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        Object topic = "MyTopic";
        if (!definePrefixesOnBroker) {
            topic = "jms.topic." + (String)topic;
        }
        ClientProducer clientProducer = session.createProducer((String)topic);
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testObjectMessageReceiveSerializationControl() throws Exception {
        String denyList = "org.apache.activemq.artemis.tests.integration.ra";
        String allowList = "*";
        this.testDeserialization(denyList, allowList, false);
    }

    @Test
    public void testObjectMessageReceiveSerializationControl1() throws Exception {
        String denyList = "some.other.pkg";
        String allowList = "org.apache.activemq.artemis.tests.integration.ra";
        this.testDeserialization(denyList, allowList, true);
    }

    @Test
    public void testObjectMessageReceiveSerializationControl2() throws Exception {
        String denyList = "*";
        String allowList = "org.apache.activemq.artemis.tests.integration.ra";
        this.testDeserialization(denyList, allowList, false);
    }

    @Test
    public void testObjectMessageReceiveSerializationControl3() throws Exception {
        String denyList = "org.apache.activemq.artemis.tests";
        String allowList = "org.apache.activemq.artemis.tests.integration.ra";
        this.testDeserialization(denyList, allowList, false);
    }

    @Test
    public void testObjectMessageReceiveSerializationControl4() throws Exception {
        String denyList = null;
        String allowList = "some.other.pkg";
        this.testDeserialization(denyList, allowList, false);
    }

    @Test
    public void testObjectMessageReceiveSerializationControl5() throws Exception {
        String denyList = null;
        String allowList = null;
        this.testDeserialization(denyList, allowList, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDeserialization(String denyList, String allowList, boolean shouldSucceed) throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        qResourceAdapter.setDeserializationDenyList(denyList);
        qResourceAdapter.setDeserializationAllowList(allowList);
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ActiveMQConnectionFactory jmsFactory = new ActiveMQConnectionFactory("vm://0");
        try (Connection connection = jmsFactory.createConnection();){
            Session session = connection.createSession(false, 1);
            Queue jmsQueue = session.createQueue("mdbQueue");
            ObjectMessage objMsg = session.createObjectMessage();
            objMsg.setObject((Serializable)new DummySerializable());
            MessageProducer producer = session.createProducer((Destination)jmsQueue);
            producer.send((Message)objMsg);
        }
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        ObjectMessage objMsg = (ObjectMessage)endpoint.lastMessage;
        try {
            Serializable obj = objMsg.getObject();
            Assertions.assertTrue((boolean)shouldSucceed, (String)("deserialization should fail but got: " + obj));
            Assertions.assertTrue((boolean)(obj instanceof DummySerializable));
        }
        catch (JMSException e) {
            Assertions.assertFalse((boolean)shouldSucceed, (String)("got unexpected exception: " + e));
        }
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testSimpleMessageReceivedOnQueueManyMessages() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(15);
        MultipleEndpoints endpoint = new MultipleEndpoints(latch, null, false);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        for (int i = 0; i < 15; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeString("teststring" + i);
            clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testSimpleMessageReceivedOnQueueManyMessagesAndInterrupt() throws Exception {
        int SIZE = 14;
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(14);
        CountDownLatch latchDone = new CountDownLatch(14);
        MultipleEndpoints endpoint = new MultipleEndpoints(latch, latchDone, true);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        for (int i = 0; i < 14; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeString("teststring" + i);
            clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        latchDone.await(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)14, (int)endpoint.messages.intValue());
        Assertions.assertEquals((int)0, (int)endpoint.interrupted.intValue());
        qResourceAdapter.stop();
    }

    @Test
    public void testSimpleMessageReceivedOnQueueManyMessagesAndInterruptTimeout() throws Exception {
        int SIZE = 14;
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setCallTimeout(Long.valueOf(500L));
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(14);
        CountDownLatch latchDone = new CountDownLatch(14);
        MultipleEndpoints endpoint = new MultipleEndpoints(latch, latchDone, true);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        for (int i = 0; i < 14; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeString("teststring" + i);
            clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.close();
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        latchDone.await(5L, TimeUnit.SECONDS);
        Assertions.assertEquals((int)14, (int)endpoint.messages.intValue());
        Assertions.assertEquals((int)7, (int)endpoint.interrupted.intValue());
        qResourceAdapter.stop();
    }

    @Override
    protected ActiveMQResourceAdapter newResourceAdapter() {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        return qResourceAdapter;
    }

    @Test
    public void testServerShutdownAndReconnect() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        qResourceAdapter.setReconnectAttempts(Integer.valueOf(-1));
        qResourceAdapter.setCallTimeout(Long.valueOf(500L));
        qResourceAdapter.setRetryInterval(Long.valueOf(500L));
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        final CountDownLatch failedLatch = new CountDownLatch(1);
        ClientSessionFactoryInternal factoryListener = (ClientSessionFactoryInternal)qResourceAdapter.getDefaultActiveMQConnectionFactory().getServerLocator().createSessionFactory();
        factoryListener.addFailureListener(new SessionFailureListener(){

            public void connectionFailed(ActiveMQException exception, boolean failedOver) {
            }

            public void connectionFailed(ActiveMQException exception, boolean failedOver, String scaleDownTargetNodeID) {
                this.connectionFailed(exception, failedOver);
            }

            public void beforeReconnect(ActiveMQException exception) {
                failedLatch.countDown();
            }
        });
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        this.server.stop();
        Assertions.assertTrue((boolean)failedLatch.await(5L, TimeUnit.SECONDS));
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testInvalidAckMode() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        try {
            spec.setAcknowledgeMode("CLIENT_ACKNOWLEDGE");
            Assertions.fail((String)"should throw exception");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        qResourceAdapter.stop();
    }

    @Test
    public void testSimpleMessageReceivedOnQueueInLocalTX() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        qResourceAdapter.setUseLocalTx(Boolean.valueOf(true));
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ExceptionDummyMessageEndpoint endpoint = new ExceptionDummyMessageEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("teststring");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNull((Object)endpoint.lastMessage);
        latch = new CountDownLatch(1);
        endpoint.reset(latch);
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"teststring");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testSimpleMessageReceivedOnQueueWithSelector() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setMessageSelector("color='red'");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbQueue");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("blue");
        message.putStringProperty("color", "blue");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("red");
        message.putStringProperty("color", "red");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        session.close();
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"red");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testEndpointDeactivated() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Binding binding = this.server.getPostOffice().getBinding(MDBQUEUEPREFIXEDSIMPLE);
        Assertions.assertEquals((int)((LocalQueueBinding)binding).getQueue().getConsumerCount(), (int)15);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((int)((LocalQueueBinding)binding).getQueue().getConsumerCount(), (int)0);
        Assertions.assertTrue((boolean)endpoint.released);
        qResourceAdapter.stop();
    }

    @Test
    public void testMaxSessions() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setMaxSession(Integer.valueOf(1));
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Binding binding = this.server.getPostOffice().getBinding(MDBQUEUEPREFIXEDSIMPLE);
        Assertions.assertEquals((int)((LocalQueueBinding)binding).getQueue().getConsumerCount(), (int)1);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testSimpleTopic() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("test");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"test");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testDurableSubscription() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        spec.setSubscriptionDurability("Durable");
        spec.setSubscriptionName("durable-mdb");
        spec.setClientID("id-1");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("1");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"1");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("2");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch = new CountDownLatch(1);
        endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"2");
        latch = new CountDownLatch(1);
        endpoint.reset(latch);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("3");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"3");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testNonDurableSubscription() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("1");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"1");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("2");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch = new CountDownLatch(1);
        endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("3");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"3");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testNonDurableSubscriptionDeleteAfterCrash() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("1");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"1");
        ActiveMQActivation activation = this.lookupActivation(qResourceAdapter);
        SimpleString tempQueueName = activation.getTopicTemporaryQueue();
        ClientSession.QueueQuery query = session.queueQuery(tempQueueName);
        Assertions.assertTrue((boolean)query.isExists());
        qResourceAdapter.getDefaultActiveMQConnectionFactory().close();
        qResourceAdapter.stop();
        query = session.queueQuery(tempQueueName);
        Assertions.assertFalse((boolean)query.isExists());
    }

    @Test
    public void testSelectorChangedWithTopic() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        spec.setSubscriptionDurability("Durable");
        spec.setSubscriptionName("durable-mdb");
        spec.setClientID("id-1");
        spec.setMessageSelector("foo='bar'");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("1");
        message.putStringProperty("foo", "bar");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"1");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("2");
        message.putStringProperty("foo", "bar");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch = new CountDownLatch(1);
        endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        spec.setMessageSelector("foo='abar'");
        endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("3");
        message.putStringProperty("foo", "abar");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"3");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    @Test
    public void testSharedSubscription() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        spec.setSubscriptionDurability("Durable");
        spec.setSubscriptionName("durable-mdb");
        spec.setClientID("id-1");
        spec.setSetupAttempts(Integer.valueOf(1));
        spec.setShareSubscriptions(Boolean.valueOf(true));
        spec.setMaxSession(Integer.valueOf(1));
        ActiveMQActivationSpec spec2 = new ActiveMQActivationSpec();
        spec2.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec2.setUseJNDI(Boolean.valueOf(false));
        spec2.setDestinationType("jakarta.jms.Topic");
        spec2.setDestination("mdbTopic");
        spec2.setSubscriptionDurability("Durable");
        spec2.setSubscriptionName("durable-mdb");
        spec2.setClientID("id-1");
        spec2.setSetupAttempts(Integer.valueOf(1));
        spec2.setShareSubscriptions(Boolean.valueOf(true));
        spec2.setMaxSession(Integer.valueOf(1));
        CountDownLatch latch = new CountDownLatch(5);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        CountDownLatch latch2 = new CountDownLatch(5);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint2 = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch2);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory2 = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint2, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory2, (ActivationSpec)spec2);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        for (int i = 0; i < 10; ++i) {
            ClientMessage message = session.createMessage(true);
            message.getBodyBuffer().writeString("" + i);
            clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        }
        session.commit();
        Assertions.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        Assertions.assertTrue((boolean)latch2.await(5L, TimeUnit.SECONDS));
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertNotNull((Object)endpoint2.lastMessage);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory2, (ActivationSpec)spec2);
        qResourceAdapter.stop();
    }

    @Test
    public void testNullSubscriptionName() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestination("mdbTopic");
        spec.setSubscriptionDurability("Durable");
        spec.setClientID("id-1");
        spec.setSetupAttempts(Integer.valueOf(1));
        spec.setShareSubscriptions(Boolean.valueOf(true));
        spec.setMaxSession(Integer.valueOf(1));
        CountDownLatch latch = new CountDownLatch(5);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        try {
            qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof InvalidPropertyException));
            Assertions.assertEquals((Object)"subscriptionName", (Object)((InvalidPropertyException)e).getInvalidPropertyDescriptors()[0].getName());
        }
    }

    @Test
    public void testBadDestinationType() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("badDestinationType");
        spec.setDestination("mdbTopic");
        spec.setSetupAttempts(Integer.valueOf(1));
        spec.setShareSubscriptions(Boolean.valueOf(true));
        spec.setMaxSession(Integer.valueOf(1));
        CountDownLatch latch = new CountDownLatch(5);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        try {
            qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
            Assertions.fail();
        }
        catch (Exception e) {
            Assertions.assertTrue((boolean)(e instanceof InvalidPropertyException));
            Assertions.assertEquals((Object)"destinationType", (Object)((InvalidPropertyException)e).getInvalidPropertyDescriptors()[0].getName());
        }
    }

    @Test
    public void testSelectorNotChangedWithTopic() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = this.newResourceAdapter();
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext(this);
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("mdbTopic");
        spec.setSubscriptionDurability("Durable");
        spec.setSubscriptionName("durable-mdb");
        spec.setClientID("id-1");
        spec.setMessageSelector("foo='bar'");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        ClientSession session = this.locator.createSessionFactory().createSession();
        ClientProducer clientProducer = session.createProducer("mdbTopic");
        ClientMessage message = session.createMessage(true);
        message.getBodyBuffer().writeString("1");
        message.putStringProperty("foo", "bar");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"1");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        message = session.createMessage(true);
        message.getBodyBuffer().writeString("2");
        message.putStringProperty("foo", "bar");
        clientProducer.send((org.apache.activemq.artemis.api.core.Message)message);
        latch = new CountDownLatch(1);
        endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(this, latch);
        endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(this, endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        latch.await(5L, TimeUnit.SECONDS);
        Assertions.assertNotNull((Object)endpoint.lastMessage);
        Assertions.assertEquals((Object)endpoint.lastMessage.getCoreMessage().getBodyBuffer().readString(), (Object)"2");
        qResourceAdapter.endpointDeactivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
    }

    static class DummySerializable
    implements Serializable {
        DummySerializable() {
        }
    }

    class MultipleEndpoints
    extends ActiveMQRATestBase.DummyMessageEndpoint {
        private final CountDownLatch latch;
        private final CountDownLatch latchDone;
        private final boolean pause;
        AtomicInteger messages;
        AtomicInteger interrupted;

        MultipleEndpoints(CountDownLatch latch, CountDownLatch latchDone, boolean pause) {
            super(ActiveMQMessageHandlerTest.this, latch);
            this.messages = new AtomicInteger(0);
            this.interrupted = new AtomicInteger(0);
            this.latch = latch;
            this.latchDone = latchDone;
            this.pause = pause;
        }

        @Override
        public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        }

        @Override
        public void afterDelivery() throws ResourceException {
        }

        @Override
        public void release() {
        }

        @Override
        public void onMessage(Message message) {
            try {
                this.latch.countDown();
                if (this.pause && this.messages.getAndIncrement() % 2 == 0) {
                    try {
                        logger.debug("pausing for 2 secs");
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException e) {
                        this.interrupted.incrementAndGet();
                    }
                }
            }
            finally {
                if (this.latchDone != null) {
                    this.latchDone.countDown();
                }
            }
        }
    }

    class ExceptionDummyMessageEndpoint
    extends ActiveMQRATestBase.DummyMessageEndpoint {
        boolean throwException;

        ExceptionDummyMessageEndpoint(CountDownLatch latch) {
            super(ActiveMQMessageHandlerTest.this, latch);
            this.throwException = true;
        }

        @Override
        public void onMessage(Message message) {
            if (this.throwException) {
                this.throwException = false;
                throw new IllegalStateException("boo!");
            }
            super.onMessage(message);
        }
    }
}

