/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.ra;

import jakarta.jms.Connection;
import jakarta.resource.ResourceException;
import jakarta.resource.spi.ActivationSpec;
import jakarta.resource.spi.BootstrapContext;
import jakarta.resource.spi.ResourceAdapter;
import jakarta.resource.spi.endpoint.MessageEndpoint;
import jakarta.resource.spi.endpoint.MessageEndpointFactory;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.UDPBroadcastEndpointFactory;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.management.AddressControl;
import org.apache.activemq.artemis.api.jms.ActiveMQJMSClient;
import org.apache.activemq.artemis.core.client.impl.ServerLocatorImpl;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.jms.client.ActiveMQConnectionFactory;
import org.apache.activemq.artemis.jms.client.ActiveMQDestination;
import org.apache.activemq.artemis.ra.ActiveMQResourceAdapter;
import org.apache.activemq.artemis.ra.ConnectionFactoryProperties;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivation;
import org.apache.activemq.artemis.ra.inflow.ActiveMQActivationSpec;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.apache.activemq.artemis.tests.integration.ra.ActiveMQRATestBase;
import org.apache.activemq.artemis.utils.DefaultSensitiveStringCodec;
import org.apache.activemq.artemis.utils.PasswordMaskingUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResourceAdapterTest
extends ActiveMQRATestBase {
    @Test
    public void testStartStopActivationManyTimes() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, false, false);
        ActiveMQDestination queue = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)"test");
        session.createQueue(QueueConfiguration.of((SimpleString)queue.getSimpleAddress()));
        session.close();
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ra.setUserName("userGlobal");
        ra.setPassword("passwordGlobal");
        ra.start((BootstrapContext)new org.apache.activemq.artemis.tests.unit.ra.BootstrapContext());
        Connection conn = ra.getDefaultActiveMQConnectionFactory().createConnection();
        conn.close();
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)ra);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setUser("user");
        spec.setPassword("password");
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("test");
        spec.setMinSession(Integer.valueOf(1));
        spec.setMaxSession(Integer.valueOf(15));
        ActiveMQActivation activation = new ActiveMQActivation(ra, (MessageEndpointFactory)new org.apache.activemq.artemis.tests.unit.ra.MessageEndpointFactory(), spec);
        ServerLocatorImpl serverLocator = (ServerLocatorImpl)ra.getDefaultActiveMQConnectionFactory().getServerLocator();
        Set resources = ra.getRecoveryManager().getResources();
        for (int i = 0; i < 10; ++i) {
            activation.start();
            Assertions.assertEquals((int)1, (int)resources.size());
            activation.stop();
        }
        ra.stop();
        Assertions.assertEquals((int)0, (int)resources.size());
        locator.close();
    }

    @Test
    public void testQueuePrefixWhenUseJndiIsFalse() throws Exception {
        String prefix = "jms.queue.";
        String destinationName = "test";
        SimpleString prefixedDestinationName = SimpleString.of((String)"jms.queue.test");
        this.server.createQueue(QueueConfiguration.of((SimpleString)prefixedDestinationName).setRoutingType(RoutingType.ANYCAST).setDurable(Boolean.valueOf(false)));
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ra.start((BootstrapContext)new org.apache.activemq.artemis.tests.unit.ra.BootstrapContext());
        Connection conn = ra.getDefaultActiveMQConnectionFactory().createConnection();
        conn.close();
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)ra);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("test");
        spec.setQueuePrefix("jms.queue.");
        spec.setMaxSession(Integer.valueOf(1));
        spec.setSetupAttempts(Integer.valueOf(1));
        ActiveMQActivation activation = new ActiveMQActivation(ra, (MessageEndpointFactory)new org.apache.activemq.artemis.tests.unit.ra.MessageEndpointFactory(), spec);
        activation.start();
        Assertions.assertEquals((int)1, (int)this.server.locateQueue(prefixedDestinationName).getConsumerCount());
        activation.stop();
    }

    @Test
    public void testAutoCreateQueuePrefixWhenUseJndiIsFalse() throws Exception {
        String prefix = "jms.queue.";
        String destinationName = "autocreatedtest";
        SimpleString prefixedDestinationName = SimpleString.of((String)"jms.queue.autocreatedtest");
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ra.start((BootstrapContext)new org.apache.activemq.artemis.tests.unit.ra.BootstrapContext());
        Connection conn = ra.getDefaultActiveMQConnectionFactory().createConnection();
        conn.close();
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)ra);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("autocreatedtest");
        spec.setQueuePrefix("jms.queue.");
        spec.setMaxSession(Integer.valueOf(1));
        spec.setSetupAttempts(Integer.valueOf(1));
        ActiveMQActivation activation = new ActiveMQActivation(ra, (MessageEndpointFactory)new org.apache.activemq.artemis.tests.unit.ra.MessageEndpointFactory(), spec);
        activation.start();
        Assertions.assertEquals((int)1, (int)this.server.locateQueue(prefixedDestinationName).getConsumerCount());
        activation.stop();
    }

    @Test
    public void testTopicPrefixWhenUseJndiIsFalse() throws Exception {
        String prefix = "jms.topic.";
        String destinationName = "test";
        SimpleString prefixedDestinationName = SimpleString.of((String)"jms.topic.test");
        this.server.addAddressInfo(new AddressInfo(prefixedDestinationName).addRoutingType(RoutingType.MULTICAST));
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ra.start((BootstrapContext)new org.apache.activemq.artemis.tests.unit.ra.BootstrapContext());
        Connection conn = ra.getDefaultActiveMQConnectionFactory().createConnection();
        conn.close();
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)ra);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Topic");
        spec.setDestination("test");
        spec.setTopicPrefix("jms.topic.");
        spec.setMaxSession(Integer.valueOf(1));
        spec.setSetupAttempts(Integer.valueOf(1));
        ActiveMQActivation activation = new ActiveMQActivation(ra, (MessageEndpointFactory)new org.apache.activemq.artemis.tests.unit.ra.MessageEndpointFactory(), spec);
        activation.start();
        Assertions.assertEquals((int)1, (int)((AddressControl)this.server.getManagementService().getResource("address." + prefixedDestinationName)).getQueueNames().length);
        activation.stop();
    }

    @Test
    public void testAutoCreatedQueueNotFiltered() throws Exception {
        String destinationName = "test";
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ra.start((BootstrapContext)new org.apache.activemq.artemis.tests.unit.ra.BootstrapContext());
        Connection conn = ra.getDefaultActiveMQConnectionFactory().createConnection();
        conn.close();
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)ra);
        spec.setJndiParams("java.naming.factory.initial=org.apache.activemq.artemis.jndi.ActiveMQInitialContextFactory;");
        spec.setMessageSelector("HeaderField = 'foo'");
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestinationLookup("test");
        ActiveMQActivation activation = new ActiveMQActivation(ra, (MessageEndpointFactory)new org.apache.activemq.artemis.tests.unit.ra.MessageEndpointFactory(), spec);
        activation.start();
        Queue queue = this.server.locateQueue("test");
        Assertions.assertNotNull((Object)queue);
        Assertions.assertNull((Object)queue.getFilter());
        activation.stop();
    }

    @Test
    public void testStartStop() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)endpoint.released);
    }

    @Test
    public void testSetters() throws Exception {
        Boolean b = Boolean.TRUE;
        Long l = 1000L;
        Integer i = 1000;
        Double d = 1000.0;
        String className = "testConnector";
        String backupConn = "testBackupConnector";
        String testConfig = "key=val";
        String testid = "testid";
        String testBalancer = "testBalancer";
        String testParams = "key=val";
        String testaddress = "testaddress";
        String testpass = "testpass";
        String testuser = "testuser";
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        this.testParams(b, l, i, d, className, backupConn, testConfig, testid, testBalancer, testParams, testaddress, testpass, testuser, qResourceAdapter);
    }

    @Test
    public void testSetters2() throws Exception {
        Boolean b = Boolean.FALSE;
        Long l = 2000L;
        Integer i = 2000;
        Double d = 2000.0;
        String className = "testConnector2";
        String backupConn = "testBackupConnector2";
        String testConfig = "key2=val2";
        String testid = "testid2";
        String testBalancer = "testBalancer2";
        String testParams = "key=val2";
        String testaddress = "testaddress2";
        String testpass = "testpass2";
        String testuser = "testuser2";
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        this.testParams(b, l, i, d, className, backupConn, testConfig, testid, testBalancer, testParams, testaddress, testpass, testuser, qResourceAdapter);
    }

    private void testParams(Boolean b, Long aLong, Integer i, Double d, String className, String backupConn, String testConfig, String testid, String testBalancer, String testParams, String testaddress, String testpass, String testuser, ActiveMQResourceAdapter qResourceAdapter) {
        qResourceAdapter.setUseLocalTx(b);
        qResourceAdapter.setConnectorClassName(className);
        qResourceAdapter.setAutoGroup(b);
        qResourceAdapter.setBlockOnAcknowledge(b);
        qResourceAdapter.setBlockOnDurableSend(b);
        qResourceAdapter.setBlockOnNonDurableSend(b);
        qResourceAdapter.setCallTimeout(aLong);
        qResourceAdapter.setClientFailureCheckPeriod(aLong);
        qResourceAdapter.setClientID(testid);
        qResourceAdapter.setConfirmationWindowSize(i);
        qResourceAdapter.setConnectionLoadBalancingPolicyClassName(testBalancer);
        qResourceAdapter.setConnectionParameters(testParams);
        qResourceAdapter.setConnectionTTL(aLong);
        qResourceAdapter.setConsumerMaxRate(i);
        qResourceAdapter.setConsumerWindowSize(i);
        qResourceAdapter.setDiscoveryAddress(testaddress);
        qResourceAdapter.setDiscoveryInitialWaitTimeout(aLong);
        qResourceAdapter.setDiscoveryPort(i);
        qResourceAdapter.setDiscoveryRefreshTimeout(aLong);
        qResourceAdapter.setDupsOKBatchSize(i);
        qResourceAdapter.setMinLargeMessageSize(i);
        qResourceAdapter.setPassword(testpass);
        qResourceAdapter.setPreAcknowledge(b);
        qResourceAdapter.setProducerMaxRate(i);
        qResourceAdapter.setReconnectAttempts(i);
        qResourceAdapter.setRetryInterval(aLong);
        qResourceAdapter.setRetryIntervalMultiplier(d);
        qResourceAdapter.setScheduledThreadPoolMaxSize(i);
        qResourceAdapter.setThreadPoolMaxSize(i);
        qResourceAdapter.setTransactionBatchSize(i);
        qResourceAdapter.setUseGlobalPools(b);
        qResourceAdapter.setUseLocalTx(b);
        qResourceAdapter.setUserName(testuser);
        Assertions.assertEquals((Object)qResourceAdapter.getUseLocalTx(), (Object)b);
        Assertions.assertEquals((Object)qResourceAdapter.getConnectorClassName(), (Object)className);
        Assertions.assertEquals((Object)qResourceAdapter.getAutoGroup(), (Object)b);
        Assertions.assertEquals((Object)qResourceAdapter.getBlockOnAcknowledge(), (Object)b);
        Assertions.assertEquals((Object)qResourceAdapter.getBlockOnDurableSend(), (Object)b);
        Assertions.assertEquals((Object)qResourceAdapter.getBlockOnNonDurableSend(), (Object)b);
        Assertions.assertEquals((Long)qResourceAdapter.getCallTimeout(), (Long)aLong);
        Assertions.assertEquals((Long)qResourceAdapter.getClientFailureCheckPeriod(), (Long)aLong);
        Assertions.assertEquals((Object)qResourceAdapter.getClientID(), (Object)testid);
        Assertions.assertEquals((Integer)qResourceAdapter.getConfirmationWindowSize(), (Integer)i);
        Assertions.assertEquals((Object)qResourceAdapter.getConnectionLoadBalancingPolicyClassName(), (Object)testBalancer);
        Assertions.assertEquals((Object)qResourceAdapter.getConnectionParameters(), (Object)testParams);
        Assertions.assertEquals((Long)qResourceAdapter.getConnectionTTL(), (Long)aLong);
        Assertions.assertEquals((Integer)qResourceAdapter.getConsumerMaxRate(), (Integer)i);
        Assertions.assertEquals((Integer)qResourceAdapter.getConsumerWindowSize(), (Integer)i);
        Assertions.assertEquals((Object)qResourceAdapter.getDiscoveryAddress(), (Object)testaddress);
        Assertions.assertEquals((Long)qResourceAdapter.getDiscoveryInitialWaitTimeout(), (Long)aLong);
        Assertions.assertEquals((Integer)qResourceAdapter.getDiscoveryPort(), (Integer)i);
        Assertions.assertEquals((Long)qResourceAdapter.getDiscoveryRefreshTimeout(), (Long)aLong);
        Assertions.assertEquals((Integer)qResourceAdapter.getDupsOKBatchSize(), (Integer)i);
        Assertions.assertEquals((Integer)qResourceAdapter.getMinLargeMessageSize(), (Integer)i);
        Assertions.assertEquals((Object)qResourceAdapter.getPassword(), (Object)testpass);
        Assertions.assertEquals((Object)qResourceAdapter.getPreAcknowledge(), (Object)b);
        Assertions.assertEquals((Integer)qResourceAdapter.getProducerMaxRate(), (Integer)i);
        Assertions.assertEquals((Integer)qResourceAdapter.getReconnectAttempts(), (Integer)i);
        Assertions.assertEquals((Long)qResourceAdapter.getRetryInterval(), (Long)aLong);
        Assertions.assertEquals((Double)qResourceAdapter.getRetryIntervalMultiplier(), (Double)d);
        Assertions.assertEquals((Integer)qResourceAdapter.getScheduledThreadPoolMaxSize(), (Integer)i);
        Assertions.assertEquals((Integer)qResourceAdapter.getThreadPoolMaxSize(), (Integer)i);
        Assertions.assertEquals((Integer)qResourceAdapter.getTransactionBatchSize(), (Integer)i);
        Assertions.assertEquals((Object)qResourceAdapter.getUseGlobalPools(), (Object)b);
        Assertions.assertEquals((Object)qResourceAdapter.getUseLocalTx(), (Object)b);
        Assertions.assertEquals((Object)qResourceAdapter.getUserName(), (Object)testuser);
    }

    @Test
    public void testResourceAdapterSetup() throws Exception {
        ActiveMQResourceAdapter adapter = new ActiveMQResourceAdapter();
        adapter.setDiscoveryAddress("231.1.1.1");
        ActiveMQConnectionFactory factory = adapter.getDefaultActiveMQConnectionFactory();
        long initWait = factory.getDiscoveryGroupConfiguration().getDiscoveryInitialWaitTimeout();
        long refresh = factory.getDiscoveryGroupConfiguration().getRefreshTimeout();
        int port = ((UDPBroadcastEndpointFactory)factory.getDiscoveryGroupConfiguration().getBroadcastEndpointFactory()).getGroupPort();
        Assertions.assertEquals((long)10000L, (long)refresh);
        Assertions.assertEquals((long)10000L, (long)initWait);
        Assertions.assertEquals((int)9876, (int)port);
        adapter = new ActiveMQResourceAdapter();
        adapter.setDiscoveryAddress("231.1.1.1");
        adapter.setDiscoveryPort(Integer.valueOf(9876));
        adapter.setDiscoveryRefreshTimeout(Long.valueOf(1234L));
        factory = adapter.getDefaultActiveMQConnectionFactory();
        initWait = factory.getDiscoveryGroupConfiguration().getDiscoveryInitialWaitTimeout();
        refresh = factory.getDiscoveryGroupConfiguration().getRefreshTimeout();
        Assertions.assertEquals((long)1234L, (long)refresh);
        Assertions.assertEquals((long)10000L, (long)initWait);
        adapter = new ActiveMQResourceAdapter();
        adapter.setDiscoveryAddress("231.1.1.1");
        adapter.setDiscoveryPort(Integer.valueOf(9876));
        adapter.setDiscoveryInitialWaitTimeout(Long.valueOf(9999L));
        factory = adapter.getDefaultActiveMQConnectionFactory();
        initWait = factory.getDiscoveryGroupConfiguration().getDiscoveryInitialWaitTimeout();
        refresh = factory.getDiscoveryGroupConfiguration().getRefreshTimeout();
        Assertions.assertEquals((long)10000L, (long)refresh);
        Assertions.assertEquals((long)9999L, (long)initWait);
        adapter = new ActiveMQResourceAdapter();
        adapter.setDiscoveryAddress("231.1.1.1");
        adapter.setDiscoveryPort(Integer.valueOf(9876));
        adapter.setDiscoveryInitialWaitTimeout(Long.valueOf(9999L));
        factory = adapter.getDefaultActiveMQConnectionFactory();
        initWait = factory.getDiscoveryGroupConfiguration().getDiscoveryInitialWaitTimeout();
        refresh = factory.getDiscoveryGroupConfiguration().getRefreshTimeout();
        Assertions.assertEquals((long)10000L, (long)refresh);
        Assertions.assertEquals((long)9999L, (long)initWait);
    }

    @Test
    public void testResourceAdapterSetupOverrideCFParams() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setConnectorClassName(NETTY_CONNECTOR_FACTORY);
        spec.setConnectionParameters("port=61616");
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(new CountDownLatch(1));
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((int)2, (int)qResourceAdapter.getRecoveryManager().getResources().size());
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)endpoint.released);
    }

    @Test
    public void testRecoveryRegistrationOnFailure() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setConnectorClassName(NETTY_CONNECTOR_FACTORY);
        spec.setSetupAttempts(Integer.valueOf(2));
        spec.setConnectionParameters("port=6776");
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(new CountDownLatch(1));
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((int)1, (int)qResourceAdapter.getRecoveryManager().getResources().size());
        qResourceAdapter.stop();
        Assertions.assertFalse((boolean)endpoint.released);
    }

    @Test
    public void testResourceAdapterSetupOverrideNoCFParams() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        qResourceAdapter.stop();
        Assertions.assertFalse((boolean)spec.isHasBeenUpdated());
        Assertions.assertTrue((boolean)endpoint.released);
    }

    @Test
    public void testResourceAdapterSetupNoOverrideDiscovery() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setDiscoveryAddress("231.6.6.6");
        qResourceAdapter.setDiscoveryPort(Integer.valueOf(1234));
        qResourceAdapter.setDiscoveryRefreshTimeout(Long.valueOf(1L));
        qResourceAdapter.setDiscoveryInitialWaitTimeout(Long.valueOf(1L));
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        DiscoveryGroupConfiguration dc = fac.getServerLocator().getDiscoveryGroupConfiguration();
        UDPBroadcastEndpointFactory udpDg = (UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory();
        Assertions.assertEquals((Object)udpDg.getGroupAddress(), (Object)"231.6.6.6");
        Assertions.assertEquals((int)udpDg.getGroupPort(), (int)1234);
        Assertions.assertEquals((long)dc.getRefreshTimeout(), (long)1L);
        Assertions.assertEquals((long)dc.getDiscoveryInitialWaitTimeout(), (long)1L);
        qResourceAdapter.stop();
    }

    @Test
    public void testResourceAdapterSetupOverrideDiscovery() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setDiscoveryAddress("231.7.7.7");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setSetupAttempts(Integer.valueOf(0));
        spec.setDiscoveryAddress("231.6.6.6");
        spec.setDiscoveryPort(Integer.valueOf(1234));
        spec.setDiscoveryInitialWaitTimeout(Long.valueOf(1L));
        spec.setDiscoveryRefreshTimeout(Long.valueOf(1L));
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        DiscoveryGroupConfiguration dc = fac.getServerLocator().getDiscoveryGroupConfiguration();
        UDPBroadcastEndpointFactory udpDg = (UDPBroadcastEndpointFactory)dc.getBroadcastEndpointFactory();
        Assertions.assertEquals((Object)udpDg.getGroupAddress(), (Object)"231.6.6.6");
        Assertions.assertEquals((int)udpDg.getGroupPort(), (int)1234);
        Assertions.assertEquals((long)dc.getRefreshTimeout(), (long)1L);
        Assertions.assertEquals((long)dc.getDiscoveryInitialWaitTimeout(), (long)1L);
        qResourceAdapter.stop();
    }

    @Test
    public void testResourceAdapterSetupNoHAOverride() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        qResourceAdapter.setHA(Boolean.valueOf(true));
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        Assertions.assertTrue((boolean)fac.isHA());
        qResourceAdapter.stop();
        Assertions.assertFalse((boolean)spec.isHasBeenUpdated());
    }

    @Test
    public void testResourceAdapterSetupNoHADefault() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        Assertions.assertFalse((boolean)fac.isHA());
        qResourceAdapter.stop();
        Assertions.assertFalse((boolean)spec.isHasBeenUpdated());
    }

    @Test
    public void testResourceAdapterSetupHAOverride() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setHA(Boolean.valueOf(true));
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        Assertions.assertTrue((boolean)fac.isHA());
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)spec.isHasBeenUpdated());
    }

    @Test
    public void testResourceAdapterSetupNoReconnectAttemptsOverride() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        qResourceAdapter.setReconnectAttempts(Integer.valueOf(100));
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        Assertions.assertEquals((int)100, (int)fac.getReconnectAttempts());
        qResourceAdapter.stop();
        Assertions.assertFalse((boolean)spec.isHasBeenUpdated());
    }

    @Test
    public void testResourceAdapterSetupReconnectAttemptDefault() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        Assertions.assertEquals((int)-1, (int)fac.getReconnectAttempts());
        qResourceAdapter.stop();
        Assertions.assertFalse((boolean)spec.isHasBeenUpdated());
    }

    @Test
    public void testResourceAdapterSetupReconnectAttemptsOverride() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        qResourceAdapter.setConnectionParameters("server-id=0");
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.start((BootstrapContext)ctx);
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        spec.setReconnectAttempts(Integer.valueOf(100));
        ActiveMQConnectionFactory fac = qResourceAdapter.getConnectionFactory((ConnectionFactoryProperties)spec);
        Assertions.assertEquals((int)100, (int)fac.getReconnectAttempts());
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)spec.isHasBeenUpdated());
    }

    @Test
    public void testMaskPassword() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        String mask = codec.encode((Object)"helloworld");
        qResourceAdapter.setUseMaskedPassword(Boolean.valueOf(true));
        qResourceAdapter.setPassword(mask);
        qResourceAdapter.start((BootstrapContext)ctx);
        Assertions.assertEquals((Object)"helloworld", (Object)qResourceAdapter.getPassword());
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        mask = codec.encode((Object)"mdbpassword");
        spec.setPassword(mask);
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((Object)"mdbpassword", (Object)spec.getPassword());
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)endpoint.released);
    }

    @Test
    public void testMaskPasswordENC() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        String mask = codec.encode((Object)"helloworld");
        qResourceAdapter.setPassword(PasswordMaskingUtil.wrap((String)mask));
        qResourceAdapter.start((BootstrapContext)ctx);
        Assertions.assertEquals((Object)"helloworld", (Object)qResourceAdapter.getPassword());
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        mask = codec.encode((Object)"mdbpassword");
        spec.setPassword(PasswordMaskingUtil.wrap((String)mask));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((Object)"mdbpassword", (Object)spec.getPassword());
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)endpoint.released);
    }

    @Test
    public void testMaskPassword2() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.setUseMaskedPassword(Boolean.valueOf(true));
        qResourceAdapter.setPasswordCodec(DefaultSensitiveStringCodec.class.getName() + ";key=anotherkey");
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key", "anotherkey");
        codec.init(prop);
        String mask = codec.encode((Object)"helloworld");
        qResourceAdapter.setPassword(mask);
        qResourceAdapter.start((BootstrapContext)ctx);
        Assertions.assertEquals((Object)"helloworld", (Object)qResourceAdapter.getPassword());
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        mask = codec.encode((Object)"mdbpassword");
        spec.setPassword(mask);
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((Object)"mdbpassword", (Object)spec.getPassword());
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)endpoint.released);
    }

    @Test
    public void testMaskPassword2ENC() throws Exception {
        ActiveMQResourceAdapter qResourceAdapter = new ActiveMQResourceAdapter();
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ActiveMQRATestBase.MyBootstrapContext ctx = new ActiveMQRATestBase.MyBootstrapContext();
        qResourceAdapter.setPasswordCodec(DefaultSensitiveStringCodec.class.getName() + ";key=anotherkey");
        DefaultSensitiveStringCodec codec = new DefaultSensitiveStringCodec();
        HashMap<String, String> prop = new HashMap<String, String>();
        prop.put("key", "anotherkey");
        codec.init(prop);
        String mask = codec.encode((Object)"helloworld");
        qResourceAdapter.setPassword(PasswordMaskingUtil.wrap((String)mask));
        qResourceAdapter.start((BootstrapContext)ctx);
        Assertions.assertEquals((Object)"helloworld", (Object)qResourceAdapter.getPassword());
        ActiveMQActivationSpec spec = new ActiveMQActivationSpec();
        spec.setResourceAdapter((ResourceAdapter)qResourceAdapter);
        spec.setUseJNDI(Boolean.valueOf(false));
        spec.setDestinationType("jakarta.jms.Queue");
        spec.setDestination("mdbQueue");
        mask = codec.encode((Object)"mdbpassword");
        spec.setPassword(PasswordMaskingUtil.wrap((String)mask));
        qResourceAdapter.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        CountDownLatch latch = new CountDownLatch(1);
        ActiveMQRATestBase.DummyMessageEndpoint endpoint = new ActiveMQRATestBase.DummyMessageEndpoint(latch);
        ActiveMQRATestBase.DummyMessageEndpointFactory endpointFactory = new ActiveMQRATestBase.DummyMessageEndpointFactory(endpoint, false);
        qResourceAdapter.endpointActivation((MessageEndpointFactory)endpointFactory, (ActivationSpec)spec);
        Assertions.assertEquals((Object)"mdbpassword", (Object)spec.getPassword());
        qResourceAdapter.stop();
        Assertions.assertTrue((boolean)endpoint.released);
    }

    @Test
    public void testConnectionParameterStringParsing() throws Exception {
        ActiveMQResourceAdapter resourceAdapter = new ActiveMQResourceAdapter();
        resourceAdapter.setConnectionParameters("enabledProtocols=TLS1\\,TLS1.2;sslEnabled=true");
        Assertions.assertEquals(((Map)resourceAdapter.getProperties().getParsedConnectionParameters().get(0)).get("enabledProtocols"), (Object)"TLS1,TLS1.2");
        resourceAdapter.setConnectionParameters("enabledProtocols=TLS1\\,TLS1.2;sslEnabled=true,enabledProtocols=TLS1.3\\,TLS1.4\\,TLS1.5;sslEnabled=true");
        Assertions.assertEquals(((Map)resourceAdapter.getProperties().getParsedConnectionParameters().get(0)).get("enabledProtocols"), (Object)"TLS1,TLS1.2");
        Assertions.assertEquals(((Map)resourceAdapter.getProperties().getParsedConnectionParameters().get(1)).get("enabledProtocols"), (Object)"TLS1.3,TLS1.4,TLS1.5");
        try {
            resourceAdapter.setConnectionParameters("enabledProtocols=TLS1,TLS1.2;sslEnabled=true,enabledProtocols=TLS1,TLS1.2;sslEnabled=true");
            Assertions.fail((String)"This should have failed");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testConnectionFactoryPropertiesApplyToRecoveryConfig() throws Exception {
        ServerLocator locator = this.createInVMNonHALocator();
        ClientSessionFactory factory = locator.createSessionFactory();
        ClientSession session = factory.createSession(false, false, false);
        ActiveMQDestination queue = (ActiveMQDestination)ActiveMQJMSClient.createQueue((String)"test");
        session.createQueue(QueueConfiguration.of((SimpleString)queue.getSimpleAddress()));
        session.close();
        ActiveMQResourceAdapter ra = new ActiveMQResourceAdapter();
        ra.setConnectorClassName(INVM_CONNECTOR_FACTORY);
        ra.setUserName("userGlobal");
        ra.setPassword("passwordGlobal");
        ra.setConnectionTTL(Long.valueOf(100L));
        ra.setCallFailoverTimeout(Long.valueOf(100L));
        ra.start((BootstrapContext)new org.apache.activemq.artemis.tests.unit.ra.BootstrapContext());
        Set resources = ra.getRecoveryManager().getResources();
        Assertions.assertEquals((long)100L, (long)ra.getDefaultActiveMQConnectionFactory().getServerLocator().getConnectionTTL());
        Assertions.assertEquals((long)100L, (long)ra.getDefaultActiveMQConnectionFactory().getServerLocator().getCallFailoverTimeout());
        for (XARecoveryConfig resource : resources) {
            Assertions.assertEquals((long)100L, (long)resource.createServerLocator().getConnectionTTL());
            Assertions.assertEquals((long)100L, (long)resource.createServerLocator().getCallFailoverTimeout());
        }
        ra.stop();
        Assertions.assertEquals((int)0, (int)resources.size());
        locator.close();
    }

    @Override
    public boolean useSecurity() {
        return false;
    }

    class DummyEndpoint
    implements MessageEndpoint {
        DummyEndpoint() {
        }

        public void beforeDelivery(Method method) throws NoSuchMethodException, ResourceException {
        }

        public void afterDelivery() throws ResourceException {
        }

        public void release() {
        }
    }
}

