/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.remoting;

import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.BaseInterceptor;
import org.apache.activemq.artemis.api.core.Interceptor;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryImpl;
import org.apache.activemq.artemis.core.client.impl.ClientSessionFactoryInternal;
import org.apache.activemq.artemis.core.protocol.core.CoreRemotingConnection;
import org.apache.activemq.artemis.core.protocol.core.impl.wireformat.Ping;
import org.apache.activemq.artemis.core.remoting.CloseListener;
import org.apache.activemq.artemis.core.remoting.FailureListener;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.spi.core.protocol.RemotingConnection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class PingTest
extends ActiveMQTestBase {
    private static final long CLIENT_FAILURE_CHECK_PERIOD = 500L;
    private ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.createServer(false, this.createDefaultNettyConfig());
        this.server.start();
    }

    @Test
    public void testNoFailureWithPinging() throws Exception {
        ServerLocator locator = this.createNettyNonHALocator();
        locator.setClientFailureCheckPeriod(500L);
        locator.setConnectionTTL(1000L);
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession(false, true, true);
        Assertions.assertEquals((int)1, (int)((ClientSessionFactoryInternal)csf).numConnections());
        Listener clientListener = new Listener();
        session.addFailureListener((SessionFailureListener)clientListener);
        RemotingConnection serverConn = null;
        while (serverConn == null) {
            Set conns = this.server.getRemotingService().getConnections();
            if (!conns.isEmpty()) {
                serverConn = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
                continue;
            }
            Thread.sleep(10L);
        }
        Listener serverListener = new Listener();
        serverConn.addFailureListener((FailureListener)serverListener);
        Thread.sleep(5000L);
        Assertions.assertNull((Object)((Object)clientListener.getException()));
        Assertions.assertNull((Object)((Object)serverListener.getException()));
        RemotingConnection serverConn2 = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
        Assertions.assertTrue((serverConn == serverConn2 ? (byte)1 : 0) != 0);
        session.close();
        csf.close();
        locator.close();
    }

    @Test
    public void testNoFailureNoPinging() throws Exception {
        TransportConfiguration transportConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfig}));
        locator.setClientFailureCheckPeriod(-1L);
        locator.setConnectionTTL(-1L);
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession(false, true, true);
        Assertions.assertEquals((int)1, (int)((ClientSessionFactoryInternal)csf).numConnections());
        Listener clientListener = new Listener();
        session.addFailureListener((SessionFailureListener)clientListener);
        RemotingConnection serverConn = null;
        while (serverConn == null) {
            Set conns = this.server.getRemotingService().getConnections();
            if (!conns.isEmpty()) {
                serverConn = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
                continue;
            }
            Thread.sleep(10L);
        }
        Listener serverListener = new Listener();
        serverConn.addFailureListener((FailureListener)serverListener);
        Thread.sleep(ActiveMQClient.DEFAULT_CLIENT_FAILURE_CHECK_PERIOD);
        Assertions.assertNull((Object)((Object)clientListener.getException()));
        Assertions.assertNull((Object)((Object)serverListener.getException()));
        RemotingConnection serverConn2 = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
        Assertions.assertTrue((serverConn == serverConn2 ? (byte)1 : 0) != 0);
        session.close();
        csf.close();
        locator.close();
    }

    @Test
    public void testNoPingingOnInVMConnection() throws Exception {
        CountDownLatch requiredPings = new CountDownLatch(1);
        CountDownLatch unwantedPings = new CountDownLatch(2);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((Interceptor)(packet, connection) -> {
            if (packet.getType() == 10) {
                Assertions.assertEquals((long)-1L, (long)((Ping)packet).getConnectionTTL());
                unwantedPings.countDown();
                requiredPings.countDown();
            }
            return true;
        }));
        TransportConfiguration transportConfig = new TransportConfiguration("org.apache.activemq.artemis.core.remoting.impl.invm.InVMConnectorFactory");
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfig}));
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession(false, true, true);
        Assertions.assertEquals((int)1, (int)((ClientSessionFactoryInternal)csf).numConnections());
        Assertions.assertTrue((boolean)requiredPings.await(5000L, TimeUnit.MILLISECONDS), (String)"server didn't received an expected ping from the client");
        Assertions.assertFalse((boolean)unwantedPings.await(ActiveMQClient.DEFAULT_CONNECTION_TTL * 2L, TimeUnit.MILLISECONDS), (String)"server received an unexpected ping from the client");
        session.close();
        csf.close();
        locator.close();
    }

    @Test
    public void testServerFailureNoPing() throws Exception {
        TransportConfiguration transportConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfig}));
        locator.setClientFailureCheckPeriod(500L);
        locator.setConnectionTTL(1000L);
        ClientSessionFactoryImpl csf = (ClientSessionFactoryImpl)this.createSessionFactory(locator);
        Listener clientListener = new Listener();
        ClientSession session = csf.createSession(false, true, true);
        Assertions.assertEquals((int)1, (int)csf.numConnections());
        session.addFailureListener((SessionFailureListener)clientListener);
        csf.stopPingingAfterOne();
        RemotingConnection serverConn = null;
        while (serverConn == null) {
            Set conns = this.server.getRemotingService().getConnections();
            if (!conns.isEmpty()) {
                serverConn = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
                continue;
            }
            Thread.sleep(10L);
        }
        Listener serverListener = new Listener();
        serverConn.addFailureListener((FailureListener)serverListener);
        for (int i = 0; !(i >= 1000 || this.server.getRemotingService().getConnections().isEmpty() && clientListener.getException() != null); ++i) {
            Thread.sleep(10L);
        }
        if (!this.server.getRemotingService().getConnections().isEmpty()) {
            RemotingConnection remotingConnection = (RemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
        }
        Assertions.assertTrue((boolean)this.server.getRemotingService().getConnections().isEmpty());
        Assertions.assertNotNull((Object)((Object)clientListener.getException()));
        Assertions.assertNotNull((Object)((Object)serverListener.getException()));
        session.close();
        csf.close();
        locator.close();
    }

    @Test
    public void testClientFailureNoServerPing() throws Exception {
        CountDownLatch pingOnServerLatch = new CountDownLatch(2);
        this.server.getRemotingService().addIncomingInterceptor((BaseInterceptor)((Interceptor)(packet, connection) -> {
            if (packet.getType() == 10) {
                pingOnServerLatch.countDown();
            }
            return true;
        }));
        TransportConfiguration transportConfig = new TransportConfiguration(INVM_CONNECTOR_FACTORY);
        ServerLocator locator = this.addServerLocator(ActiveMQClient.createServerLocatorWithoutHA((TransportConfiguration[])new TransportConfiguration[]{transportConfig}));
        locator.setClientFailureCheckPeriod(500L);
        locator.setConnectionTTL(1000L);
        ClientSessionFactory csf = this.createSessionFactory(locator);
        ClientSession session = csf.createSession(false, true, true);
        Assertions.assertEquals((int)1, (int)((ClientSessionFactoryInternal)csf).numConnections());
        final CountDownLatch clientLatch = new CountDownLatch(1);
        SessionFailureListener clientListener = new SessionFailureListener(){

            public void connectionFailed(ActiveMQException me, boolean failedOver) {
                clientLatch.countDown();
            }

            public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
                this.connectionFailed(me, failedOver);
            }

            public void beforeReconnect(ActiveMQException exception) {
            }
        };
        CountDownLatch serverLatch = new CountDownLatch(1);
        CloseListener serverListener = () -> serverLatch.countDown();
        session.addFailureListener(clientListener);
        CoreRemotingConnection serverConn = null;
        while (serverConn == null) {
            Set conns = this.server.getRemotingService().getConnections();
            if (!conns.isEmpty()) {
                serverConn = (CoreRemotingConnection)this.server.getRemotingService().getConnections().iterator().next();
                continue;
            }
            Thread.sleep(10L);
        }
        serverConn.addCloseListener(serverListener);
        Assertions.assertTrue((boolean)pingOnServerLatch.await(4000L, TimeUnit.MILLISECONDS), (String)"server has not received any ping from the client");
        serverConn.getChannel(0L, -1).setHandler(null);
        Assertions.assertTrue((boolean)clientLatch.await(4000L, TimeUnit.MILLISECONDS));
        Assertions.assertTrue((boolean)serverLatch.await(2L * this.server.getConfiguration().getConnectionTtlCheckInterval(), TimeUnit.MILLISECONDS));
        long start = System.currentTimeMillis();
        while (!this.server.getRemotingService().getConnections().isEmpty() && System.currentTimeMillis() - start < 10000L) {
            Thread.sleep(500L);
        }
        Assertions.assertTrue((boolean)this.server.getRemotingService().getConnections().isEmpty());
        session.close();
        csf.close();
        locator.close();
    }

    class Listener
    implements SessionFailureListener {
        volatile ActiveMQException me;

        Listener() {
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver) {
            this.me = me;
        }

        public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
            this.connectionFailed(me, failedOver);
        }

        public ActiveMQException getException() {
            return this.me;
        }

        public void beforeReconnect(ActiveMQException exception) {
        }
    }
}

