/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.retention;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.CFUtil;
import org.apache.activemq.artemis.tests.util.RandomUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ReplayTest
extends ActiveMQTestBase {
    ActiveMQServer server;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server = this.addServer(this.createServer(true, true));
        this.server.getConfiguration().setJournalRetentionDirectory(this.getJournalDir() + "retention");
        this.server.getConfiguration().setJournalFileSize(102400);
        this.server.start();
        this.server.addAddressInfo(new AddressInfo("t1").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)"t1").setAddress("t1").setRoutingType(RoutingType.ANYCAST));
        this.server.addAddressInfo(new AddressInfo("t2").addRoutingType(RoutingType.ANYCAST));
        this.server.createQueue(QueueConfiguration.of((String)"t2").setAddress("t2").setRoutingType(RoutingType.ANYCAST));
    }

    @Test
    public void testReplayAMQP() throws Exception {
        this.testReplay("AMQP", 10, false);
    }

    @Test
    public void testReplayCore() throws Exception {
        this.testReplay("CORE", 10, false);
    }

    protected void testReplay(String protocol, int size, boolean paging) throws Exception {
        StringBuffer buffer = new StringBuffer();
        buffer.append(RandomUtil.randomString());
        for (int i = 0; i < size; ++i) {
            buffer.append("*");
        }
        if (paging) {
            Queue serverQueue = this.server.locateQueue("t1");
            serverQueue.getPagingStore().startPaging();
        }
        ConnectionFactory cf = CFUtil.createConnectionFactory(protocol, "tcp://localhost:61616");
        try (Connection connection = cf.createConnection();){
            Session session = connection.createSession(false, 1);
            jakarta.jms.Queue queue = session.createQueue("t1");
            MessageProducer producer = session.createProducer(null);
            producer.send((Destination)queue, (Message)session.createTextMessage(buffer.toString()));
            connection.start();
            MessageConsumer consumer = session.createConsumer((Destination)queue);
            Assertions.assertNotNull((Object)consumer.receive(5000L));
            Assertions.assertNull((Object)consumer.receiveNoWait());
            this.server.replay(null, null, "t1", "t2", null);
            jakarta.jms.Queue t2 = session.createQueue("t2");
            MessageConsumer consumert2 = session.createConsumer((Destination)t2);
            TextMessage receivedMessage = (TextMessage)consumert2.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertEquals((Object)buffer.toString(), (Object)receivedMessage.getText());
            Assertions.assertNull((Object)consumert2.receiveNoWait());
            this.server.replay(null, null, "t2", "t1", null);
            receivedMessage = (TextMessage)consumer.receive(5000L);
            Assertions.assertNotNull((Object)receivedMessage);
            Assertions.assertNull((Object)consumer.receiveNoWait());
            this.server.replay(null, null, "t1", "t1", "foo='foo'");
            Assertions.assertNull((Object)consumer.receiveNoWait());
        }
    }

    @Test
    public void testReplayLargeAMQP() throws Exception {
        this.testReplay("AMQP", 512000, false);
    }

    @Test
    public void testReplayLargeCore() throws Exception {
        this.testReplay("CORE", 512000, false);
    }

    @Test
    public void testReplayCorePaging() throws Exception {
        this.testReplay("CORE", 10, true);
    }

    @Test
    public void testReplayLargeCorePaging() throws Exception {
        this.testReplay("CORE", 512000, true);
    }
}

