/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.stomp;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.UUID;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.tests.extensions.parameterized.ParameterizedTestExtension;
import org.apache.activemq.artemis.tests.integration.stomp.StompTestBase;
import org.apache.activemq.artemis.tests.integration.stomp.util.ClientStompFrame;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnection;
import org.apache.activemq.artemis.tests.integration.stomp.util.StompClientConnectionFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={ParameterizedTestExtension.class})
public class StompLVQTest
extends StompTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected StompClientConnection producerConn;
    protected StompClientConnection consumerConn;
    private final String queue = "lvq";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.server.createQueue(QueueConfiguration.of((String)"lvq").setLastValue(Boolean.valueOf(true)).setExclusive(Boolean.valueOf(true)));
        this.producerConn = StompClientConnectionFactory.createClientConnection(this.uri);
        this.consumerConn = StompClientConnectionFactory.createClientConnection(this.uri);
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        try {
            if (this.producerConn != null && this.producerConn.isConnected()) {
                try {
                    this.producerConn.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.producerConn.closeTransport();
        }
        try {
            if (this.consumerConn != null && this.consumerConn.isConnected()) {
                try {
                    this.consumerConn.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        finally {
            this.consumerConn.closeTransport();
        }
        super.tearDown();
    }

    @TestTemplate
    public void testLVQ() throws Exception {
        this.producerConn.connect(this.defUser, this.defPass);
        this.consumerConn.connect(this.defUser, this.defPass);
        StompLVQTest.subscribe(this.consumerConn, "lvqtest", "client", null, null, "lvq", true, 0);
        try {
            for (int i = 1; i <= 100; ++i) {
                String uuid = UUID.randomUUID().toString();
                ClientStompFrame frame = this.producerConn.sendFrame(this.producerConn.createFrame("SEND").addHeader("destination", "lvq").addHeader(Message.HDR_LAST_VALUE_NAME.toString(), "test").addHeader("receipt", uuid).setBody(String.valueOf(i)));
                Assertions.assertEquals((Object)"RECEIPT", (Object)frame.getCommand());
                Assertions.assertEquals((Object)uuid, (Object)frame.getHeader("receipt-id"));
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        ArrayList<ClientStompFrame> messages = new ArrayList<ClientStompFrame>();
        try {
            ClientStompFrame frame;
            while ((frame = this.consumerConn.receiveFrame(10000L)) != null) {
                Assertions.assertEquals((Object)"MESSAGE", (Object)frame.getCommand());
                StompLVQTest.ack(this.consumerConn, null, frame);
                messages.add(frame);
            }
        }
        catch (Exception e) {
            logger.error(null, (Throwable)e);
        }
        Assertions.assertEquals((int)2, (int)messages.size());
        Assertions.assertEquals((Object)"1", (Object)((ClientStompFrame)messages.get(0)).getBody());
        Assertions.assertEquals((Object)"100", (Object)((ClientStompFrame)messages.get(1)).getBody());
    }
}

