/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.transports.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.ArrayList;
import java.util.Random;
import org.apache.activemq.artemis.core.remoting.impl.netty.ActiveMQFrameDecoder2;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ActiveMQFrameDecoder2Test
extends ActiveMQTestBase {
    private static final int MSG_CNT = 10000;
    private static final int MSG_LEN = 1000;
    private static final int FRAGMENT_MAX_LEN = 1500;
    private static final Random rand = new Random();

    @Test
    public void testOrdinaryFragmentation() throws Exception {
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new ActiveMQFrameDecoder2()});
        byte[] data = new byte[1000];
        rand.nextBytes(data);
        ByteBuf src = Unpooled.buffer((int)10040000);
        while (src.writerIndex() < src.capacity()) {
            src.writeInt(1000);
            src.writeBytes(data);
        }
        ArrayList<ByteBuf> packets = new ArrayList<ByteBuf>();
        while (src.isReadable()) {
            int length = Math.min(rand.nextInt(1500), src.readableBytes());
            packets.add(src.readBytes(length));
        }
        int cnt = 0;
        for (ByteBuf p : packets) {
            ByteBuf frame;
            decoder.writeInbound(new Object[]{p});
            while ((frame = (ByteBuf)decoder.readInbound()) != null) {
                Assertions.assertEquals((int)4, (int)frame.readerIndex());
                Assertions.assertEquals((int)1000, (int)frame.readableBytes());
                Assertions.assertEquals((Object)Unpooled.wrappedBuffer((byte[])data), (Object)frame);
                ++cnt;
                frame.release();
            }
        }
        Assertions.assertEquals((int)10000, (int)cnt);
    }

    @Test
    public void testExtremeFragmentation() throws Exception {
        EmbeddedChannel decoder = new EmbeddedChannel(new ChannelHandler[]{new ActiveMQFrameDecoder2()});
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0})});
        Assertions.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0})});
        Assertions.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{0})});
        Assertions.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{4})});
        Assertions.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{5})});
        Assertions.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{6})});
        Assertions.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{7})});
        Assertions.assertNull((Object)decoder.readInbound());
        decoder.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{8})});
        ByteBuf frame = (ByteBuf)decoder.readInbound();
        Assertions.assertEquals((int)4, (int)frame.readerIndex());
        Assertions.assertEquals((int)4, (int)frame.readableBytes());
        Assertions.assertEquals((int)5, (int)frame.getByte(4));
        Assertions.assertEquals((int)6, (int)frame.getByte(5));
        Assertions.assertEquals((int)7, (int)frame.getByte(6));
        Assertions.assertEquals((int)8, (int)frame.getByte(7));
        frame.release();
    }
}

