/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.journal.impl;

import java.io.File;
import java.io.FilenameFilter;
import java.io.PrintStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.cli.commands.tools.journal.DecodeJournal;
import org.apache.activemq.artemis.cli.commands.tools.journal.EncodeJournal;
import org.apache.activemq.artemis.core.io.SequentialFileFactory;
import org.apache.activemq.artemis.core.io.nio.NIOSequentialFileFactory;
import org.apache.activemq.artemis.core.journal.EncodingSupport;
import org.apache.activemq.artemis.core.journal.PreparedTransactionInfo;
import org.apache.activemq.artemis.core.journal.RecordInfo;
import org.apache.activemq.artemis.core.journal.TestableJournal;
import org.apache.activemq.artemis.core.journal.impl.JournalFile;
import org.apache.activemq.artemis.core.journal.impl.JournalImpl;
import org.apache.activemq.artemis.core.journal.impl.JournalReaderCallback;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.logs.AssertionLoggerHandler;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ReusableLatch;
import org.apache.activemq.artemis.utils.SimpleFutureImpl;
import org.apache.activemq.artemis.utils.collections.SparseArrayLinkedList;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JournalImplTestBase
extends ActiveMQTestBase {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected List<RecordInfo> records = new LinkedList<RecordInfo>();
    protected TestableJournal journal;
    protected int recordLength = 1024;
    protected Map<Long, TransactionHolder> transactions = new LinkedHashMap<Long, TransactionHolder>();
    protected int maxAIO;
    protected int minFiles;
    protected int poolSize;
    protected int fileSize;
    protected boolean sync;
    protected String filePrefix = "amq";
    protected String fileExtension = "amq";
    protected SequentialFileFactory fileFactory;
    private final ReusableLatch latchDone = new ReusableLatch(0);
    private final ReusableLatch latchWait = new ReusableLatch(0);
    private Thread compactThread;
    protected AssertionLoggerHandler loggerHandler;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.resetFileFactory();
        this.fileFactory.start();
        this.transactions.clear();
        this.records.clear();
        this.loggerHandler = new AssertionLoggerHandler();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @AfterEach
    public void tearDown() throws Exception {
        try {
            JournalImplTestBase.stopComponent((ActiveMQComponent)this.journal);
            if (this.fileFactory != null) {
                this.fileFactory.stop();
            }
            this.fileFactory = null;
            this.journal = null;
            super.tearDown();
            if (this.loggerHandler == null) return;
        }
        catch (Throwable throwable) {
            if (this.loggerHandler == null) throw throwable;
            try {
                Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ144009"}));
                throw throwable;
            }
            finally {
                this.loggerHandler.close();
            }
        }
        try {
            Assertions.assertFalse((boolean)this.loggerHandler.findText(new String[]{"AMQ144009"}));
            return;
        }
        finally {
            this.loggerHandler.close();
        }
    }

    protected void resetFileFactory() throws Exception {
        if (this.fileFactory != null) {
            this.fileFactory.stop();
        }
        this.fileFactory = this.getFileFactory();
    }

    protected void checkAndReclaimFiles() throws Exception {
        this.journal.debugWait();
        boolean originalAutoReclaim = this.journal.isAutoReclaim();
        this.journal.setAutoReclaim(true);
        this.journal.checkReclaimStatus();
        this.journal.setAutoReclaim(originalAutoReclaim);
        this.journal.debugWait();
    }

    protected abstract SequentialFileFactory getFileFactory() throws Exception;

    protected void setup(int minFreeFiles, int fileSize, boolean sync, int maxAIO) {
        this.minFiles = minFreeFiles;
        this.poolSize = minFreeFiles;
        this.fileSize = fileSize;
        this.sync = sync;
        this.maxAIO = maxAIO;
    }

    protected void setup(int minFreeFiles, int poolSize, int fileSize, boolean sync, int maxAIO) {
        this.minFiles = minFreeFiles;
        this.poolSize = poolSize;
        this.fileSize = fileSize;
        this.sync = sync;
        this.maxAIO = maxAIO;
    }

    protected void setup(int minFreeFiles, int fileSize, boolean sync) {
        this.minFiles = minFreeFiles;
        this.poolSize = minFreeFiles;
        this.fileSize = fileSize;
        this.sync = sync;
        this.maxAIO = 50;
    }

    protected boolean suportsRetention() {
        return true;
    }

    public void createJournal() throws Exception {
        this.journal = new JournalImpl(this.fileSize, this.minFiles, this.poolSize, 0, 0, this.fileFactory, this.filePrefix, this.fileExtension, this.maxAIO){

            public void onCompactDone() {
                JournalImplTestBase.this.latchDone.countDown();
                try {
                    JournalImplTestBase.this.latchWait.await();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
        if (this.suportsRetention()) {
            File fileBackup = new File(this.getTestDir(), "backupFolder");
            fileBackup.mkdirs();
            ((JournalImpl)this.journal).setHistoryFolder(fileBackup, -1L, -1L);
        }
        this.journal.setAutoReclaim(false);
        this.addActiveMQComponent((ActiveMQComponent)this.journal);
    }

    protected void startCompact() throws Exception {
        this.latchDone.setCount(1);
        this.latchWait.setCount(1);
        this.compactThread = new Thread(() -> {
            try {
                this.journal.testCompact();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        });
        this.compactThread.start();
        this.latchDone.await();
    }

    protected void finishCompact() throws Exception {
        this.latchWait.countDown();
        this.compactThread.join();
    }

    protected void startJournal() throws Exception {
        this.journal.start();
    }

    protected void stopJournal() throws Exception {
        this.stopJournal(true);
    }

    protected void stopJournal(boolean reclaim) throws Exception {
        this.journal.flush();
        if (reclaim) {
            this.checkAndReclaimFiles();
        }
        this.journal.stop();
    }

    protected void exportImportJournal() throws Exception {
        File[] files;
        logger.debug("Exporting to {}/output.log", (Object)this.getTestDir());
        EncodeJournal.exportJournal((String)this.getTestDir(), (String)this.filePrefix, (String)this.fileExtension, (int)this.minFiles, (int)this.fileSize, (String)(this.getTestDir() + "/output.log"));
        File dir = new File(this.getTestDir());
        FilenameFilter fnf = (file, name) -> name.endsWith("." + this.fileExtension);
        logger.debug("file = {}", (Object)dir);
        for (File file2 : files = dir.listFiles(fnf)) {
            logger.debug("Deleting {}", (Object)file2);
            file2.delete();
        }
        DecodeJournal.importJournal((String)this.getTestDir(), (String)this.filePrefix, (String)this.fileExtension, (int)this.minFiles, (int)this.fileSize, (String)(this.getTestDir() + "/output.log"));
    }

    protected void loadAndCheck() throws Exception {
        this.loadAndCheck(false);
    }

    private static void describeJournal(SequentialFileFactory fileFactory, JournalImpl journal, File path, final PrintStream out) throws Exception {
        List files = journal.orderFiles();
        out.println("Journal path: " + path);
        for (JournalFile file : files) {
            out.println("#" + file + " (size=" + file.getFile().size() + ")");
            JournalImpl.readJournalFile((SequentialFileFactory)fileFactory, (JournalFile)file, (JournalReaderCallback)new JournalReaderCallback(){

                public void onReadUpdateRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@UpdateTX;txID=" + transactionID + "," + recordInfo);
                }

                public void onReadUpdateRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@Update;" + recordInfo);
                }

                public void onReadRollbackRecord(long transactionID) throws Exception {
                    out.println("operation@Rollback;txID=" + transactionID);
                }

                public void onReadPrepareRecord(long transactionID, byte[] extraData, int numberOfRecords) throws Exception {
                    out.println("operation@Prepare,txID=" + transactionID + ",numberOfRecords=" + numberOfRecords);
                }

                public void onReadDeleteRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@DeleteRecordTX;txID=" + transactionID + "," + recordInfo);
                }

                public void onReadDeleteRecord(long recordID) throws Exception {
                    out.println("operation@DeleteRecord;recordID=" + recordID);
                }

                public void onReadCommitRecord(long transactionID, int numberOfRecords) throws Exception {
                    out.println("operation@Commit;txID=" + transactionID + ",numberOfRecords=" + numberOfRecords);
                }

                public void onReadAddRecordTX(long transactionID, RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecordTX;txID=" + transactionID + "," + recordInfo);
                }

                public void onReadAddRecord(RecordInfo recordInfo) throws Exception {
                    out.println("operation@AddRecord;" + recordInfo);
                }

                public void markAsDataFile(JournalFile file1) {
                }
            });
        }
        out.println();
    }

    protected void loadAndCheck(boolean printDebugJournal) throws Exception {
        ArrayList<RecordInfo> committedRecords = new ArrayList<RecordInfo>();
        ArrayList<PreparedTransactionInfo> preparedTransactions = new ArrayList<PreparedTransactionInfo>();
        this.journal.load(committedRecords, preparedTransactions, null);
        this.checkRecordsEquivalent(this.records, committedRecords);
        if (printDebugJournal) {
            this.printJournalLists(this.records, committedRecords);
        }
        ArrayList<PreparedTransactionInfo> prepared = new ArrayList<PreparedTransactionInfo>();
        for (Map.Entry<Long, TransactionHolder> entry : this.transactions.entrySet()) {
            if (!entry.getValue().prepared) continue;
            PreparedTransactionInfo info = new PreparedTransactionInfo(entry.getKey().longValue(), null);
            info.getRecords().addAll(entry.getValue().records);
            info.getRecordsToDelete().addAll(entry.getValue().deletes);
            prepared.add(info);
        }
        this.checkTransactionsEquivalent(prepared, preparedTransactions);
    }

    protected void load() throws Exception {
        this.journal.load(new SparseArrayLinkedList(), null, null);
    }

    protected void beforeJournalOperation() throws Exception {
    }

    protected void add(long ... arguments) throws Exception {
        this.addWithSize(this.recordLength, arguments);
    }

    protected void addWithSize(int size, long ... arguments) throws Exception {
        for (long element : arguments) {
            byte[] record = this.generateRecord(size);
            this.beforeJournalOperation();
            this.journal.appendAddRecord(element, (byte)0, record, this.sync);
            this.records.add(new RecordInfo(element, 0, record, false, false, 0));
        }
        this.journal.debugWait();
    }

    protected boolean tryUpdate(long argument) throws Exception {
        byte[] updateRecord = this.generateRecord(this.recordLength);
        this.beforeJournalOperation();
        SimpleFutureImpl future = new SimpleFutureImpl();
        this.journal.tryAppendUpdateRecord(argument, (byte)0, updateRecord, (r, b) -> future.set((Object)b), this.sync, false);
        if (((Boolean)future.get()).booleanValue()) {
            Assertions.fail();
            this.records.add(new RecordInfo(argument, 0, updateRecord, true, false, 0));
        }
        return (Boolean)future.get();
    }

    protected void update(long ... arguments) throws Exception {
        for (long element : arguments) {
            byte[] updateRecord = this.generateRecord(this.recordLength);
            this.beforeJournalOperation();
            this.journal.appendUpdateRecord(element, (byte)0, updateRecord, this.sync);
            this.records.add(new RecordInfo(element, 0, updateRecord, true, false, 0));
        }
        this.journal.debugWait();
    }

    protected void delete(long ... arguments) throws Exception {
        for (long element : arguments) {
            this.beforeJournalOperation();
            this.journal.appendDeleteRecord(element, this.sync);
            this.removeRecordsForID(element);
        }
        this.journal.debugWait();
    }

    protected boolean tryDelete(long argument) throws Exception {
        this.beforeJournalOperation();
        AtomicBoolean result = new AtomicBoolean(true);
        this.journal.tryAppendDeleteRecord(argument, (t, b) -> result.set(b), this.sync);
        if (result.get()) {
            this.removeRecordsForID(argument);
        }
        this.journal.debugWait();
        return result.get();
    }

    protected void addTx(long txID, long ... arguments) throws Exception {
        TransactionHolder tx = this.getTransaction(txID);
        for (long element : arguments) {
            byte[] record = this.generateRecord(this.recordLength - 31);
            this.beforeJournalOperation();
            this.journal.appendAddRecordTransactional(txID, element, (byte)0, record);
            tx.records.add(new RecordInfo(element, 0, record, false, false, 0));
        }
        this.journal.debugWait();
    }

    protected void updateTx(long txID, long ... arguments) throws Exception {
        TransactionHolder tx = this.getTransaction(txID);
        for (long element : arguments) {
            byte[] updateRecord = this.generateRecord(this.recordLength - 31);
            this.beforeJournalOperation();
            this.journal.appendUpdateRecordTransactional(txID, element, (byte)0, updateRecord);
            tx.records.add(new RecordInfo(element, 0, updateRecord, true, false, 0));
        }
        this.journal.debugWait();
    }

    protected void deleteTx(long txID, long ... arguments) throws Exception {
        TransactionHolder tx = this.getTransaction(txID);
        for (long element : arguments) {
            this.beforeJournalOperation();
            this.journal.appendDeleteRecordTransactional(txID, element);
            tx.deletes.add(new RecordInfo(element, 0, null, true, false, 0));
        }
        this.journal.debugWait();
    }

    protected void prepare(long txID, EncodingSupport xid) throws Exception {
        TransactionHolder tx = this.transactions.get(txID);
        if (tx == null) {
            tx = new TransactionHolder();
            this.transactions.put(txID, tx);
        }
        if (tx.prepared) {
            throw new IllegalStateException("Transaction is already prepared");
        }
        this.beforeJournalOperation();
        this.journal.appendPrepareRecord(txID, xid, this.sync);
        tx.prepared = true;
        this.journal.debugWait();
    }

    protected void commit(long txID) throws Exception {
        TransactionHolder tx = this.transactions.remove(txID);
        if (tx == null) {
            throw new IllegalStateException("Cannot find tx " + txID);
        }
        this.beforeJournalOperation();
        this.journal.appendCommitRecord(txID, this.sync);
        this.records.addAll(tx.records);
        for (RecordInfo l : tx.deletes) {
            this.removeRecordsForID(l.id);
        }
        this.journal.debugWait();
    }

    protected void rollback(long txID) throws Exception {
        TransactionHolder tx = this.transactions.remove(txID);
        if (tx == null) {
            throw new IllegalStateException("Cannot find tx " + txID);
        }
        this.beforeJournalOperation();
        this.journal.appendRollbackRecord(txID, this.sync);
        this.journal.debugWait();
    }

    protected void removeRecordsForID(long id) {
        ListIterator<RecordInfo> iter = this.records.listIterator();
        while (iter.hasNext()) {
            RecordInfo info = iter.next();
            if (info.id != id) continue;
            iter.remove();
        }
    }

    protected TransactionHolder getTransaction(long txID) {
        TransactionHolder tx = this.transactions.get(txID);
        if (tx == null) {
            tx = new TransactionHolder();
            this.transactions.put(txID, tx);
        }
        return tx;
    }

    protected void checkTransactionsEquivalent(List<PreparedTransactionInfo> expected, List<PreparedTransactionInfo> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Lists not same length");
        Iterator<PreparedTransactionInfo> iterExpected = expected.iterator();
        Iterator<PreparedTransactionInfo> iterActual = actual.iterator();
        while (iterExpected.hasNext()) {
            PreparedTransactionInfo rexpected = iterExpected.next();
            PreparedTransactionInfo ractual = iterActual.next();
            Assertions.assertEquals((long)rexpected.getId(), (long)ractual.getId(), (String)"ids not same");
            this.checkRecordsEquivalent(rexpected.getRecords(), ractual.getRecords());
            Assertions.assertEquals((int)rexpected.getRecordsToDelete().size(), (int)ractual.getRecordsToDelete().size(), (String)"deletes size not same");
            Iterator iterDeletesExpected = rexpected.getRecordsToDelete().iterator();
            Iterator iterDeletesActual = ractual.getRecordsToDelete().iterator();
            while (iterDeletesExpected.hasNext()) {
                long lexpected = ((RecordInfo)iterDeletesExpected.next()).id;
                long lactual = ((RecordInfo)iterDeletesActual.next()).id;
                Assertions.assertEquals((long)lexpected, (long)lactual, (String)"Delete ids not same");
            }
        }
    }

    protected void checkRecordsEquivalent(List<RecordInfo> expected, List<RecordInfo> actual) {
        if (expected.size() != actual.size()) {
            this.printJournalLists(expected, actual);
        }
        Assertions.assertEquals((int)expected.size(), (int)actual.size(), (String)"Lists not same length");
        Iterator<RecordInfo> iterExpected = expected.iterator();
        Iterator<RecordInfo> iterActual = actual.iterator();
        while (iterExpected.hasNext()) {
            RecordInfo rexpected = iterExpected.next();
            RecordInfo ractual = iterActual.next();
            if (rexpected.id != ractual.id || rexpected.isUpdate != ractual.isUpdate) {
                this.printJournalLists(expected, actual);
            }
            Assertions.assertEquals((long)rexpected.id, (long)ractual.id, (String)"ids not same");
            Assertions.assertEquals((Object)rexpected.isUpdate, (Object)ractual.isUpdate, (String)"type not same");
            ActiveMQTestBase.assertEqualsByteArrays(rexpected.data, ractual.data);
        }
    }

    protected void printJournalLists(List<RecordInfo> expected, List<RecordInfo> actual) {
        try {
            HashSet<RecordInfo> expectedSet = new HashSet<RecordInfo>();
            expectedSet.addAll(expected);
            Assertions.assertEquals((int)expectedSet.size(), (int)expected.size(), (String)"There are duplicated on the expected list");
            HashSet<RecordInfo> actualSet = new HashSet<RecordInfo>();
            actualSet.addAll(actual);
            expectedSet.removeAll(actualSet);
            for (RecordInfo info : expectedSet) {
                logger.warn("The following record is missing:: {}", (Object)info);
            }
            Assertions.assertEquals((int)actualSet.size(), (int)actualSet.size(), (String)"There are duplicates on the actual list");
            Object[] expectedArray = expected.toArray(new RecordInfo[expected.size()]);
            Object[] actualArray = actual.toArray(new RecordInfo[actual.size()]);
            Assertions.assertArrayEquals((Object[])expectedArray, (Object[])actualArray);
        }
        catch (AssertionError e) {
            logger.warn(((Throwable)((Object)e)).getMessage(), (Throwable)((Object)e));
            HashSet<RecordInfo> hashActual = new HashSet<RecordInfo>();
            hashActual.addAll(actual);
            HashSet<RecordInfo> hashExpected = new HashSet<RecordInfo>();
            hashExpected.addAll(expected);
            logger.warn("#Summary **********************************************************************************************************************");
            for (RecordInfo r : hashActual) {
                if (hashExpected.contains(r)) continue;
                logger.warn("Record {} was supposed to be removed and it exists", (Object)r);
            }
            for (RecordInfo r : hashExpected) {
                if (hashActual.contains(r)) continue;
                logger.warn("Record {} was not found on actual list", (Object)r);
            }
            logger.warn("#expected **********************************************************************************************************************");
            for (RecordInfo recordInfo : expected) {
                logger.warn("Record::{}", (Object)recordInfo);
            }
            logger.warn("#actual ************************************************************************************************************************");
            for (RecordInfo recordInfo : actual) {
                logger.warn("Record::{}", (Object)recordInfo);
            }
            logger.warn("#records ***********************************************************************************************************************");
            try {
                JournalImplTestBase.describeJournal(this.journal.getFileFactory(), (JournalImpl)this.journal, this.journal.getFileFactory().getDirectory(), System.out);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            logger.warn("#records on retention (history) folder ***********************************************************************************************************************");
            try {
                NIOSequentialFileFactory nioSequentialFileFactory = new NIOSequentialFileFactory(this.journal.getHistoryFolder(), 1);
                JournalImpl backupJournal = new JournalImpl(this.journal.getFileSize(), this.journal.getMinFiles(), 10, 0, 0, (SequentialFileFactory)nioSequentialFileFactory, "amq", "amq", 1);
                JournalImplTestBase.describeJournal((SequentialFileFactory)nioSequentialFileFactory, backupJournal, this.journal.getHistoryFolder(), System.out);
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    protected byte[] generateRecord(int length) {
        byte[] record = new byte[length];
        for (int i = 0; i < length; ++i) {
            record[i] = ActiveMQTestBase.getSamplebyte(i);
        }
        return record;
    }

    protected String debugJournal() throws Exception {
        return "***************************************************\n" + ((JournalImpl)this.journal).debug() + "***************************************************\n";
    }

    static final class TransactionHolder {
        List<RecordInfo> records = new ArrayList<RecordInfo>();
        List<RecordInfo> deletes = new ArrayList<RecordInfo>();
        boolean prepared;

        TransactionHolder() {
        }
    }
}

