/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.postoffice.impl;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.postoffice.Address;
import org.apache.activemq.artemis.core.postoffice.impl.AddressImpl;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMap;
import org.apache.activemq.artemis.core.postoffice.impl.AddressMapVisitor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AddressMapUnitTest {
    AddressMap<SimpleString> underTest = new AddressMap("#", "*", '.');

    @Test
    public void testAddGetRemove() throws Exception {
        SimpleString a = SimpleString.of((String)"a.b.c");
        Assertions.assertTrue((boolean)this.isEmpty(a));
        this.underTest.put(a, (Object)a);
        Assertions.assertFalse((boolean)this.isEmpty(a));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(a));
        this.underTest.remove(a, (Object)a);
        Assertions.assertTrue((boolean)this.isEmpty(a));
    }

    private boolean isEmpty(SimpleString match) throws Exception {
        return this.countMatchingWildcards(match) == 0;
    }

    @Test
    public void testWildcardAddGet() throws Exception {
        SimpleString a = SimpleString.of((String)"a.*.c");
        Assertions.assertTrue((boolean)this.isEmpty(a));
        this.underTest.put(a, (Object)a);
        Assertions.assertFalse((boolean)this.isEmpty(a));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(a));
        this.underTest.remove(a, (Object)a);
        Assertions.assertTrue((boolean)this.isEmpty(a));
    }

    @Test
    public void testWildcardAllAddGet() throws Exception {
        SimpleString a = SimpleString.of((String)"a.b.#");
        Assertions.assertTrue((boolean)this.isEmpty(a));
        this.underTest.put(a, (Object)a);
        Assertions.assertFalse((boolean)this.isEmpty(a));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(a));
        this.underTest.remove(a, (Object)a);
        Assertions.assertTrue((boolean)this.isEmpty(a));
    }

    @Test
    public void testNoDots() throws Exception {
        SimpleString s1 = SimpleString.of((String)"abcde");
        SimpleString s2 = SimpleString.of((String)"abcde");
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(s2));
    }

    @Test
    public void testDotsSameLength2() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b");
        SimpleString s2 = SimpleString.of((String)"a.b");
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(s2));
    }

    @Test
    public void testA() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c");
        SimpleString s2 = SimpleString.of((String)"a.b.c.d.e.f.g.h.i.j.k.l.m.n.*");
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(s2));
    }

    @Test
    public void testB() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s2 = SimpleString.of((String)"a.b.x.e");
        SimpleString s3 = SimpleString.of((String)"a.b.c.*");
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testC() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x");
        SimpleString s3 = SimpleString.of((String)"a.b.*.d");
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testD() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x.e");
        SimpleString s3 = SimpleString.of((String)"a.b.*.d.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testE() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x.e.f");
        SimpleString s3 = SimpleString.of((String)"a.b.*.d.*.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testF() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x.e.f");
        SimpleString s3 = SimpleString.of((String)"#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testG() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x.e.f");
        SimpleString s3 = SimpleString.of((String)"a.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testH() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x.e.f");
        SimpleString s3 = SimpleString.of((String)"#.b.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testI() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x.e.f");
        SimpleString s3 = SimpleString.of((String)"a.#.b.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testJ() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.x.e.f");
        SimpleString s3 = SimpleString.of((String)"a.#.c.d.e.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testK() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.d.e.x");
        SimpleString s3 = SimpleString.of((String)"a.#.c.d.e.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertTrue((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testL() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d.e.f");
        SimpleString s2 = SimpleString.of((String)"a.b.c.d.e.x");
        SimpleString s3 = SimpleString.of((String)"a.#.c.d.*.f");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testM() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c");
        SimpleString s2 = SimpleString.of((String)"a.b.x.e");
        SimpleString s3 = SimpleString.of((String)"a.b.c.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testN() throws Exception {
        SimpleString s1 = SimpleString.of((String)"usd.stock");
        SimpleString s2 = SimpleString.of((String)"a.b.x.e");
        SimpleString s3 = SimpleString.of((String)"*.stock.#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testO() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s2 = SimpleString.of((String)"a.b.x.e");
        SimpleString s3 = SimpleString.of((String)"a.b.c.*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl a2 = new AddressImpl(s2);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        Assertions.assertFalse((boolean)a2.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testP() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s3 = SimpleString.of((String)"a.b.c#");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testQ() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s3 = SimpleString.of((String)"#a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testR() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s3 = SimpleString.of((String)"#*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testS() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s3 = SimpleString.of((String)"a.b.c*");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testT() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s3 = SimpleString.of((String)"*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testU() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.c.d");
        SimpleString s3 = SimpleString.of((String)"*a.b.c");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertFalse((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testV() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.d");
        SimpleString s3 = SimpleString.of((String)"a.b.#.d");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        this.underTest.put(s1, (Object)s1);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(s3));
        SimpleString s2 = SimpleString.of((String)"a.b.b.b.b.d");
        this.underTest.put(s2, (Object)s2);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(s3));
    }

    @Test
    public void testVReverse() throws Exception {
        SimpleString s1 = SimpleString.of((String)"a.b.d");
        SimpleString s3 = SimpleString.of((String)"a.b.#.d");
        AddressImpl a1 = new AddressImpl(s1);
        AddressImpl w = new AddressImpl(s3);
        Assertions.assertTrue((boolean)a1.matches((Address)w));
        this.underTest.put(s3, (Object)s3);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(s1));
    }

    @Test
    public void testHashNMatch() throws Exception {
        SimpleString addressABCF = SimpleString.of((String)"a.b.c.f");
        SimpleString addressACF = SimpleString.of((String)"a.c.f");
        SimpleString match = SimpleString.of((String)"a.#.f");
        this.underTest.put(addressABCF, (Object)addressABCF);
        this.underTest.put(addressACF, (Object)addressACF);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(match));
    }

    @Test
    public void testEndHash() throws Exception {
        SimpleString addressAB = SimpleString.of((String)"a.b");
        SimpleString addressACF = SimpleString.of((String)"a.c.f");
        SimpleString addressABC = SimpleString.of((String)"a.b.c");
        SimpleString match = SimpleString.of((String)"a.b.#");
        this.underTest.put(addressAB, (Object)addressAB);
        this.underTest.put(addressACF, (Object)addressACF);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(match));
        this.underTest.put(addressABC, (Object)addressABC);
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(match));
    }

    @Test
    public void testHashEndInMap() throws Exception {
        SimpleString addressABHash = SimpleString.of((String)"a.b.#");
        SimpleString addressABC = SimpleString.of((String)"a.b.c");
        SimpleString match = SimpleString.of((String)"a.b");
        this.underTest.put(addressABHash, (Object)addressABHash);
        this.underTest.put(addressABC, (Object)addressABC);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(match));
    }

    private int countMatchingWildcards(SimpleString plainAddress) throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatchingWildcards(plainAddress, value -> count.incrementAndGet());
        return count.get();
    }

    private int countNonWildcardMatching(SimpleString canBeWildcardAddress) throws Exception {
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatching(canBeWildcardAddress, value -> count.incrementAndGet());
        return count.get();
    }

    @Test
    public void testHashEndMatchMap() throws Exception {
        SimpleString match = SimpleString.of((String)"a.b.#");
        SimpleString addressABC = SimpleString.of((String)"a.b.c");
        SimpleString addressAB = SimpleString.of((String)"a.b");
        this.underTest.put(addressAB, (Object)addressAB);
        this.underTest.put(addressABC, (Object)addressABC);
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(match));
        Assertions.assertEquals((int)2, (int)this.countNonWildcardMatching(match));
        this.underTest.put(match, (Object)match);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(match));
    }

    @Test
    public void testHashAGet() throws Exception {
        SimpleString hashA = SimpleString.of((String)"#.a");
        this.underTest.put(hashA, (Object)hashA);
        SimpleString matchA = SimpleString.of((String)"a");
        SimpleString matchAB = SimpleString.of((String)"a.b");
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(matchA));
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(matchAB));
        AddressImpl aStar = new AddressImpl(hashA);
        AddressImpl aA = new AddressImpl(matchA);
        Assertions.assertTrue((boolean)aA.matches((Address)aStar));
        AddressImpl aAB = new AddressImpl(matchAB);
        Assertions.assertFalse((boolean)aAB.matches((Address)aStar));
    }

    @Test
    public void testStarOne() throws Exception {
        SimpleString star = SimpleString.of((String)"*");
        this.underTest.put(star, (Object)star);
        SimpleString matchA = SimpleString.of((String)"a");
        SimpleString matchAB = SimpleString.of((String)"a.b");
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatchingWildcards(matchA, value -> count.incrementAndGet());
        Assertions.assertEquals((int)1, (int)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(matchAB, value -> count.incrementAndGet());
        Assertions.assertEquals((int)0, (int)count.get());
    }

    @Test
    public void testHashOne() throws Exception {
        SimpleString hash = SimpleString.of((String)"#");
        this.underTest.put(hash, (Object)hash);
        SimpleString matchA = SimpleString.of((String)"a");
        SimpleString matchAB = SimpleString.of((String)"a.b");
        SimpleString matchABC = SimpleString.of((String)"a.b.c");
        AtomicInteger count = new AtomicInteger();
        AddressMapVisitor countCollector = value -> count.incrementAndGet();
        count.set(0);
        this.underTest.visitMatchingWildcards(matchA, countCollector);
        Assertions.assertEquals((int)1, (int)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(matchAB, countCollector);
        Assertions.assertEquals((int)1, (int)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(matchABC, countCollector);
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    public void testHashAMatch() throws Exception {
        SimpleString a = SimpleString.of((String)"a");
        this.underTest.put(a, (Object)a);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(SimpleString.of((String)"#.a")));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"a")));
    }

    @Test
    public void testHashA() throws Exception {
        SimpleString hashA = SimpleString.of((String)"#.a");
        this.underTest.put(hashA, (Object)hashA);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"a")));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"d.f.c.a")));
        SimpleString abcaS = SimpleString.of((String)"a.b.c.a");
        AddressImpl aHashA = new AddressImpl(hashA);
        AddressImpl aABCA = new AddressImpl(abcaS);
        Assertions.assertFalse((boolean)aABCA.matches((Address)aHashA));
        Assertions.assertFalse((boolean)aHashA.matches((Address)aABCA));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(abcaS));
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(SimpleString.of((String)"a.b")));
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(SimpleString.of((String)"a.b.c")));
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(SimpleString.of((String)"a.b.c.a.d")));
        SimpleString AHashA = SimpleString.of((String)"a.#.a");
        this.underTest.put(AHashA, (Object)AHashA);
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(SimpleString.of((String)"a.b.c.a")));
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(SimpleString.of((String)"a.b.c.a")));
        this.underTest.remove(hashA, (Object)hashA);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"a.b.c.a")));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"a.a")));
    }

    @Test
    public void testAHashA() throws Exception {
        AtomicInteger count = new AtomicInteger();
        AddressMapVisitor countCollector = value -> count.incrementAndGet();
        SimpleString AHashA = SimpleString.of((String)"a.#.a");
        this.underTest.put(AHashA, (Object)AHashA);
        count.set(0);
        this.underTest.visitMatchingWildcards(SimpleString.of((String)"a.b.c.a"), countCollector);
        Assertions.assertEquals((int)1, (int)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(SimpleString.of((String)"a.a"), countCollector);
        Assertions.assertEquals((int)1, (int)count.get());
        count.set(0);
        this.underTest.visitMatchingWildcards(SimpleString.of((String)"a"), countCollector);
        Assertions.assertEquals((int)0, (int)count.get());
    }

    @Test
    public void testStar() throws Exception {
        SimpleString star = SimpleString.of((String)"*");
        SimpleString addressA = SimpleString.of((String)"a");
        SimpleString addressAB = SimpleString.of((String)"a.b");
        this.underTest.put(star, (Object)star);
        this.underTest.put(addressAB, (Object)addressAB);
        AtomicInteger count = new AtomicInteger();
        this.underTest.visitMatchingWildcards(addressA, value -> count.incrementAndGet());
        Assertions.assertEquals((int)1, (int)count.get());
    }

    @Test
    public void testSomeAndAny() throws Exception {
        SimpleString star = SimpleString.of((String)"test.*.some.#");
        this.underTest.put(star, (Object)star);
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(star));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(star));
        SimpleString addressA = SimpleString.of((String)"test.1.some.la");
        this.underTest.put(addressA, (Object)addressA);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(star));
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(star));
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(addressA));
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(addressA));
    }

    @Test
    public void testAnyAndSome() throws Exception {
        SimpleString star = SimpleString.of((String)"test.#.some.*");
        this.underTest.put(star, (Object)star);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(star));
        SimpleString addressA = SimpleString.of((String)"test.1.some.la");
        this.underTest.put(addressA, (Object)addressA);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(star));
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(star));
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(addressA));
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(addressA));
    }

    @Test
    public void testAnyAndSomeInMap() throws Exception {
        SimpleString hashHash = SimpleString.of((String)"test.#.some.#");
        this.underTest.put(hashHash, (Object)hashHash);
        SimpleString starStar = SimpleString.of((String)"test.*.some.*");
        this.underTest.put(starStar, (Object)starStar);
        SimpleString hashStar = SimpleString.of((String)"test.#.A.*");
        this.underTest.put(hashStar, (Object)hashStar);
        SimpleString oneHashStar = SimpleString.of((String)"test.1.#.T");
        this.underTest.put(oneHashStar, (Object)oneHashStar);
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(hashHash));
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(hashHash));
        SimpleString reqular = SimpleString.of((String)"test.a.b.some");
        this.underTest.put(reqular, (Object)reqular);
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(hashHash));
        Assertions.assertEquals((int)1, (int)this.countNonWildcardMatching(reqular));
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(reqular));
    }

    @Test
    public void testHashAandHashB() throws Exception {
        SimpleString hashAhash = SimpleString.of((String)"test.#.aaa.#");
        this.underTest.put(hashAhash, (Object)hashAhash);
        SimpleString hashBhash = SimpleString.of((String)"test.#.bbb.#");
        this.underTest.put(hashBhash, (Object)hashBhash);
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(SimpleString.of((String)"test.aaa.bbb")));
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(SimpleString.of((String)"test.bbb.aaa")));
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(SimpleString.of((String)"test.bbb.aaa.ccc")));
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(SimpleString.of((String)"test.aaa.bbb.ccc")));
    }

    @Test
    public void testHashNoHashNo() throws Exception {
        SimpleString hashAhash = SimpleString.of((String)"test.#.0.#.168");
        this.underTest.put(hashAhash, (Object)hashAhash);
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"test.0.168")));
    }

    @Test
    public void testHashNoHashHashNo() throws Exception {
        SimpleString v = SimpleString.of((String)"test.#.0.#.168");
        this.underTest.put(v, (Object)v);
        v = SimpleString.of((String)"test.#.0.#");
        this.underTest.put(v, (Object)v);
        v = SimpleString.of((String)"test.0.#");
        this.underTest.put(v, (Object)v);
        Assertions.assertEquals((int)3, (int)this.countMatchingWildcards(SimpleString.of((String)"test.0.168")));
    }

    @Test
    public void testHashNoHashNoWithNMatch() throws Exception {
        for (String s : new String[]{"t.#.0.#", "t.#.1.#", "t.#.2.#", "t.#.3.#", "t.#.1.2.3", "t.0.1.2.3"}) {
            SimpleString v = SimpleString.of((String)s);
            this.underTest.put(v, (Object)v);
        }
        Assertions.assertEquals((int)6, (int)this.countMatchingWildcards(SimpleString.of((String)"t.0.1.2.3")));
    }

    @Test
    public void testSomeMoreHashPlacement() throws Exception {
        for (String s : new String[]{"t.#.0.#", "t.0.1.#", "t.0.1.2.#", "t.0.1.#.2.3", "t.*.#.1.2.3"}) {
            SimpleString v = SimpleString.of((String)s);
            this.underTest.put(v, (Object)v);
        }
        Assertions.assertEquals((int)5, (int)this.countMatchingWildcards(SimpleString.of((String)"t.0.1.2.3")));
        Assertions.assertEquals((int)3, (int)this.countMatchingWildcards(SimpleString.of((String)"t.0.1.2.3.4")));
    }

    @Test
    public void testManyEntries() throws Exception {
        SimpleString star;
        int i;
        for (i = 0; i < 10; ++i) {
            star = SimpleString.of((String)("test." + i));
            this.underTest.put(star, (Object)star);
        }
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.*")));
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.#")));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"test.0")));
        this.underTest.put(SimpleString.of((String)"test.#"), (Object)SimpleString.of((String)"test.#"));
        this.underTest.put(SimpleString.of((String)"test.*"), (Object)SimpleString.of((String)"test.*"));
        Assertions.assertEquals((int)3, (int)this.countMatchingWildcards(SimpleString.of((String)"test.1")));
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.#")));
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.*")));
        for (i = 0; i < 10; ++i) {
            star = SimpleString.of((String)("test.a." + i));
            this.underTest.put(star, (Object)star);
        }
        Assertions.assertEquals((int)2, (int)this.countMatchingWildcards(SimpleString.of((String)"test.a.0")));
        Assertions.assertEquals((int)20, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.#")));
        for (i = 0; i < 10; ++i) {
            star = SimpleString.of((String)("test.b." + i));
            this.underTest.put(star, (Object)star);
        }
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.b.*")));
        this.underTest.remove(SimpleString.of((String)"test.#"), (Object)SimpleString.of((String)"test.#"));
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.b.*")));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"test.a.0")));
        for (i = 0; i < 10; ++i) {
            star = SimpleString.of((String)("test.c." + i));
            this.underTest.put(star, (Object)star);
        }
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.c.*")));
        SimpleString testStarStar = SimpleString.of((String)"test.*.*");
        Assertions.assertEquals((int)30, (int)this.countNonWildcardMatching(testStarStar));
        this.underTest.put(testStarStar, (Object)testStarStar);
        Assertions.assertEquals((int)30, (int)this.countNonWildcardMatching(testStarStar));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(testStarStar));
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(SimpleString.of((String)"test.b.c")));
    }

    @Test
    public void testReset() throws Exception {
        for (int i = 0; i < 10; ++i) {
            SimpleString star = SimpleString.of((String)("test." + i));
            this.underTest.put(star, (Object)star);
        }
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(SimpleString.of((String)"test.*")));
        Assertions.assertEquals((int)10, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.*")));
        this.underTest.reset();
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.*")));
    }

    @Test
    public void testRemove() throws Exception {
        for (int i = 0; i < 10; ++i) {
            SimpleString star = SimpleString.of((String)("test." + i));
            this.underTest.put(star, (Object)star);
        }
        SimpleString test1 = SimpleString.of((String)"test.1");
        Assertions.assertEquals((int)1, (int)this.countMatchingWildcards(test1));
        this.underTest.remove(test1, (Object)test1);
        Assertions.assertEquals((int)0, (int)this.countMatchingWildcards(test1));
        Assertions.assertEquals((int)9, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.*")));
        for (int i = 0; i < 10; ++i) {
            SimpleString star = SimpleString.of((String)("test." + i));
            this.underTest.remove(star, (Object)star);
        }
        Assertions.assertEquals((int)0, (int)this.countNonWildcardMatching(SimpleString.of((String)"test.*")));
    }

    @Test
    public void testMax() throws Exception {
        this.underTest.put(SimpleString.of((String)"test.#.a"), (Object)SimpleString.of((String)"test.#.a"));
        this.underTest.put(SimpleString.of((String)"test.*.a"), (Object)SimpleString.of((String)"test.*.a"));
        this.underTest.put(SimpleString.of((String)"*.a"), (Object)SimpleString.of((String)"*.a"));
        this.underTest.put(SimpleString.of((String)"#.a"), (Object)SimpleString.of((String)"#.a"));
        Assertions.assertEquals((int)3, (int)this.countMatchingWildcards(SimpleString.of((String)"test.a")));
        Assertions.assertEquals((int)3, (int)this.countMatchingWildcards(SimpleString.of((String)"test.a.a")));
    }
}

