/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.remoting.impl.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.resolver.AddressResolverGroup;
import io.netty.resolver.NoopAddressResolverGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnector;
import org.apache.activemq.artemis.core.server.ActiveMQComponent;
import org.apache.activemq.artemis.spi.core.remoting.BaseConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.BufferHandler;
import org.apache.activemq.artemis.spi.core.remoting.ClientConnectionLifeCycleListener;
import org.apache.activemq.artemis.spi.core.remoting.ClientProtocolManager;
import org.apache.activemq.artemis.spi.core.remoting.Connection;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.ActiveMQThreadFactory;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SocksProxyTest
extends ActiveMQTestBase {
    private static final int SOCKS_PORT = 1080;
    private ExecutorService closeExecutor;
    private ExecutorService threadPool;
    private ScheduledExecutorService scheduledThreadPool;
    private NioEventLoopGroup bossGroup;
    private NioEventLoopGroup workerGroup;

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.closeExecutor = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.threadPool = Executors.newCachedThreadPool((ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.scheduledThreadPool = Executors.newScheduledThreadPool(5, (ThreadFactory)ActiveMQThreadFactory.defaultThreadFactory((String)((Object)((Object)this)).getClass().getName()));
        this.startSocksProxy();
    }

    @Override
    @AfterEach
    public void tearDown() throws Exception {
        this.closeExecutor.shutdownNow();
        this.threadPool.shutdownNow();
        this.scheduledThreadPool.shutdownNow();
        this.stopSocksProxy();
        super.tearDown();
    }

    @Test
    public void testSocksProxyHandlerAdded() throws Exception {
        InetAddress address = this.getNonLoopbackAddress();
        Assumptions.assumeTrue((address != null ? (byte)1 : 0) != 0, (String)"Cannot find non-loopback address");
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", address.getHostAddress());
        params.put("socksEnabled", true);
        params.put("socksHost", "localhost");
        ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID, boolean failed) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)listener, (Executor)this.closeExecutor, (Executor)this.threadPool, this.scheduledThreadPool);
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        ChannelPipeline pipeline = connector.getBootStrap().register().await().channel().pipeline();
        Assertions.assertNotNull((Object)pipeline.get(Socks5ProxyHandler.class));
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    private InetAddress getNonLoopbackAddress() throws SocketException {
        Enumeration<NetworkInterface> n = NetworkInterface.getNetworkInterfaces();
        InetAddress addr = null;
        while (n.hasMoreElements()) {
            NetworkInterface e = n.nextElement();
            Enumeration<InetAddress> a = e.getInetAddresses();
            boolean found = false;
            while (a.hasMoreElements()) {
                addr = a.nextElement();
                if (addr.isLoopbackAddress()) continue;
                found = true;
                break;
            }
            if (!found) continue;
            break;
        }
        return addr;
    }

    @Test
    public void testSocksProxyHandlerNotAddedForLocalhost() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", "localhost");
        params.put("socksEnabled", true);
        params.put("socksHost", "localhost");
        ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID, boolean failed) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)listener, (Executor)this.closeExecutor, (Executor)this.threadPool, this.scheduledThreadPool);
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        ChannelPipeline pipeline = connector.getBootStrap().register().await().channel().pipeline();
        Assertions.assertNull((Object)pipeline.get(Socks5ProxyHandler.class));
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    @Test
    public void testSocks5hSupport() throws Exception {
        BufferHandler handler = (connectionID, buffer) -> {};
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("host", "only-resolvable-on-proxy");
        params.put("socksEnabled", true);
        params.put("socksHost", "localhost");
        params.put("socksPort", 1080);
        params.put("socksRemoteDNS", true);
        ClientConnectionLifeCycleListener listener = new ClientConnectionLifeCycleListener(){

            public void connectionException(Object connectionID, ActiveMQException me) {
            }

            public void connectionDestroyed(Object connectionID, boolean failed) {
            }

            public void connectionCreated(ActiveMQComponent component, Connection connection, ClientProtocolManager protocol) {
            }

            public void connectionReadyForWrites(Object connectionID, boolean ready) {
            }
        };
        NettyConnector connector = new NettyConnector(params, handler, (BaseConnectionLifeCycleListener)listener, (Executor)this.closeExecutor, (Executor)this.threadPool, this.scheduledThreadPool);
        connector.start();
        Assertions.assertTrue((boolean)connector.isStarted());
        connector.getBootStrap().register().await().channel().pipeline();
        AddressResolverGroup resolver = connector.getBootStrap().config().resolver();
        Assertions.assertSame((Object)resolver, (Object)NoopAddressResolverGroup.INSTANCE);
        Connection connection = connector.createConnection(future -> {
            future.awaitUninterruptibly();
            Assertions.assertTrue((boolean)future.isSuccess());
            Socks5ProxyHandler socks5Handler = (Socks5ProxyHandler)future.channel().pipeline().get(Socks5ProxyHandler.class);
            Assertions.assertNotNull((Object)socks5Handler);
            InetSocketAddress remoteAddress = (InetSocketAddress)socks5Handler.destinationAddress();
            Assertions.assertTrue((boolean)remoteAddress.isUnresolved());
        });
        Assertions.assertNotNull((Object)connection);
        Assertions.assertTrue((boolean)connection.isOpen());
        connection.close();
        Assertions.assertFalse((boolean)connection.isOpen());
        connector.close();
        Assertions.assertFalse((boolean)connector.isStarted());
    }

    private void startSocksProxy() throws Exception {
        this.bossGroup = new NioEventLoopGroup();
        this.workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        b.group((EventLoopGroup)this.bossGroup, (EventLoopGroup)this.workerGroup);
        b.channel(NioServerSocketChannel.class);
        b.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
            }
        });
        b.bind(1080).sync();
    }

    private void stopSocksProxy() {
        this.bossGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        this.workerGroup.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
    }
}

