/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.unit.core.server.impl;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.core.server.impl.FileLockNodeManager;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.utils.UUID;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileLockTest
extends ActiveMQTestBase {
    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        File file = new File(this.getTestDir());
        file.mkdirs();
    }

    @Test
    public void testSetNodeID() throws Exception {
        FileLockNodeManager underTest = new FileLockNodeManager(this.getTestDirfile(), false);
        ReplicationPrimaryPolicyConfiguration replicationPrimaryPolicyConfiguration = ReplicationPrimaryPolicyConfiguration.withDefault();
        Object seed = "";
        for (int i = 0; i < 20; ++i) {
            replicationPrimaryPolicyConfiguration.setCoordinationId((String)seed);
            if (replicationPrimaryPolicyConfiguration.getCoordinationId() != null) {
                underTest.setNodeID(replicationPrimaryPolicyConfiguration.getCoordinationId());
            }
            seed = (String)seed + String.valueOf(i);
        }
        replicationPrimaryPolicyConfiguration.setCoordinationId("somme-dash-and-odd");
        if (replicationPrimaryPolicyConfiguration.getCoordinationId() != null) {
            underTest.setNodeID(replicationPrimaryPolicyConfiguration.getCoordinationId());
        }
    }

    @Test
    public void testNodeManagerStartPersistence() throws Exception {
        File managerDirectory = this.getTestDirfile();
        FileLockNodeManager manager = new FileLockNodeManager(managerDirectory, false);
        manager.start();
        Set files = Arrays.stream(managerDirectory.listFiles(pathname -> pathname.isFile())).collect(Collectors.toSet());
        Set expectedFileNames = Arrays.stream(new String[]{"server.lock", "serverlock.1", "serverlock.2"}).collect(Collectors.toSet());
        Assertions.assertEquals(expectedFileNames, files.stream().map(File::getName).collect(Collectors.toSet()));
        File nodeIdFile = files.stream().filter(file -> file.getName().equals("server.lock")).findFirst().get();
        byte[] encodedNodeId = manager.getUUID().asBytes();
        try (FileChannel serverLock = FileChannel.open(nodeIdFile.toPath(), StandardOpenOption.READ);){
            Assertions.assertEquals((int)16, (int)encodedNodeId.length);
            Assertions.assertEquals((long)19L, (long)serverLock.size());
            ByteBuffer readNodeId = ByteBuffer.allocate(16);
            serverLock.read(readNodeId, 3L);
            readNodeId.flip();
            Assertions.assertArrayEquals((byte[])encodedNodeId, (byte[])readNodeId.array());
        }
        Assertions.assertEquals((long)-1L, (long)manager.getNodeActivationSequence());
        Assertions.assertEquals((long)-1L, (long)manager.readNodeActivationSequence());
        Assertions.assertEquals((int)3, (int)managerDirectory.listFiles(pathname -> pathname.isFile()).length);
        manager.stop();
    }

    @Test
    public void testReplicateBackupNodeManagerStartPersistence() throws Exception {
        File managerDirectory = this.getTestDirfile();
        FileLockNodeManager manager = new FileLockNodeManager(managerDirectory, true);
        manager.start();
        Set files = Arrays.stream(managerDirectory.listFiles(pathname -> pathname.isFile())).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)files.isEmpty());
        Assertions.assertNull((Object)manager.getNodeId());
        Assertions.assertNull((Object)manager.getUUID());
        Assertions.assertEquals((long)-1L, (long)manager.getNodeActivationSequence());
        Assertions.assertEquals((long)-1L, (long)manager.readNodeActivationSequence());
        Assertions.assertEquals((int)0, (int)managerDirectory.listFiles(pathname -> pathname.isFile()).length);
        manager.stop();
    }

    @Test
    public void testReplicatedStopBackupPersistence() throws Exception {
        FileLockNodeManager manager = new FileLockNodeManager(this.getTestDirfile(), false);
        manager.start();
        Assertions.assertNotNull((Object)manager.getUUID());
        manager.writeNodeActivationSequence(1L);
        long nodeActivationSequence = manager.getNodeActivationSequence();
        Assertions.assertEquals((long)1L, (long)nodeActivationSequence);
        manager.stop();
        FileLockNodeManager replicatedManager = new FileLockNodeManager(this.getTestDirfile(), true);
        replicatedManager.start();
        Assertions.assertNull((Object)replicatedManager.getUUID());
        Assertions.assertEquals((long)1L, (long)replicatedManager.getNodeActivationSequence());
        UUID storedNodeId = UUIDGenerator.getInstance().generateUUID();
        replicatedManager.setNodeID(storedNodeId.toString());
        replicatedManager.setNodeActivationSequence(2L);
        replicatedManager.stopBackup();
        replicatedManager.setNodeID(UUIDGenerator.getInstance().generateStringUUID());
        replicatedManager.setNodeActivationSequence(3L);
        replicatedManager.stop();
        manager.start();
        Assertions.assertEquals((Object)storedNodeId, (Object)manager.getUUID());
        Assertions.assertEquals((long)2L, (long)manager.getNodeActivationSequence());
        manager.stop();
    }

    @Test
    public void testWriteNodeActivationSequence() throws Exception {
        FileLockNodeManager manager = new FileLockNodeManager(this.getTestDirfile(), false);
        manager.start();
        UUID id = manager.getUUID();
        Assertions.assertNotNull((Object)manager.getUUID());
        manager.writeNodeActivationSequence(1L);
        long nodeActivationSequence = manager.getNodeActivationSequence();
        Assertions.assertEquals((long)1L, (long)nodeActivationSequence);
        manager.stop();
        FileLockNodeManager otherManager = new FileLockNodeManager(this.getTestDirfile(), false);
        otherManager.start();
        Assertions.assertEquals((Object)id, (Object)otherManager.getUUID());
        Assertions.assertEquals((long)1L, (long)otherManager.getNodeActivationSequence());
        otherManager.stop();
    }

    @Test
    public void testNIOLock() throws Exception {
        this.doTestLock(new FileLockNodeManager(this.getTestDirfile(), false), new FileLockNodeManager(this.getTestDirfile(), false));
    }

    public void doTestLock(FileLockNodeManager lockManager1, FileLockNodeManager lockManager2) throws Exception {
        lockManager1.start();
        lockManager2.start();
        lockManager1.startPrimaryNode();
        Thread t = new Thread(() -> {
            try {
                lockManager2.startPrimaryNode();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        t.start();
        Assertions.assertTrue((boolean)lockManager1.isPrimaryLocked());
        Thread.sleep(500L);
        Assertions.assertFalse((boolean)lockManager2.isPrimaryLocked());
        lockManager1.crashPrimaryServer();
        t.join();
        Assertions.assertFalse((boolean)lockManager1.isPrimaryLocked());
        Assertions.assertTrue((boolean)lockManager2.isPrimaryLocked());
        lockManager2.crashPrimaryServer();
        lockManager1.stop();
        lockManager2.stop();
    }
}

