/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.transport.amqp.client.AmqpAbstractResource;
import org.apache.activemq.transport.amqp.client.AmqpConnection;
import org.apache.activemq.transport.amqp.client.AmqpReceiver;
import org.apache.activemq.transport.amqp.client.AmqpSender;
import org.apache.activemq.transport.amqp.client.AmqpTransactionContext;
import org.apache.activemq.transport.amqp.client.AmqpTransactionId;
import org.apache.activemq.transport.amqp.client.util.AsyncResult;
import org.apache.activemq.transport.amqp.client.util.ClientFuture;
import org.apache.activemq.transport.amqp.client.util.UnmodifiableProxy;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Session;

public class AmqpSession
extends AmqpAbstractResource<Session> {
    private final AtomicLong receiverIdGenerator = new AtomicLong();
    private final AtomicLong senderIdGenerator = new AtomicLong();
    private final AmqpConnection connection;
    private final String sessionId;
    private final AmqpTransactionContext txContext;
    private final AtomicBoolean closed = new AtomicBoolean();

    public AmqpSession(AmqpConnection connection, String sessionId) {
        this.connection = connection;
        this.sessionId = sessionId;
        this.txContext = new AmqpTransactionContext(this);
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            ClientFuture request = new ClientFuture();
            this.getScheduler().execute(() -> {
                this.checkClosed();
                this.close(request);
                this.pumpToProtonTransport(request);
            });
            request.sync();
        }
    }

    public AmqpSender createSender() throws Exception {
        return this.createSender(null, false);
    }

    public AmqpSender createAnonymousSender() throws Exception {
        return this.createSender(null, false);
    }

    public AmqpSender createSender(String address) throws Exception {
        return this.createSender(address, false);
    }

    public AmqpSender createSender(String address, Symbol[] desiredCapabilities) throws Exception {
        return this.createSender(address, false, desiredCapabilities, null, null);
    }

    public AmqpSender createSender(String address, boolean presettle) throws Exception {
        return this.createSender(address, presettle, null, null, null);
    }

    public AmqpSender createSender(String address, boolean presettle, Symbol[] desiredCapabilities, Symbol[] offeredCapabilities, Map<Symbol, Object> properties) throws Exception {
        this.checkClosed();
        AmqpSender sender = new AmqpSender(this, address, this.getNextSenderId());
        sender.setPresettle(presettle);
        sender.setDesiredCapabilities(desiredCapabilities);
        sender.setOfferedCapabilities(offeredCapabilities);
        sender.setProperties(properties);
        ClientFuture request = new ClientFuture();
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            sender.setStateInspector(this.getStateInspector());
            sender.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return sender;
    }

    public AmqpSender createSender(String address, SenderSettleMode senderMode, ReceiverSettleMode receiverMode) throws Exception {
        return this.createSender(address, senderMode, receiverMode, AmqpSender.DEFAULT_OUTCOMES);
    }

    public AmqpSender createSender(String address, SenderSettleMode senderMode, ReceiverSettleMode receiverMode, Symbol[] outcomes) throws Exception {
        this.checkClosed();
        AmqpSender sender = new AmqpSender(this, address, this.getNextSenderId(), senderMode, receiverMode, outcomes);
        ClientFuture request = new ClientFuture();
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            sender.setStateInspector(this.getStateInspector());
            sender.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return sender;
    }

    public AmqpSender createSender(Target target) throws Exception {
        return this.createSender(target, this.getNextSenderId());
    }

    public AmqpSender createSender(Target target, String senderId) throws Exception {
        return this.createSender(target, senderId, null, null, null);
    }

    public AmqpSender createSender(Target target, String senderId, Symbol[] desiredCapabilities, Symbol[] offeredCapabilities, Map<Symbol, Object> properties) throws Exception {
        this.checkClosed();
        AmqpSender sender = new AmqpSender(this, target, senderId);
        sender.setDesiredCapabilities(desiredCapabilities);
        sender.setOfferedCapabilities(offeredCapabilities);
        sender.setProperties(properties);
        ClientFuture request = new ClientFuture();
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            sender.setStateInspector(this.getStateInspector());
            sender.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return sender;
    }

    public AmqpReceiver createReceiver(String address) throws Exception {
        return this.createReceiver(address, null, false);
    }

    public AmqpReceiver createReceiver(String address, String selector) throws Exception {
        return this.createReceiver(address, selector, false);
    }

    public AmqpReceiver createReceiver(String address, String selector, boolean noLocal) throws Exception {
        return this.createReceiver(address, selector, noLocal, false);
    }

    public AmqpReceiver createReceiver(String address, String selector, boolean noLocal, boolean presettle) throws Exception {
        return this.createReceiver(address, selector, noLocal, presettle, null);
    }

    public AmqpReceiver createReceiver(String address, String selector, boolean noLocal, boolean presettle, Map<Symbol, Object> properties) throws Exception {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        AmqpReceiver receiver = new AmqpReceiver(this, address, this.getNextReceiverId());
        receiver.setNoLocal(noLocal);
        receiver.setPresettle(presettle);
        if (selector != null && !selector.isEmpty()) {
            receiver.setSelector(selector);
        }
        if (properties != null && !properties.isEmpty()) {
            receiver.setProperties(properties);
        }
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            receiver.setStateInspector(this.getStateInspector());
            receiver.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return receiver;
    }

    public AmqpReceiver createReceiver(String address, SenderSettleMode senderMode, ReceiverSettleMode receiverMode) throws Exception {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        AmqpReceiver receiver = new AmqpReceiver(this, address, this.getNextReceiverId(), senderMode, receiverMode);
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            receiver.setStateInspector(this.getStateInspector());
            receiver.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return receiver;
    }

    public AmqpReceiver createReceiver(Source source) throws Exception {
        return this.createReceiver(source, this.getNextReceiverId());
    }

    public AmqpReceiver createReceiver(Source source, String receiverId) throws Exception {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        AmqpReceiver receiver = new AmqpReceiver(this, source, receiverId);
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            receiver.setStateInspector(this.getStateInspector());
            receiver.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return receiver;
    }

    public AmqpReceiver createMulticastReceiver(Source source, String receiverId, String receiveName) throws Exception {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        AmqpReceiver receiver = new AmqpReceiver(this, source, receiverId);
        receiver.setSubscriptionName(receiveName);
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            receiver.setStateInspector(this.getStateInspector());
            receiver.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return receiver;
    }

    public AmqpReceiver createMulticastReceiver(String receiverId, String address, String receiveName) throws Exception {
        this.checkClosed();
        ClientFuture request = new ClientFuture();
        AmqpReceiver receiver = new AmqpReceiver(this, address, receiverId);
        receiver.setSubscriptionName(receiveName);
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            receiver.setStateInspector(this.getStateInspector());
            receiver.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return receiver;
    }

    public AmqpReceiver createDurableReceiver(String address, String subscriptionName) throws Exception {
        return this.createDurableReceiver(address, subscriptionName, null, false);
    }

    public AmqpReceiver createDurableReceiver(String address, String subscriptionName, String selector) throws Exception {
        return this.createDurableReceiver(address, subscriptionName, selector, false);
    }

    public AmqpReceiver createDurableReceiver(String address, String subscriptionName, String selector, boolean noLocal) throws Exception {
        this.checkClosed();
        if (subscriptionName == null || subscriptionName.isEmpty()) {
            throw new IllegalArgumentException("subscription name must not be null or empty.");
        }
        ClientFuture request = new ClientFuture();
        AmqpReceiver receiver = new AmqpReceiver(this, address, this.getNextReceiverId());
        receiver.setSubscriptionName(subscriptionName);
        receiver.setNoLocal(noLocal);
        if (selector != null && !selector.isEmpty()) {
            receiver.setSelector(selector);
        }
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            receiver.setStateInspector(this.getStateInspector());
            receiver.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return receiver;
    }

    public AmqpReceiver lookupSubscription(String subscriptionName) throws Exception {
        this.checkClosed();
        if (subscriptionName == null || subscriptionName.isEmpty()) {
            throw new IllegalArgumentException("subscription name must not be null or empty.");
        }
        ClientFuture request = new ClientFuture();
        AmqpReceiver receiver = new AmqpReceiver(this, (String)null, this.getNextReceiverId());
        receiver.setSubscriptionName(subscriptionName);
        this.connection.getScheduler().execute(() -> {
            this.checkClosed();
            receiver.setStateInspector(this.getStateInspector());
            receiver.open(request);
            this.pumpToProtonTransport(request);
        });
        request.sync();
        return receiver;
    }

    public AmqpConnection getConnection() {
        return this.connection;
    }

    public Session getSession() {
        return UnmodifiableProxy.sessionProxy((Session)this.getEndpoint());
    }

    public boolean isInTransaction() {
        return this.txContext.isInTransaction();
    }

    public String toString() {
        return "AmqpSession { " + this.sessionId + " }";
    }

    public void begin() throws Exception {
        if (this.txContext.isInTransaction()) {
            throw new jakarta.jms.IllegalStateException("Session already has an active transaction");
        }
        this.txContext.begin();
    }

    public void commit() throws Exception {
        if (!this.txContext.isInTransaction()) {
            throw new jakarta.jms.IllegalStateException("Commit called on Session that does not have an active transaction");
        }
        this.txContext.commit();
    }

    public void rollback() throws Exception {
        if (!this.txContext.isInTransaction()) {
            throw new jakarta.jms.IllegalStateException("Rollback called on Session that does not have an active transaction");
        }
        this.txContext.rollback();
    }

    ScheduledExecutorService getScheduler() {
        return this.connection.getScheduler();
    }

    Connection getProtonConnection() {
        return this.connection.getProtonConnection();
    }

    void pumpToProtonTransport(AsyncResult request) {
        this.connection.pumpToProtonTransport(request);
    }

    public AmqpTransactionId getTransactionId() {
        if (this.txContext != null && this.txContext.isInTransaction()) {
            return this.txContext.getTransactionId();
        }
        return null;
    }

    AmqpTransactionContext getTransactionContext() {
        return this.txContext;
    }

    @Override
    protected void doOpenInspection() {
        try {
            this.getStateInspector().inspectOpenedResource(this.getSession());
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    @Override
    protected void doClosedInspection() {
        try {
            this.getStateInspector().inspectClosedResource(this.getSession());
        }
        catch (Throwable error) {
            this.getStateInspector().markAsInvalid(error.getMessage());
        }
    }

    private String getNextSenderId() {
        return this.sessionId + ":" + this.senderIdGenerator.incrementAndGet();
    }

    private String getNextReceiverId() {
        return this.sessionId + ":" + this.receiverIdGenerator.incrementAndGet();
    }

    private void checkClosed() {
        if (this.isClosed() || this.connection.isClosed()) {
            throw new IllegalStateException("Session is already closed");
        }
    }
}

