/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.transport.amqp.client;

import org.apache.qpid.proton.amqp.Binary;

public class AmqpTransactionId {
    public static final int DECLARE_MARKER = 1;
    public static final int ROLLBACK_MARKER = 2;
    public static final int COMMIT_MARKER = 3;
    private final String txId;
    private Binary remoteTxId;
    private int state = 1;

    public AmqpTransactionId(String txId) {
        this.txId = txId;
    }

    public boolean isDeclare() {
        return this.state == 1;
    }

    public boolean isCommit() {
        return this.state == 3;
    }

    public boolean isRollback() {
        return this.state == 2;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getTxId() {
        return this.txId;
    }

    public Binary getRemoteTxId() {
        return this.remoteTxId;
    }

    public void setRemoteTxId(Binary remoteTxId) {
        this.remoteTxId = remoteTxId;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.txId == null ? 0 : this.txId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AmqpTransactionId other = (AmqpTransactionId)obj;
        return !(this.txId == null ? other.txId != null : !this.txId.equals(other.txId));
    }
}

