/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.amqp;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQBuffers;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessagePersisterV2;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPStandardMessage;
import org.apache.activemq.artemis.utils.RandomUtil;
import org.junit.Assert;
import org.junit.Test;

public class ParseAppMultiThread {
    @Test
    public void testMultiThreadParsing() throws Exception {
        for (int rep = 0; rep < 500; ++rep) {
            Thread[] threads;
            String randomStr = RandomUtil.randomString();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("color", randomStr);
            for (int i = 0; i < 10; ++i) {
                map.put("stuff" + i, "value" + i);
            }
            AMQPStandardMessage originalMessage = AMQPStandardMessage.createMessage((long)1L, (long)0L, (SimpleString)SimpleString.toSimpleString((String)"duh"), null, null, null, null, map, null, null);
            AMQPMessagePersisterV2 persister = AMQPMessagePersisterV2.getInstance();
            ActiveMQBuffer buffer = ActiveMQBuffers.dynamicBuffer((int)1024);
            persister.encode(buffer, (Message)originalMessage);
            buffer.readerIndex(1);
            AMQPStandardMessage amqpStandardMessage = (AMQPStandardMessage)persister.decode(buffer, null, null);
            if (rep == 0) {
                Field field = AMQPMessage.class.getDeclaredField("applicationProperties");
                field.setAccessible(true);
                Assert.assertNull((Object)field.get(amqpStandardMessage));
            }
            CyclicBarrier barrier = (threads = new Thread[0]).length > 0 ? new CyclicBarrier(threads.length) : null;
            AtomicInteger errors = new AtomicInteger(0);
            for (int i = 0; i < threads.length; ++i) {
                Runnable r = () -> {
                    try {
                        barrier.await();
                        Assert.assertEquals((Object)randomStr, (Object)amqpStandardMessage.getObjectProperty(SimpleString.toSimpleString((String)"color")));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        errors.incrementAndGet();
                    }
                };
                threads[i] = new Thread(r);
                threads[i].start();
            }
            for (Thread t : threads) {
                t.join();
            }
            Assert.assertEquals((Object)randomStr, (Object)amqpStandardMessage.getObjectPropertyForFilter(SimpleString.toSimpleString((String)"color")));
            Assert.assertEquals((long)0L, (long)errors.get());
        }
    }
}

