/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.balancing;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.activemq.artemis.core.server.balancing.policies.FirstElementPolicy;
import org.apache.activemq.artemis.core.server.balancing.policies.Policy;
import org.apache.activemq.artemis.core.server.balancing.policies.PolicyFactory;
import org.apache.activemq.artemis.core.server.balancing.policies.PolicyFactoryResolver;
import org.apache.activemq.artemis.core.server.balancing.targets.Target;
import org.apache.activemq.artemis.core.server.balancing.targets.TargetKey;
import org.apache.activemq.artemis.tests.integration.balancing.BalancingTestBase;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TargetKeyTest
extends BalancingTestBase {
    private static final String MOCK_POLICY_NAME = "MOCK_POLICY";
    private final String protocol;
    private final List<String> keys = new ArrayList<String>();

    @Parameterized.Parameters(name="protocol: {0}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (String protocol : Arrays.asList("AMQP", "CORE", "OPENWIRE")) {
            data.add(new Object[]{protocol});
        }
        return data;
    }

    public TargetKeyTest(String protocol) {
        this.protocol = protocol;
    }

    @Before
    public void setup() throws Exception {
        PolicyFactoryResolver.getInstance().registerPolicyFactory(new PolicyFactory(){

            public String[] getSupportedPolicies() {
                return new String[]{TargetKeyTest.MOCK_POLICY_NAME};
            }

            public Policy createPolicy(String policyName) {
                return new FirstElementPolicy(TargetKeyTest.MOCK_POLICY_NAME){

                    public Target selectTarget(List<Target> targets, String key) {
                        TargetKeyTest.this.keys.add(key);
                        return super.selectTarget(targets, key);
                    }
                };
            }
        });
    }

    @Test
    public void testClientIDKey() throws Exception {
        this.setupLiveServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupBalancerServerWithDiscovery(0, TargetKey.CLIENT_ID, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, "test", null, null);
        this.keys.clear();
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assert.assertEquals((long)1L, (long)this.keys.size());
        Assert.assertEquals((Object)"test", (Object)this.keys.get(0));
    }

    @Test
    public void testSNIHostKey() throws Exception {
        String localHostname = "localhost.localdomain";
        if (!this.checkLocalHostname(localHostname) && !this.checkLocalHostname(localHostname = "artemis.localtest.me")) {
            localHostname = "localhost";
            Assume.assumeTrue(("CORE".equals(this.protocol) && this.checkLocalHostname(localHostname) ? 1 : 0) != 0);
        }
        this.setupLiveServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.getDefaultServerAcceptor(0).getParams().put("sslEnabled", true);
        this.getDefaultServerAcceptor(0).getParams().put("keyStorePath", "server-keystore.jks");
        this.getDefaultServerAcceptor(0).getParams().put("keyStorePassword", "securepass");
        this.setupBalancerServerWithDiscovery(0, TargetKey.SNI_HOST, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, true, localHostname, 61616, null, null, null);
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assert.assertEquals((long)1L, (long)this.keys.size());
        Assert.assertEquals((Object)localHostname, (Object)this.keys.get(0));
    }

    @Test
    public void testSourceIPKey() throws Exception {
        this.setupLiveServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupBalancerServerWithDiscovery(0, TargetKey.SOURCE_IP, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, null, null);
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assert.assertEquals((long)1L, (long)this.keys.size());
        Assert.assertEquals((Object)InetAddress.getLoopbackAddress().getHostAddress(), (Object)this.keys.get(0));
    }

    @Test
    public void testUserNameKey() throws Exception {
        this.setupLiveServerWithDiscovery(0, GROUP_ADDRESS, GROUP_PORT, true, true, false);
        this.setupBalancerServerWithDiscovery(0, TargetKey.USER_NAME, MOCK_POLICY_NAME, null, true, null, 1);
        this.startServers(0);
        ConnectionFactory connectionFactory = this.createFactory(this.protocol, false, "localhost", 61616, null, "admin", "admin");
        try (Connection connection = connectionFactory.createConnection();){
            connection.start();
        }
        Assert.assertEquals((long)1L, (long)this.keys.size());
        Assert.assertEquals((Object)"admin", (Object)this.keys.get(0));
    }

    private boolean checkLocalHostname(String host) {
        try {
            return InetAddress.getByName(host).isLoopbackAddress();
        }
        catch (UnknownHostException ignore) {
            return false;
        }
    }
}

