/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.client;

import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.tests.util.ActiveMQTestBase;
import org.apache.activemq.artemis.tests.util.Wait;
import org.junit.Before;
import org.junit.Test;

public class AutoDeleteAddressTest
extends ActiveMQTestBase {
    public final SimpleString addressA = new SimpleString("addressA");
    public final SimpleString queueA = new SimpleString("queueA");
    private ServerLocator locator;
    private ActiveMQServer server;
    private ClientSessionFactory cf;

    @Before
    public void setUp() throws Exception {
        super.setUp();
        this.locator = this.createInVMNonHALocator();
        this.server = this.createServer(false);
        this.server.start();
        this.cf = this.createSessionFactory(this.locator);
    }

    @Test
    public void testAutoDeleteAutoCreatedAddress() throws Exception {
        this.server.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        AutoDeleteAddressTest.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
        this.cf.createSession().createConsumer(this.queueA).close();
        Wait.assertTrue(() -> this.server.getAddressInfo(this.addressA) == null);
    }

    @Test
    public void testNegativeAutoDeleteAutoCreatedAddress() throws Exception {
        this.server.getAddressSettingsRepository().addMatch(this.addressA.toString(), (Object)new AddressSettings().setAutoDeleteAddresses(Boolean.valueOf(false)));
        this.server.createQueue(new QueueConfiguration(this.queueA).setAddress(this.addressA).setRoutingType(RoutingType.ANYCAST).setAutoCreated(Boolean.valueOf(true)));
        AutoDeleteAddressTest.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
        this.cf.createSession().createConsumer(this.queueA).close();
        AutoDeleteAddressTest.assertNotNull((Object)this.server.getAddressInfo(this.addressA));
    }
}

