/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tests.integration.cluster.failover.quorum;

import java.io.IOException;
import java.util.Collections;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.core.config.Configuration;
import org.apache.activemq.artemis.core.config.ha.DistributedPrimitiveManagerConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationBackupPolicyConfiguration;
import org.apache.activemq.artemis.core.config.ha.ReplicationPrimaryPolicyConfiguration;
import org.apache.activemq.artemis.quorum.file.FileBasedPrimitiveManager;
import org.apache.activemq.artemis.tests.integration.cluster.failover.ReplicaTimeoutTest;
import org.apache.activemq.artemis.tests.util.ReplicatedBackupUtils;

public class PluggableQuorumReplicaTimeoutTest
extends ReplicaTimeoutTest {
    @Override
    protected void configureReplicationPair(Configuration backupConfig, Configuration liveConfig, TransportConfiguration backupConnector, TransportConfiguration backupAcceptor, TransportConfiguration liveConnector) throws IOException {
        DistributedPrimitiveManagerConfiguration managerConfiguration = new DistributedPrimitiveManagerConfiguration(FileBasedPrimitiveManager.class.getName(), Collections.singletonMap("locks-folder", this.temporaryFolder.newFolder("manager").toString()));
        ReplicatedBackupUtils.configurePluggableQuorumReplicationPair(backupConfig, backupConnector, backupAcceptor, liveConfig, liveConnector, null, managerConfiguration, managerConfiguration);
        ReplicationPrimaryPolicyConfiguration primaryConfiguration = (ReplicationPrimaryPolicyConfiguration)liveConfig.getHAPolicyConfiguration();
        primaryConfiguration.setInitialReplicationSyncTimeout(1000L);
        ReplicationBackupPolicyConfiguration backupConfiguration = (ReplicationBackupPolicyConfiguration)backupConfig.getHAPolicyConfiguration();
        backupConfiguration.setInitialReplicationSyncTimeout(1000L);
        backupConfiguration.setMaxSavedReplicatedJournalsSize(2).setAllowFailBack(true);
    }

    @Override
    protected boolean expectLiveSuicide() {
        return false;
    }
}

